/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGStyleElement.h"

#include "KURL.h"
#include "SVGStyleElement.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGStyleElement);

/* Hash table */

static const HashTableValue JSSVGStyleElementTableValues[6] =
{
    { "type", DontDelete, (intptr_t)jsSVGStyleElementType, (intptr_t)setJSSVGStyleElementType },
    { "media", DontDelete, (intptr_t)jsSVGStyleElementMedia, (intptr_t)setJSSVGStyleElementMedia },
    { "title", DontDelete, (intptr_t)jsSVGStyleElementTitle, (intptr_t)setJSSVGStyleElementTitle },
    { "xmllang", DontDelete, (intptr_t)jsSVGStyleElementXmllang, (intptr_t)setJSSVGStyleElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGStyleElementXmlspace, (intptr_t)setJSSVGStyleElementXmlspace },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGStyleElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGStyleElementTableValues, 0 };
#else
    { 17, 15, JSSVGStyleElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGStyleElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGStyleElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGStyleElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGStyleElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGStyleElementPrototype::s_info = { "SVGStyleElementPrototype", 0, &JSSVGStyleElementPrototypeTable, 0 };

JSObject* JSSVGStyleElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGStyleElement>(exec, globalObject);
}

const ClassInfo JSSVGStyleElement::s_info = { "SVGStyleElement", &JSSVGElement::s_info, &JSSVGStyleElementTable, 0 };

JSSVGStyleElement::JSSVGStyleElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGStyleElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGStyleElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGStyleElementPrototype(JSSVGStyleElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGStyleElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGStyleElement, Base>(exec, &JSSVGStyleElementTable, this, propertyName, slot);
}

bool JSSVGStyleElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGStyleElement, Base>(exec, &JSSVGStyleElementTable, this, propertyName, descriptor);
}

JSValue jsSVGStyleElementType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    return jsString(exec, imp->type());
}

JSValue jsSVGStyleElementMedia(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    return jsString(exec, imp->media());
}

JSValue jsSVGStyleElementTitle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    return jsString(exec, imp->title());
}

JSValue jsSVGStyleElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    return jsString(exec, imp->xmllang());
}

JSValue jsSVGStyleElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    return jsString(exec, imp->xmlspace());
}

void JSSVGStyleElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGStyleElement, Base>(exec, propertyName, value, &JSSVGStyleElementTable, this, slot);
}

void setJSSVGStyleElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setType(value.toString(exec), ec);
    setDOMException(exec, ec);
}

void setJSSVGStyleElementMedia(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setMedia(value.toString(exec), ec);
    setDOMException(exec, ec);
}

void setJSSVGStyleElementTitle(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setTitle(value.toString(exec), ec);
    setDOMException(exec, ec);
}

void setJSSVGStyleElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(thisObject)->impl());
    imp->setXmllang(value.toString(exec));
}

void setJSSVGStyleElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(thisObject)->impl());
    imp->setXmlspace(value.toString(exec));
}


}

#endif // ENABLE(SVG)
