/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-François Wauthy (pollux@xfce.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef	__XFPRINT_INPUT_PAGE_H__
#define	__XFPRINT_INPUT_PAGE_H__

#include <gtk/gtk.h>
#include <xfprintsettings.h>

#ifdef	__cplusplus
extern "C"
{
#endif                          /* !__cplusplus */

#define INPUT_PAGE(obj)							\
	G_TYPE_CHECK_INSTANCE_CAST(obj, input_page_get_type(), InputPage)
#define INPUT_PAGE_CLASS(klass)						\
	G_TYPE_CHECK_CLASS_CAST(klass, input_page_get_type(), InputPage)
#define INPUT_IS_PAGE(obj)						\
	G_TYPE_CHECK_INSTANCE_TYPE(obj, input_page_get_type())

  typedef struct _InputPage InputPage;
  typedef struct _InputPageClass InputPageClass;

  struct _InputPage
  {
    GtkVBox box;

    GtkWidget *encoding;
    GtkWidget *all;
    GtkWidget *range;
    GtkWidget *from;
    GtkWidget *to;
    GtkWidget *cut;
    GtkWidget *interpret;
    GtkWidget *binary;
  };

  struct _InputPageClass
  {
    GtkVBoxClass parent_class;
  };

  extern GtkType input_page_get_type (void);
  extern GtkWidget *input_page_new (void);
  extern void input_page_set_settings (InputPage *, const XfprintSettingsInput *);
  extern void input_page_get_settings (InputPage *, XfprintSettingsInput *);

#ifdef	__cplusplus
}
#endif                          /* !__cplusplus */

#endif                          /* !__XFPRINT_INPUT_PAGE_H__ */
