/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 1.48 $ of : mfd-top.m2c,v $ 
 *
 * $Id: ipv6InterfaceTable.c 15946 2007-03-12 21:28:23Z dts12 $
 */
/** \page MFD helper for ipv6InterfaceTable
 *
 * \section intro Introduction
 * Introductory text.
 *
 */
/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "ipv6InterfaceTable.h"

#include <net-snmp/agent/mib_modules.h>

#include "ipv6InterfaceTable_interface.h"

oid             ipv6InterfaceTable_oid[] = { IPV6INTERFACETABLE_OID };
int             ipv6InterfaceTable_oid_size =
OID_LENGTH(ipv6InterfaceTable_oid);

ipv6InterfaceTable_registration ipv6InterfaceTable_user_context;

void            initialize_table_ipv6InterfaceTable(void);
void            shutdown_table_ipv6InterfaceTable(void);


/**
 * Initializes the ipv6InterfaceTable module
 */
void
init_ipv6InterfaceTable(void)
{
    DEBUGMSGTL(("verbose:ipv6InterfaceTable:init_ipv6InterfaceTable",
                "called\n"));

    /*
     * TODO:300:o: Perform ipv6InterfaceTable one-time module initialization.
     */

    /*
     * we depend on the ifTable, so we put our init in with it
     * to guarantee order of execution.
     */
    init_ifTable();

    /*
     * last changed should be 0 at startup
     */
    ipv6InterfaceTable_lastChange_set(0);

}                               /* init_ipv6InterfaceTable */

/**
 * Shut-down the ipv6InterfaceTable module (agent is exiting)
 */
void
shutdown_ipv6InterfaceTable(void)
{
    if (should_init("ipv6InterfaceTable"))
        shutdown_table_ipv6InterfaceTable();

}

/**
 * Initialize the table ipv6InterfaceTable 
 *    (Define its contents and how it's structured)
 */
void
initialize_table_ipv6InterfaceTable(void)
{
    ipv6InterfaceTable_registration *user_context;
    u_long          flags;

    DEBUGMSGTL(("verbose:ipv6InterfaceTable:initialize_table_ipv6InterfaceTable", "called\n"));

    /*
     * TODO:301:o: Perform ipv6InterfaceTable one-time table initialization.
     */

    /*
     * TODO:302:o: |->Initialize ipv6InterfaceTable user context
     * if you'd like to pass in a pointer to some data for this
     * table, allocate or set it up here.
     */
    /*
     * a netsnmp_data_list is a simple way to store void pointers. A simple
     * string token is used to add, find or remove pointers.
     */
    user_context =
        netsnmp_create_data_list("ipv6InterfaceTable", NULL, NULL);

    /*
     * No support for any flags yet, but in the future you would
     * set any flags here.
     */
    flags = 0;

    /*
     * call interface initialization code
     */
    _ipv6InterfaceTable_initialize_interface(user_context, flags);
}                               /* initialize_table_ipv6InterfaceTable */

/**
 * Shutdown the table ipv6InterfaceTable 
 */
void
shutdown_table_ipv6InterfaceTable(void)
{
    /*
     * call interface shutdown code
     */
    _ipv6InterfaceTable_shutdown_interface
        (&ipv6InterfaceTable_user_context);
}

/**
 * extra context initialization (eg default values)
 *
 * @param rowreq_ctx    : row request context
 * @param user_init_ctx : void pointer for user (parameter to rowreq_ctx_allocate)
 *
 * @retval MFD_SUCCESS  : no errors
 * @retval MFD_ERROR    : error (context allocate will fail)
 */
int
ipv6InterfaceTable_rowreq_ctx_init(ipv6InterfaceTable_rowreq_ctx *
                                   rowreq_ctx, void *user_init_ctx)
{
    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceTable_rowreq_ctx_init", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:210:o: |-> Perform extra ipv6InterfaceTable rowreq initialization. (eg DEFVALS)
     */

    return MFD_SUCCESS;
}                               /* ipv6InterfaceTable_rowreq_ctx_init */

/**
 * extra context cleanup
 * @param rowreq_ctx
 */
void
ipv6InterfaceTable_rowreq_ctx_cleanup(ipv6InterfaceTable_rowreq_ctx *
                                      rowreq_ctx)
{
    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceTable_rowreq_ctx_cleanup", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:211:o: |-> Perform extra ipv6InterfaceTable rowreq cleanup.
     */
}                               /* ipv6InterfaceTable_rowreq_ctx_cleanup */

/**
 * pre-request callback
 *
 * @param user_context
 *
 * @retval MFD_SUCCESS              : success.
 * @retval MFD_ERROR                : other error
 */
int
ipv6InterfaceTable_pre_request(ipv6InterfaceTable_registration *
                               user_context)
{
    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceTable_pre_request", "called\n"));

    /*
     * TODO:510:o: Perform ipv6InterfaceTable pre-request actions.
     */

    return MFD_SUCCESS;
}                               /* ipv6InterfaceTable_pre_request */

/**
 * post-request callback
 *
 * Note:
 *   New rows have been inserted into the container, and
 *   deleted rows have been removed from the container and
 *   released.
 * @param user_context
 * @param rc : MFD_SUCCESS if all requests succeeded
 *
 * @retval MFD_SUCCESS : success.
 * @retval MFD_ERROR   : other error (ignored)
 */
int
ipv6InterfaceTable_post_request(ipv6InterfaceTable_registration *
                                user_context, int rc)
{
    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceTable_post_request", "called\n"));

    /*
     * TODO:511:o: Perform ipv6InterfaceTable post-request actions.
     */

    /*
     * check to set if any rows were changed.
     */
    if (ipv6InterfaceTable_dirty_get()) {
        /*
         * check if request was successful. If so, this would be
         * a good place to save data to its persistent store.
         */
        if (MFD_SUCCESS == rc) {
            /*
             * save changed rows, if you haven't already
             */
        }

        ipv6InterfaceTable_dirty_set(0);        /* clear table dirty flag */
    }

    return MFD_SUCCESS;
}                               /* ipv6InterfaceTable_post_request */


/**********************************************************************
 **********************************************************************
 ***
 *** Table ipv6InterfaceTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * IP-MIB::ipv6InterfaceTable is subid 30 of ip.
 * Its status is Current.
 * OID: .1.3.6.1.2.1.4.30, length: 8
 */

/*
 * ---------------------------------------------------------------------
 * * TODO:200:r: Implement ipv6InterfaceTable data context functions.
 */



/*---------------------------------------------------------------------
 * IP-MIB::ipv6InterfaceEntry.ipv6InterfaceReasmMaxSize
 * ipv6InterfaceReasmMaxSize is subid 2 of ipv6InterfaceEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.30.1.2
 * Description:
The size of the largest IPv6 datagram which this entity can
            re-assemble from incoming IPv6 fragmented datagrams received
            on this interface.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 1      hashint   0
 *   settable   0
 *
 * Ranges:  1500 - 65535;
 *
 * Its syntax is UNSIGNED32 (based on perltype UNSIGNED32)
 * The net-snmp type is ASN_UNSIGNED. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipv6InterfaceReasmMaxSize data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipv6InterfaceReasmMaxSize_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipv6InterfaceReasmMaxSize_get(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx,
                              u_long * ipv6InterfaceReasmMaxSize_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipv6InterfaceReasmMaxSize_val_ptr);


    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceReasmMaxSize_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    if (!
        (rowreq_ctx->data.ifentry->
         ns_flags & NETSNMP_INTERFACE_FLAGS_HAS_V6_REASMMAX))
        return MFD_SKIP;

    /*
     * TODO:231:o: |-> Extract the current value of the ipv6InterfaceReasmMaxSize data.
     * copy (* ipv6InterfaceReasmMaxSize_val_ptr ) from rowreq_ctx->data
     */
    (*ipv6InterfaceReasmMaxSize_val_ptr) =
        rowreq_ctx->data.ipv6InterfaceReasmMaxSize;

    return MFD_SUCCESS;
}                               /* ipv6InterfaceReasmMaxSize_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipv6InterfaceEntry.ipv6InterfaceIdentifier
 * ipv6InterfaceIdentifier is subid 3 of ipv6InterfaceEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.30.1.3
 * Description:
The Interface Identifier for this interface.  The Interface
            Identifier is combined with an address prefix to form an
            interface address.


            By default, the Interface Identifier is auto-configured
            according to the rules of the link type this interface is
            attached to.


            A zero length identifier may be used where appropriate.  One
            possible example is a loopback interface.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 1      hashint   1
 *   settable   0
 *   hint: 2x:
 *
 * Ranges:  0 - 8;
 *
 * Its syntax is Ipv6AddressIfIdentifierTC (based on perltype OCTETSTR)
 * The net-snmp type is ASN_OCTET_STR. The C type decl is char (char)
 * This data type requires a length.  (Max 8)
 */
/**
 * Extract the current value of the ipv6InterfaceIdentifier data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipv6InterfaceIdentifier_val_ptr_ptr
 *        Pointer to storage for a char variable
 * @param ipv6InterfaceIdentifier_val_ptr_len_ptr
 *        Pointer to a size_t. On entry, it will contain the size (in bytes)
 *        pointed to by ipv6InterfaceIdentifier.
 *        On exit, this value should contain the data size (in bytes).
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
*
 * @note If you need more than (*ipv6InterfaceIdentifier_val_ptr_len_ptr) bytes of memory,
 *       allocate it using malloc() and update ipv6InterfaceIdentifier_val_ptr_ptr.
 *       <b>DO NOT</b> free the previous pointer.
 *       The MFD helper will release the memory you allocate.
 *
 * @remark If you call this function yourself, you are responsible
 *         for checking if the pointer changed, and freeing any
 *         previously allocated memory. (Not necessary if you pass
 *         in a pointer to static memory, obviously.)
 */
int
ipv6InterfaceIdentifier_get(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx,
                            char **ipv6InterfaceIdentifier_val_ptr_ptr,
                            size_t
                            * ipv6InterfaceIdentifier_val_ptr_len_ptr)
{
   /** we should have a non-NULL pointer and enough storage */
    netsnmp_assert((NULL != ipv6InterfaceIdentifier_val_ptr_ptr)
                   && (NULL != *ipv6InterfaceIdentifier_val_ptr_ptr));
    netsnmp_assert(NULL != ipv6InterfaceIdentifier_val_ptr_len_ptr);


    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceIdentifier_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    if (!
        (rowreq_ctx->data.ifentry->
         ns_flags & NETSNMP_INTERFACE_FLAGS_HAS_V6_IFID))
        return MFD_SKIP;

    /*
     * TODO:231:o: |-> Extract the current value of the ipv6InterfaceIdentifier data.
     * copy (* ipv6InterfaceIdentifier_val_ptr_ptr ) data and (* ipv6InterfaceIdentifier_val_ptr_len_ptr ) from rowreq_ctx->data
     */
    /*
     * make sure there is enough space for ipv6InterfaceIdentifier data
     */
    if ((NULL == (*ipv6InterfaceIdentifier_val_ptr_ptr)) ||
        ((*ipv6InterfaceIdentifier_val_ptr_len_ptr) <
         (rowreq_ctx->data.ipv6InterfaceIdentifier_len *
          sizeof(rowreq_ctx->data.ipv6InterfaceIdentifier[0])))) {
        /*
         * allocate space for ipv6InterfaceIdentifier data
         */
        (*ipv6InterfaceIdentifier_val_ptr_ptr) =
            malloc(rowreq_ctx->data.ipv6InterfaceIdentifier_len *
                   sizeof(rowreq_ctx->data.ipv6InterfaceIdentifier[0]));
        if (NULL == (*ipv6InterfaceIdentifier_val_ptr_ptr)) {
            snmp_log(LOG_ERR, "could not allocate memory\n");
            return MFD_ERROR;
        }
    }
    (*ipv6InterfaceIdentifier_val_ptr_len_ptr) =
        rowreq_ctx->data.ipv6InterfaceIdentifier_len *
        sizeof(rowreq_ctx->data.ipv6InterfaceIdentifier[0]);
    memcpy((*ipv6InterfaceIdentifier_val_ptr_ptr),
           rowreq_ctx->data.ipv6InterfaceIdentifier,
           rowreq_ctx->data.ipv6InterfaceIdentifier_len *
           sizeof(rowreq_ctx->data.ipv6InterfaceIdentifier[0]));

    return MFD_SUCCESS;
}                               /* ipv6InterfaceIdentifier_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipv6InterfaceEntry.ipv6InterfaceEnableStatus
 * ipv6InterfaceEnableStatus is subid 5 of ipv6InterfaceEntry.
 * Its status is Current, and its access level is ReadWrite.
 * OID: .1.3.6.1.2.1.4.30.1.5
 * Description:
The indication of whether IPv6 is enabled (up) or disabled
            (down) on this interface.  This object does not affect the
            state of the interface itself, only its connection to an
            IPv6 stack.  The IF-MIB should be used to control the state
            of the interface.


            When this object is written the entity SHOULD save the
            change to non-volatile storage and restore the object from
            non-volatile storage upon re-initialization of the system.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  1      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 * Enum range: 1/8. Values:  up(1), down(2)
 *
 * Its syntax is INTEGER (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 */
/**
 * Extract the current value of the ipv6InterfaceEnableStatus data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipv6InterfaceEnableStatus_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipv6InterfaceEnableStatus_get(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx,
                              u_long * ipv6InterfaceEnableStatus_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipv6InterfaceEnableStatus_val_ptr);


    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceEnableStatus_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipv6InterfaceEnableStatus data.
     * copy (* ipv6InterfaceEnableStatus_val_ptr ) from rowreq_ctx->data
     */
    (*ipv6InterfaceEnableStatus_val_ptr) =
        rowreq_ctx->data.ipv6InterfaceEnableStatus;

    return MFD_SUCCESS;
}                               /* ipv6InterfaceEnableStatus_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipv6InterfaceEntry.ipv6InterfaceReachableTime
 * ipv6InterfaceReachableTime is subid 6 of ipv6InterfaceEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.30.1.6
 * Description:
The time a neighbor is considered reachable after receiving
            a reachability confirmation.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is UNSIGNED32 (based on perltype UNSIGNED32)
 * The net-snmp type is ASN_UNSIGNED. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipv6InterfaceReachableTime data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipv6InterfaceReachableTime_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipv6InterfaceReachableTime_get(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx,
                               u_long * ipv6InterfaceReachableTime_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipv6InterfaceReachableTime_val_ptr);


    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceReachableTime_get", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    if (!
        (rowreq_ctx->data.ifentry->
         ns_flags & NETSNMP_INTERFACE_FLAGS_HAS_V6_REACHABLE))
        return MFD_SKIP;

    /*
     * TODO:231:o: |-> Extract the current value of the ipv6InterfaceReachableTime data.
     * copy (* ipv6InterfaceReachableTime_val_ptr ) from rowreq_ctx->data
     */
    (*ipv6InterfaceReachableTime_val_ptr) =
        rowreq_ctx->data.ipv6InterfaceReachableTime;

    return MFD_SUCCESS;
}                               /* ipv6InterfaceReachableTime_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipv6InterfaceEntry.ipv6InterfaceRetransmitTime
 * ipv6InterfaceRetransmitTime is subid 7 of ipv6InterfaceEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.30.1.7
 * Description:
The time between retransmissions of Neighbor Solicitation
            messages to a neighbor when resolving the address or when
            probing the reachability of a neighbor.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is UNSIGNED32 (based on perltype UNSIGNED32)
 * The net-snmp type is ASN_UNSIGNED. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipv6InterfaceRetransmitTime data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipv6InterfaceRetransmitTime_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipv6InterfaceRetransmitTime_get(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx,
                                u_long *
                                ipv6InterfaceRetransmitTime_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipv6InterfaceRetransmitTime_val_ptr);


    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceRetransmitTime_get", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    if (!
        (rowreq_ctx->data.ifentry->
         ns_flags & NETSNMP_INTERFACE_FLAGS_HAS_V6_RETRANSMIT))
        return MFD_SKIP;

    /*
     * TODO:231:o: |-> Extract the current value of the ipv6InterfaceRetransmitTime data.
     * copy (* ipv6InterfaceRetransmitTime_val_ptr ) from rowreq_ctx->data
     */
    (*ipv6InterfaceRetransmitTime_val_ptr) =
        rowreq_ctx->data.ipv6InterfaceRetransmitTime;

    return MFD_SUCCESS;
}                               /* ipv6InterfaceRetransmitTime_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipv6InterfaceEntry.ipv6InterfaceForwarding
 * ipv6InterfaceForwarding is subid 8 of ipv6InterfaceEntry.
 * Its status is Current, and its access level is ReadWrite.
 * OID: .1.3.6.1.2.1.4.30.1.8
 * Description:
The indication of whether this entity is acting as an IPv6
            router on this interface with respect to the forwarding of
            datagrams received by, but not addressed to, this entity.
            IPv6 routers forward datagrams.  IPv6 hosts do not (except
            those source-routed via the host).





            This object is constrained by ipv6IpForwarding and is
            ignored if ipv6IpForwarding is set to notForwarding.  Those
            systems that do not provide per-interface control of the
            forwarding function should set this object to forwarding for
            all interfaces and allow the ipv6IpForwarding object to
            control the forwarding capability.


            When this object is written the entity SHOULD save the
            change to non-volatile storage and restore the object from
            non-volatile storage upon re-initialization of the system.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  1      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 * Enum range: 2/8. Values:  forwarding(1), notForwarding(2)
 *
 * Its syntax is INTEGER (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 */
/**
 * Extract the current value of the ipv6InterfaceForwarding data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipv6InterfaceForwarding_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipv6InterfaceForwarding_get(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx,
                            u_long * ipv6InterfaceForwarding_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipv6InterfaceForwarding_val_ptr);


    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceForwarding_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    if (!
        (rowreq_ctx->data.ifentry->
         ns_flags & NETSNMP_INTERFACE_FLAGS_HAS_V6_FORWARDING))
        return MFD_SKIP;

    /*
     * TODO:231:o: |-> Extract the current value of the ipv6InterfaceForwarding data.
     * copy (* ipv6InterfaceForwarding_val_ptr ) from rowreq_ctx->data
     */
    (*ipv6InterfaceForwarding_val_ptr) =
        rowreq_ctx->data.ipv6InterfaceForwarding;

    return MFD_SUCCESS;
}                               /* ipv6InterfaceForwarding_get */



/** @} */
/**********************************************************************
 **********************************************************************
 ***
 *** Table ipv6InterfaceTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * IP-MIB::ipv6InterfaceTable is subid 30 of ip.
 * Its status is Current.
 * OID: .1.3.6.1.2.1.4.30, length: 8
 */
    /*
     * NOTE: if you update this chart, please update the versions in
     *       local/mib2c-conf.d/parent-set.m2i
     *       agent/mibgroup/helpers/baby_steps.c
     * while you're at it.
     */
    /*
     ***********************************************************************
     * Baby Steps Flow Chart (2004.06.05)                                  *
     *                                                                     *
     * +--------------+    +================+    U = unconditional path    *
     * |optional state|    ||required state||    S = path for success      *
     * +--------------+    +================+    E = path for error        *
     ***********************************************************************
     *
     *                        +--------------+
     *                        |     pre      |
     *                        |   request    |
     *                        +--------------+
     *                               | U
     *                        +==============+
     *       +----------------||  object    ||
     *       |              E ||  lookup    ||
     *       |                +==============+
     *       |                       | S
     *       |                +==============+
     *       |              E ||   check    ||
     *       |<---------------||   values   ||
     *       |                +==============+
     *       |                       | S
     *       |                +==============+
     *       |       +<-------||   undo     ||
     *       |       |      E ||   setup    ||
     *       |       |        +==============+
     *       |       |               | S
     *       |       |        +==============+
     *       |       |        ||    set     ||-------------------------->+
     *       |       |        ||   value    || E                         |
     *       |       |        +==============+                           |
     *       |       |               | S                                 |
     *       |       |        +--------------+                           |
     *       |       |        |    check     |-------------------------->|
     *       |       |        |  consistency | E                         |
     *       |       |        +--------------+                           |
     *       |       |               | S                                 |
     *       |       |        +==============+         +==============+  |
     *       |       |        ||   commit   ||-------->||     undo   ||  |
     *       |       |        ||            || E       ||    commit  ||  |
     *       |       |        +==============+         +==============+  |
     *       |       |               | S                     U |<--------+
     *       |       |        +--------------+         +==============+
     *       |       |        | irreversible |         ||    undo    ||
     *       |       |        |    commit    |         ||     set    ||
     *       |       |        +--------------+         +==============+
     *       |       |               | U                     U |
     *       |       +-------------->|<------------------------+
     *       |                +==============+
     *       |                ||   undo     ||
     *       |                ||  cleanup   ||
     *       |                +==============+
     *       +---------------------->| U
     *                        +--------------+
     *                        |    post      |
     *                        |   request    |
     *                        +--------------+
     *
     */

/**
 * Setup up context with information needed to undo a set request.
 *
 * This function will be called before the individual node undo setup
 * functions are called. If you need to do any undo setup that is not
 * related to a specific column, you can do it here.
 *
 * Note that the undo context has been allocated with
 * ipv6InterfaceTable_allocate_data(), but may need extra
 * initialization similar to what you may have done in
 * ipv6InterfaceTable_rowreq_ctx_init().
 * Note that an individual node's undo_setup function will only be called
 * if that node is being set to a new value.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in the node's undo_setup
 * function, so it won't be done unless it is necessary.
 *
 * @param rowreq_ctx
 *        Pointer to the table context (ipv6InterfaceTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 */
int
ipv6InterfaceTable_undo_setup(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceTable_undo_setup",
                "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:451:M: |-> Setup ipv6InterfaceTable undo.
     * set up ipv6InterfaceTable undo information, in preparation for a set.
     * Undo storage is in (* ipv6InterfaceForwarding_val_ptr )*
     */

    return rc;
}                               /* ipv6InterfaceTable_undo_setup */

/**
 * Undo a set request.
 *
 * This function will be called before the individual node undo
 * functions are called. If you need to do any undo that is not
 * related to a specific column, you can do it here.
 *
 * Note that an individual node's undo function will only be called
 * if that node is being set to a new value.
 *
 * If there is anything  specific to a particular column (e.g. releasing
 * memory for a string), you should do that setup in the node's undo
 * function, so it won't be done unless it is necessary.
 *
 * @param rowreq_ctx
 *        Pointer to the table context (ipv6InterfaceTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 */
int
ipv6InterfaceTable_undo(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceTable_undo",
                "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:451:M: |-> ipv6InterfaceTable undo.
     * ipv6InterfaceTable undo information, in response to a failed set.
     * Undo storage is in (* ipv6InterfaceForwarding_val_ptr )*
     */

    return rc;
}                               /* ipv6InterfaceTable_undo_setup */

/**
 * Cleanup up context undo information.
 *
 * This function will be called after set/commit processing. If you
 * allocated any resources in undo_setup, this is the place to release
 * those resources.
 *
 * This function is called regardless of the success or failure of the set
 * request. If you need to perform different steps for cleanup depending
 * on success or failure, you can add a flag to the rowreq_ctx.
 *
 * @param rowreq_ctx
 *        Pointer to the table context (ipv6InterfaceTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error
 */
int
ipv6InterfaceTable_undo_cleanup(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceTable_undo_cleanup", "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:452:M: |-> Cleanup ipv6InterfaceTable undo.
     * Undo storage is in (* ipv6InterfaceForwarding_val_ptr )*
     */

    return rc;
}                               /* ipv6InterfaceTable_undo_cleanup */

/**
 * commit new values.
 *
 * At this point, you should have done everything you can to ensure that
 * this commit will not fail.
 *
 * Should you need different behavior depending on which columns were
 * set, rowreq_ctx->column_set_flags will indicate which writeable columns were
 * set. The definitions for the COLUMN_*_FLAG bits can be found in
 * ipv6InterfaceTable.h.
 * A new row will have the MFD_ROW_CREATED bit set in rowreq_flags.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error
 */
int
ipv6InterfaceTable_commit(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;
    int             save_flags;

    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceTable_commit",
                "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * save flags, then clear until we actually do something
     */
    save_flags = rowreq_ctx->column_set_flags;
    rowreq_ctx->column_set_flags = 0;

    /*
     * commit ipv6InterfaceTable data
     * 1) check the column's flag in save_flags to see if it was set.
     * 2) clear the flag when you handle that column
     * 3) set the column's flag in column_set_flags if it needs undo
     *    processing in case of a failure.
     */
    if (save_flags & COLUMN_IPV6INTERFACEENABLESTATUS_FLAG) {
        save_flags &= ~COLUMN_IPV6INTERFACEENABLESTATUS_FLAG;   /* clear ipv6InterfaceEnableStatus */
        /*
         * TODO:482:o: |-> commit column ipv6InterfaceEnableStatus.
         */
        rc = -1;
        if (-1 == rc) {
            snmp_log(LOG_ERR,
                     "ipv6InterfaceTable column ipv6InterfaceEnableStatus commit failed\n");
        } else {
            /*
             * set flag, in case we need to undo ipv6InterfaceEnableStatus
             */
            rowreq_ctx->column_set_flags |=
                COLUMN_IPV6INTERFACEENABLESTATUS_FLAG;
        }
    }

    if (save_flags & COLUMN_IPV6INTERFACEFORWARDING_FLAG) {
        save_flags &= ~COLUMN_IPV6INTERFACEFORWARDING_FLAG;     /* clear ipv6InterfaceForwarding */
        /*
         * TODO:482:o: |-> commit column ipv6InterfaceForwarding.
         */
        rc = -1;
        if (-1 == rc) {
            snmp_log(LOG_ERR,
                     "ipv6InterfaceTable column ipv6InterfaceForwarding commit failed\n");
        } else {
            /*
             * set flag, in case we need to undo ipv6InterfaceForwarding
             */
            rowreq_ctx->column_set_flags |=
                COLUMN_IPV6INTERFACEFORWARDING_FLAG;
        }
    }

    /*
     * if we successfully commited this row, set the dirty flag.
     */
    if (MFD_SUCCESS == rc) {
        rowreq_ctx->rowreq_flags |= MFD_ROW_DIRTY;
    }

    if (save_flags) {
        snmp_log(LOG_ERR, "unhandled columns (0x%x) in commit\n",
                 save_flags);
        return MFD_ERROR;
    }

    return rc;
}                               /* ipv6InterfaceTable_commit */

/**
 * undo commit new values.
 *
 * Should you need different behavior depending on which columns were
 * set, rowreq_ctx->column_set_flags will indicate which writeable columns were
 * set. The definitions for the COLUMN_*_FLAG bits can be found in
 * ipv6InterfaceTable.h.
 * A new row will have the MFD_ROW_CREATED bit set in rowreq_flags.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error
 */
int
ipv6InterfaceTable_undo_commit(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceTable_undo_commit", "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:485:M: |-> Undo ipv6InterfaceTable commit.
     * check the column's flag in rowreq_ctx->column_set_flags to see
     * if it was set during commit, then undo it.
     *
     * eg: if (rowreq_ctx->column_set_flags & COLUMN__FLAG) {}
     */


    /*
     * if we successfully un-commited this row, clear the dirty flag.
     */
    if (MFD_SUCCESS == rc) {
        rowreq_ctx->rowreq_flags &= ~MFD_ROW_DIRTY;
    }

    return rc;
}                               /* ipv6InterfaceTable_undo_commit */

/*
 * TODO:440:M: Implement ipv6InterfaceTable node value checks.
 * TODO:450:M: Implement ipv6InterfaceTable undo functions.
 * TODO:460:M: Implement ipv6InterfaceTable set functions.
 * TODO:480:M: Implement ipv6InterfaceTable commit functions.
 */
/*---------------------------------------------------------------------
 * IP-MIB::ipv6InterfaceEntry.ipv6InterfaceEnableStatus
 * ipv6InterfaceEnableStatus is subid 5 of ipv6InterfaceEntry.
 * Its status is Current, and its access level is ReadWrite.
 * OID: .1.3.6.1.2.1.4.30.1.5
 * Description:
The indication of whether IPv6 is enabled (up) or disabled
            (down) on this interface.  This object does not affect the
            state of the interface itself, only its connection to an
            IPv6 stack.  The IF-MIB should be used to control the state
            of the interface.


            When this object is written the entity SHOULD save the
            change to non-volatile storage and restore the object from
            non-volatile storage upon re-initialization of the system.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  1      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 * Enum range: 1/8. Values:  up(1), down(2)
 *
 * Its syntax is INTEGER (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipv6InterfaceEnableStatus_val
 *        A long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * ipv6InterfaceTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_INTEGER
 *    The value is one of  up(1), down(2)
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
ipv6InterfaceEnableStatus_check_value(ipv6InterfaceTable_rowreq_ctx *
                                      rowreq_ctx,
                                      u_long ipv6InterfaceEnableStatus_val)
{
    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceEnableStatus_check_value", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:441:o: |-> Check for valid ipv6InterfaceEnableStatus value.
     */

    return MFD_SUCCESS;         /* ipv6InterfaceEnableStatus value not illegal */
}                               /* ipv6InterfaceEnableStatus_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (ipv6InterfaceTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * ipv6InterfaceTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
ipv6InterfaceEnableStatus_undo_setup(ipv6InterfaceTable_rowreq_ctx *
                                     rowreq_ctx)
{
    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceEnableStatus_undo_setup", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup ipv6InterfaceEnableStatus undo.
     */
    /*
     * copy ipv6InterfaceEnableStatus data
     * set rowreq_ctx->undo->ipv6InterfaceEnableStatus from rowreq_ctx->data.ipv6InterfaceEnableStatus
     */
    rowreq_ctx->undo->ipv6InterfaceEnableStatus =
        rowreq_ctx->data.ipv6InterfaceEnableStatus;


    return MFD_SUCCESS;
}                               /* ipv6InterfaceEnableStatus_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param ipv6InterfaceEnableStatus_val
 *        A long containing the new value.
 */
int
ipv6InterfaceEnableStatus_set(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx,
                              u_long ipv6InterfaceEnableStatus_val)
{

    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceEnableStatus_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:461:M: |-> Set ipv6InterfaceEnableStatus value.
     * set ipv6InterfaceEnableStatus value in rowreq_ctx->data
     */
    rowreq_ctx->data.ipv6InterfaceEnableStatus =
        ipv6InterfaceEnableStatus_val;

    return MFD_SUCCESS;
}                               /* ipv6InterfaceEnableStatus_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
ipv6InterfaceEnableStatus_undo(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceEnableStatus_undo", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up ipv6InterfaceEnableStatus undo.
     */
    /*
     * copy ipv6InterfaceEnableStatus data
     * set rowreq_ctx->data.ipv6InterfaceEnableStatus from rowreq_ctx->undo->ipv6InterfaceEnableStatus
     */
    rowreq_ctx->data.ipv6InterfaceEnableStatus =
        rowreq_ctx->undo->ipv6InterfaceEnableStatus;


    return MFD_SUCCESS;
}                               /* ipv6InterfaceEnableStatus_undo */

/*---------------------------------------------------------------------
 * IP-MIB::ipv6InterfaceEntry.ipv6InterfaceForwarding
 * ipv6InterfaceForwarding is subid 8 of ipv6InterfaceEntry.
 * Its status is Current, and its access level is ReadWrite.
 * OID: .1.3.6.1.2.1.4.30.1.8
 * Description:
The indication of whether this entity is acting as an IPv6
            router on this interface with respect to the forwarding of
            datagrams received by, but not addressed to, this entity.
            IPv6 routers forward datagrams.  IPv6 hosts do not (except
            those source-routed via the host).





            This object is constrained by ipv6IpForwarding and is
            ignored if ipv6IpForwarding is set to notForwarding.  Those
            systems that do not provide per-interface control of the
            forwarding function should set this object to forwarding for
            all interfaces and allow the ipv6IpForwarding object to
            control the forwarding capability.


            When this object is written the entity SHOULD save the
            change to non-volatile storage and restore the object from
            non-volatile storage upon re-initialization of the system.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  1      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 * Enum range: 2/8. Values:  forwarding(1), notForwarding(2)
 *
 * Its syntax is INTEGER (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipv6InterfaceForwarding_val
 *        A long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * ipv6InterfaceTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_INTEGER
 *    The value is one of  forwarding(1), notForwarding(2)
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
ipv6InterfaceForwarding_check_value(ipv6InterfaceTable_rowreq_ctx *
                                    rowreq_ctx,
                                    u_long ipv6InterfaceForwarding_val)
{
    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceForwarding_check_value", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:441:o: |-> Check for valid ipv6InterfaceForwarding value.
     */

    return MFD_SUCCESS;         /* ipv6InterfaceForwarding value not illegal */
}                               /* ipv6InterfaceForwarding_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (ipv6InterfaceTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * ipv6InterfaceTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
ipv6InterfaceForwarding_undo_setup(ipv6InterfaceTable_rowreq_ctx *
                                   rowreq_ctx)
{
    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceForwarding_undo_setup", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup ipv6InterfaceForwarding undo.
     */
    /*
     * copy ipv6InterfaceForwarding data
     * set rowreq_ctx->undo->ipv6InterfaceForwarding from rowreq_ctx->data.ipv6InterfaceForwarding
     */
    rowreq_ctx->undo->ipv6InterfaceForwarding =
        rowreq_ctx->data.ipv6InterfaceForwarding;


    return MFD_SUCCESS;
}                               /* ipv6InterfaceForwarding_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param ipv6InterfaceForwarding_val
 *        A long containing the new value.
 */
int
ipv6InterfaceForwarding_set(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx,
                            u_long ipv6InterfaceForwarding_val)
{

    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceForwarding_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:461:M: |-> Set ipv6InterfaceForwarding value.
     * set ipv6InterfaceForwarding value in rowreq_ctx->data
     */
    rowreq_ctx->data.ipv6InterfaceForwarding = ipv6InterfaceForwarding_val;

    return MFD_SUCCESS;
}                               /* ipv6InterfaceForwarding_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
ipv6InterfaceForwarding_undo(ipv6InterfaceTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:ipv6InterfaceTable:ipv6InterfaceForwarding_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up ipv6InterfaceForwarding undo.
     */
    /*
     * copy ipv6InterfaceForwarding data
     * set rowreq_ctx->data.ipv6InterfaceForwarding from rowreq_ctx->undo->ipv6InterfaceForwarding
     */
    rowreq_ctx->data.ipv6InterfaceForwarding =
        rowreq_ctx->undo->ipv6InterfaceForwarding;


    return MFD_SUCCESS;
}                               /* ipv6InterfaceForwarding_undo */

/** @} */
/** @{ */
