/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;

public abstract class ResourceBundle {
    protected ResourceBundle parent;
    private Locale locale;
    private static Map resourceBundleCache;
    private static Locale lastDefaultLocale;
    private static final Locale emptyLocale;

    private static native ClassLoader getCallingClassLoader();

    public final String getString(String key) {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    public final Object getObject(String key) {
        ResourceBundle bundle = this;
        while (bundle != null) {
            try {
                Object o = bundle.handleGetObject(key);
                if (o != null) {
                    return o;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            bundle = bundle.parent;
        }
        throw new MissingResourceException("Key not found", this.getClass().getName(), key);
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void setParent(ResourceBundle parent) {
        this.parent = parent;
    }

    public static final ResourceBundle getBundle(String baseName) {
        return ResourceBundle.getBundle(baseName, Locale.getDefault(), ResourceBundle.getCallingClassLoader());
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale) {
        return ResourceBundle.getBundle(baseName, locale, ResourceBundle.getCallingClassLoader());
    }

    public static final synchronized ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader) {
        Locale defaultLocale = Locale.getDefault();
        if (defaultLocale != lastDefaultLocale) {
            resourceBundleCache = new HashMap();
            lastDefaultLocale = defaultLocale;
        }
        HashMap cache = (HashMap)resourceBundleCache.get(classLoader);
        StringBuffer sb = new StringBuffer(60);
        sb.append(baseName).append('_').append(locale);
        String name = sb.toString();
        if (cache == null) {
            cache = new HashMap();
            resourceBundleCache.put(classLoader, cache);
        } else if (cache.containsKey(name)) {
            Reference ref = (Reference)cache.get(name);
            Object result = null;
            if (ref == null) {
                throw new MissingResourceException("Bundle " + baseName + " not found", baseName, "");
            }
            ResourceBundle rb = (ResourceBundle)ref.get();
            if (rb != null) {
                return rb;
            }
        }
        ResourceBundle baseBundle = ResourceBundle.tryBundle(baseName, emptyLocale, classLoader, null, cache);
        ResourceBundle bundle = ResourceBundle.tryLocalBundle(baseName, locale, classLoader, baseBundle, cache);
        if (bundle == baseBundle && !locale.equals(defaultLocale)) {
            bundle = ResourceBundle.tryLocalBundle(baseName, defaultLocale, classLoader, baseBundle, cache);
            if (bundle == null) {
                cache.put(name, null);
            } else {
                cache.put(name, new SoftReference(bundle));
            }
        }
        if (bundle == null) {
            throw new MissingResourceException("Bundle " + baseName + " not found", baseName, "");
        }
        return bundle;
    }

    protected abstract Object handleGetObject(String var1);

    public abstract Enumeration getKeys();

    private static final ResourceBundle tryBundle(String localizedName, Locale locale, ClassLoader classloader, ResourceBundle bundle, HashMap cache) {
        if (cache.containsKey(localizedName)) {
            Reference ref = (Reference)cache.get(localizedName);
            Object result = null;
            if (ref == null) {
                return null;
            }
            ResourceBundle rb = (ResourceBundle)ref.get();
            if (rb != null) {
                return rb;
            }
        }
        ResourceBundle foundBundle = null;
        try {
            Class rbClass = classloader == null ? Class.forName(localizedName) : classloader.loadClass(localizedName);
            foundBundle = (ResourceBundle)rbClass.newInstance();
            foundBundle.parent = bundle;
            foundBundle.locale = locale;
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (foundBundle == null) {
            try {
                String resourceName = localizedName.replace('.', '/') + ".properties";
                InputStream is = classloader == null ? ClassLoader.getSystemResourceAsStream(resourceName) : classloader.getResourceAsStream(resourceName);
                if (is != null) {
                    foundBundle = new PropertyResourceBundle(is);
                    foundBundle.parent = bundle;
                    foundBundle.locale = locale;
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (foundBundle == null) {
            foundBundle = bundle;
        }
        if (foundBundle == null) {
            cache.put(localizedName, null);
        } else {
            cache.put(localizedName, new SoftReference(foundBundle));
        }
        return foundBundle;
    }

    private static final ResourceBundle tryLocalBundle(String baseName, Locale locale, ClassLoader classloader, ResourceBundle bundle, HashMap cache) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuffer sb = new StringBuffer(60);
        sb.append(baseName);
        sb.append('_');
        if (language.length() > 0) {
            sb.append(language);
            bundle = ResourceBundle.tryBundle(sb.toString(), new Locale(language), classloader, bundle, cache);
        }
        sb.append('_');
        if (country.length() > 0) {
            sb.append(country);
            bundle = ResourceBundle.tryBundle(sb.toString(), new Locale(language, country), classloader, bundle, cache);
        }
        sb.append('_');
        if (variant.length() > 0) {
            sb.append(variant);
            bundle = ResourceBundle.tryBundle(sb.toString(), locale, classloader, bundle, cache);
        }
        return bundle;
    }

    static {
        emptyLocale = new Locale("");
    }
}

