/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.DummyKeyPairGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;

public abstract class KeyPairGenerator
extends KeyPairGeneratorSpi {
    Provider provider;
    private String algorithm;

    protected KeyPairGenerator(String algorithm) {
        this.algorithm = algorithm;
        this.provider = null;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static KeyPairGenerator getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        for (int i = 0; i < p.length; ++i) {
            try {
                return KeyPairGenerator.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static KeyPairGenerator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return KeyPairGenerator.getInstance(algorithm, p);
    }

    private static KeyPairGenerator getInstance(String algorithm, Provider p) throws NoSuchAlgorithmException {
        String upper;
        String className = p.getProperty("KeyPairGenerator." + algorithm);
        if (className == null && (className = p.getProperty("KeyPairGenerator." + (upper = algorithm.toUpperCase()))) == null) {
            String alias = p.getProperty("Alg.Alias.KeyPairGenerator." + algorithm);
            if (alias == null && (alias = p.getProperty("Alg.Alias.KeyPairGenerator." + upper)) == null) {
                throw new NoSuchAlgorithmException(algorithm);
            }
            className = p.getProperty("KeyPairGenerator." + alias);
            if (className == null) {
                throw new NoSuchAlgorithmException(algorithm);
            }
        }
        return KeyPairGenerator.getInstance(className, algorithm, p);
    }

    private static KeyPairGenerator getInstance(String classname, String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            KeyPairGenerator kpg;
            Object o = Class.forName(classname).newInstance();
            if (o instanceof KeyPairGeneratorSpi) {
                kpg = new DummyKeyPairGenerator((KeyPairGeneratorSpi)o, algorithm);
            } else {
                kpg = (KeyPairGenerator)o;
                kpg.algorithm = algorithm;
            }
            kpg.provider = provider;
            return kpg;
        }
        catch (ClassNotFoundException cnfe) {
            throw new NoSuchAlgorithmException("Class not found");
        }
        catch (InstantiationException ie) {
            throw new NoSuchAlgorithmException("Class instantiation failed");
        }
        catch (IllegalAccessException iae) {
            throw new NoSuchAlgorithmException("Illegal Access");
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void initialize(int keysize) {
        this.initialize(keysize, new SecureRandom());
    }

    public void initialize(int keysize, SecureRandom random) {
        this.initialize(keysize, random);
    }

    public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.initialize(params, new SecureRandom());
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        super.initialize(params, random);
    }

    public final KeyPair genKeyPair() {
        try {
            return KeyPairGenerator.getInstance("DSA", "GNU").generateKeyPair();
        }
        catch (Exception e) {
            System.err.println("genKeyPair failed: " + e);
            e.printStackTrace();
            return null;
        }
    }

    public KeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

