/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.InvalidMarkException;

public abstract class Buffer {
    private int cap;
    private int limit;
    private int pos;
    private int mark;

    private /* synthetic */ void finit$() {
        this.cap = 0;
        this.limit = 0;
        this.pos = 0;
        this.mark = -1;
    }

    Buffer(int capacity, int limit, int position, int mark) {
        this.finit$();
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.cap = capacity;
        this.limit(limit);
        this.position(position);
        if (mark > 0) {
            if (mark > this.pos) {
                throw new IllegalArgumentException();
            }
            this.mark = mark;
        }
    }

    public final int capacity() {
        return this.cap;
    }

    public final Buffer clear() {
        this.limit = this.cap;
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    public final Buffer flip() {
        this.limit = this.pos;
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    public final boolean hasRemaining() {
        return this.limit > this.pos;
    }

    public abstract boolean isReadOnly();

    public final int limit() {
        return this.limit;
    }

    public final Buffer limit(int newLimit) {
        if (newLimit < 0 || newLimit > this.cap) {
            throw new IllegalArgumentException();
        }
        if (newLimit <= this.mark) {
            this.mark = -1;
        }
        if (this.pos > newLimit) {
            this.pos = newLimit - 1;
        }
        this.limit = newLimit;
        return this;
    }

    public final Buffer mark() {
        this.mark = this.pos;
        return this;
    }

    public final int position() {
        return this.pos;
    }

    public final Buffer position(int newPosition) {
        if (newPosition < 0 || newPosition > this.limit) {
            throw new IllegalArgumentException();
        }
        if (newPosition <= this.mark) {
            this.mark = -1;
        }
        this.pos = newPosition;
        return this;
    }

    public final int remaining() {
        return this.limit - this.pos;
    }

    public final Buffer reset() {
        if (this.mark == -1) {
            throw new InvalidMarkException();
        }
        this.pos = this.mark;
        return this;
    }

    public final Buffer rewind() {
        this.pos = 0;
        this.mark = -1;
        return this;
    }
}

