/***************************************************************************
                           flashcardswidget.cpp  -  description
                             -------------------
    begin                : Fri Feb 15 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
***************************************************************************/

#include <klocale.h>
#include <kpushbutton.h>
#include <kguiitem.h>
#include <kdebug.h>

#include <qlabel.h>
#include <qtabwidget.h>
#include <qlayout.h>

#include "flashcardswidget.h"

////////////////////////////////////////////////////////////////////////////////
// public members
////////////////////////////////////////////////////////////////////////////////

FlashCardsWidget::FlashCardsWidget(KStatusBar *statusBar, QWidget *parent, const char *name) : QuizWidget(statusBar, parent, name)
{
  setupLayout();
}

FlashCardsWidget::~FlashCardsWidget()
{

}

////////////////////////////////////////////////////////////////////////////////
// private members
////////////////////////////////////////////////////////////////////////////////

void FlashCardsWidget::setupLayout()
{
  tabWidget = new QTabWidget(this);

  tabWidget->setTabPosition(QTabWidget::Bottom);

  frontLabel = new QLabel(QString::null, tabWidget);
  backLabel = new QLabel(QString::null, tabWidget);

  frontLabel->setAlignment(AlignHCenter | AlignAuto | AlignVCenter | ExpandTabs);
  backLabel->setAlignment(AlignHCenter | AlignAuto | AlignVCenter | ExpandTabs);

  tabWidget->addTab(frontLabel, i18n("Front"));
  tabWidget->addTab(backLabel, i18n("Card backside", "Back"));

  layout()->addWidget(tabWidget);

  KPushButton *nextCardButton = new KPushButton(i18n("Next Card"), this);
  layout()->addWidget(nextCardButton);

  connect(nextCardButton, SIGNAL(clicked()), this, SLOT(getCard()));
}

void FlashCardsWidget::showCard(const Card &card)
{
  tabWidget->setCurrentPage(0);
  frontLabel->setText("<h2>" + card.front() + "</h2>");
  backLabel->setText("<h2>" + card.back() + "</h2>");
}
