/***************************************************************************
                            KEditToolbarWidget.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KEDITTOOLBARWIDGET_H
#define KEDITTOOLBARWIDGET_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KXMLGUIClient.h>
#include <qtobjc/QWidget.h>

/**

 This is a widget used to customize or configure toolbars

 This is the widget that does all of the work for the
 @ref KEditToolbar dialog.  In most cases, you will want to use the
 dialog instead of this widget directly.

 Typically, you would use this widget only if you wanted to embed
 the toolbar editing directly into your existing configure or
 preferences dialog.

 This widget only works if your application uses the XML UI
 framework for creating menus and toolbars.  It depends on the XML
 files to describe the toolbar layouts and it requires the actions
 to determine which buttons are active.

 @author Kurt Granroth <granroth@kde.org>

 @short A widget used to customize or configure toolbars.
*/
@class KActionCollection; 
@class KXMLGUIFactory; 
@class QDomElement; 
@class QListViewItem; 

@interface KEditToolbarWidget : QWidget 

/** 
 Constructor.  This is the only entry point to this class.  You
 @p must pass along your collection of actions (some of which
 appear in your toolbars).  The other three parameters are
 optional.

 The second parameter, @ref  #-xmlfile, is the name (absolute or
 relative) of your application's UI resource file.  If it is
 left blank, then the resource file: share/apps/appname/appnameui.rc
 is used.  This is the same resource file that is used by the
 default createGUI function in KMainWindow so you're usually
 pretty safe in leaving it blank.

 The third parameter, @ref  #-global, controls whether or not the
 global resource file is used.  If this is true, then you may
 edit all of the actions in your toolbars -- global ones and
 local one.  If it is false, then you may edit only your
 application's entries.  The only time you should set this to
 false is if your application does not use the global resource
 file at all (very rare)

 The last parameter, @ref  #-parent, is the standard parent stuff.

*/
- initWithActionCollection: (KActionCollection*)collection file: (NSString *)file global: (BOOL)global parent: (QWidget *)parent;
- initWithActionCollection: (KActionCollection*)collection ;

/** 
 Constructor for KParts based apps.

 The first parameter, @ref  #-factory, is a pointer to the XML GUI
 factory object for your application.  It contains a list of all
 of the GUI clients (along with the action collections and xml
 files) and the toolbar editor uses that.

 The second parameter, @ref  #-parent, is the standard parent

 Use this like so:
 <pre>
 KEditToolbar edit(-factory);
 if ( edit.-exec )
 ...
 </pre>

*/
- initWithXMLGUIFactory: (KXMLGUIFactory*)factory parent: (QWidget *)parent;
- initWithXMLGUIFactory: (KXMLGUIFactory*)factory ;

/** 
 Destructor.  Note that any changes done in this widget will
 @p NOT be saved in the destructor.  You @p must call @ref -save
 to do that.
   
*/
- (void) dealloc;

/** 
 Save any changes the user made.  The file will be in the user's
 local directory (usually $HOME/.kde/share/apps/<appname>).  The
 filename will be the one specified in the constructor.. or the
 made up one if the filename was NULL.

*/
- (BOOL) save;
- setupLayout;
- loadToolbarCombo;
- loadActionList: (QDomElement*)elem;
- updateLocal: (QDomElement*)elem;
- slotToolbarSelected: (NSString *)text;
- slotInactiveSelected: (QListViewItem *)item;
- slotActiveSelected: (QListViewItem *)item;
- slotInsertButton;
- slotRemoveButton;
- slotUpButton;
- slotDownButton;
@end

@class KActionCollection; 
@class KXMLGUIFactory; 
@class QDomElement; 
@class QListViewItem; 

@interface KEditToolbarWidget (KXMLGUIClientImplementation) <KXMLGUIClientInterface>
@end

/** Override these methods in subclasses of KEditToolbarWidget to customise event handling behaviour */
@protocol KEditToolbarWidgetEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
