/***************************************************************************
                            KContextMenuManager.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONTEXTMENUMANAGER_H
#define KCONTEXTMENUMANAGER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**


KContextMenuManager manages configurable context popup menus.  Instead
of reimplementing @ref -[QWidget mousePressEvent] or
@ref -[QWidget mouseReleaseEvent] and/or @ref -[QWidget keyPressEvent], simply
create the popup menu and insert it into the context menu manager with
the static function @ref  #--insert.

Example:
<pre>
    #-include <kcmenumngr.h>
   ...
   -[KContextMenuManager insert]( myWidget, myPopupMenu );
</pre>

Context menus are invoked with either a special shortcut key (usually
the menu key) or the right mouse button.

Menus are configurable in the [ContextMenus] group of the application's
configuration file, usually in kdeglobals:
<pre>
    [ContextMenus]
    ShowOnPress=true|false
</pre>

@p ShowOnPress defines whether the menu shall be shown on mouse
press or on mouse release.

The shortcut key to invoke the context menu is defined in the standard
[Keys] section of the application configuration:
<pre>
   [Keys]
   ...
   PopupContextMenu=Menu
   ...
</pre>
The key can be configured with the standard keys module in the KDE control center.

If the popup menu is invoked with the keyboard shortcut, it's shown at
the position of the micro focus hint of the widget ( @ref -[QWidget microFocusHint] ).

 @author Matthias Ettrich <ettrich@kde.org>

 @version $Id: KContextMenuManager.h,v 1.3 2002/03/15 02:12:19 rdale Exp $

 @short Convenience class to mangage context menus.
*/
@class QPopupMenu; 

@interface KContextMenuManager : QObject 

/** 
       Makes @p popup a context popup menu for widget @p widget.

       Ownership of the popup menu is not transferred to the context
       menu manager.
    
*/
+ insert: (QWidget *)widget popup: (QPopupMenu*)popup;

/** 
 Use this method to get information about when a popup menu
 should be activated. This can be useful if the popup menu is
 to be activated from a listview.

*/
+ (BOOL) showOnButtonPress;
@end

/** Override these methods in subclasses of KContextMenuManager to customise event handling behaviour */
@protocol KContextMenuManagerEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
