/***************************************************************************
                            KGlobal.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Access to the KDE global objects.
 KGlobal provides you with pointers of many central 
 objects that exist only once in the process. It is also
 responsible for managing instances of {@link KStaticDeleterBase}.

 @author Sirtaj Singh Kang (taj@kde.org)

 @version $Id: KGlobal.java,v 1.7 2002/11/26 04:17:32 rdale Exp $
 
 @short *
 Access to the KDE global objects.
*/
public class  KGlobal implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KGlobal(Class dummy){}


/** 
 Returns the global instance.  There is always at least
 one instance of a component in one application (in most
 cases the application itself).

*/
	public static native KInstanceInterface instance();

/** 
  Returns the application standard dirs object.

*/
	public static native KStandardDirs dirs();

/** 
  Returns the general config object.

*/
	public static native KConfig config();

/** 
  Returns an iconloader object.

*/
	public static native KIconLoader iconLoader();

/** 
 Returns the global locale object.

*/
	public static native KLocale locale();

/** 
 The global charset manager.

*/
	public static native KCharsets charsets();

/** 
 Creates a static String.

 To be used inside functions(!) like:
 <pre>
 static String &myString = KGlobal.staticQString("myText");
 </pre>

 !!! Do _NOT_ use: !!!
 <pre>
 static String myString = KGlobal.staticQString("myText");
 </pre>
 This creates a static object (instead of a static reference)
 and as you know static objects are EVIL.

*/
	public static native String staticQString( String str);

/** 
 Creates a static String.

 To be used inside functions(!) like:
 <pre>
 static String &myString = KGlobal.staticQString(i18n("My Text"));
 </pre>

 !!! Do _NOT_ use: !!!
 <pre>
 static String myString = KGlobal.staticQString(i18n("myText"));
 </pre>
 This creates a static object (instead of a static reference)
 and as you know static objects are EVIL.

*/
//	public static native String staticQString( String str);

/** 
 Registers a static deleter.

*/
	public static native void registerStaticDeleter( KStaticDeleterBase d);

/** 
 Unregisters a static deleter.

*/
	public static native void unregisterStaticDeleter( KStaticDeleterBase d);

/** 
 Calls KStaticDeleterBase.destructObject() on all
 registered static deleters and unregisters them all.

*/
	public static native void deleteStaticDeleters();

/** 
 The instance currently active (useful in a multi-instance
 application, such as a KParts application).
 Don't use this - it's mainly for KAboutDialog and KBugReport.

     
*/
	public static native void setActiveInstance( KInstanceInterface d);
	public static native KInstanceInterface activeInstance();
}
