package org.kde.koala;
import org.kde.qt.*;


/** {@link KDirWatch} emits these signals */
public interface KDirWatchSignals {

/** 
 Emitted when a file or directory is created.
    
*/
	void created( String arg1 );
	void destroyed( QObject obj );

/** 
 Emitted when a file or directory is deleted.

 The object is still watched for new creation.
    
*/
	void deleted( String arg1 );

/** 
 Emitted when a watched object is changed.
 For a directory this signal is emitted when files
 therein are created or deleted.
 For a file this signal is emitted when its size or attributes change.

 When you watch a directory, changes in the size or attributes of
 contained files may or may not trigger this signal to be emitted
 depending on which backend is used by KDirWatch.

 The new ctime is set
 before the signal is emitted.
    
*/
	void dirty( String arg1 );
}

