/***************************************************************************
                            kde_KPopupTitle.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPOPUPTITLE
#define KDE_KPOPUPTITLE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Title widget for use in @ref KPopupMenu.

 You usually don't have to create this manually since
 @ref KPopupMenu::insertTitle will do it for you, but it is allowed if
 you wish to customize it's look.

 @author Daniel M. Duley <mosfet@kde.org>

 @short KPopupMenu title widget.
 
*/

/** *
 Constructs a title widget with the user specified gradient, pixmap,
 and colors.
     
*/
kde_KPopupTitle * kde_new_KPopupTitle(qt_QWidget * parent, char* name);

/** *
 Constructs a title widget with the specified gradient and colors.
     
*/
kde_KPopupTitle * kde_new_KPopupTitle1(int gradient, qt_QColor * color, qt_QColor * textColor, qt_QWidget * parent, char* name);

/** *
 Constructs a title widget with the specified pixmap and colors.
     
*/
kde_KPopupTitle * kde_new_KPopupTitle2(kde_KPixmap* background, qt_QColor * color, qt_QColor * textColor, qt_QWidget * parent, char* name);

/** *
 Sets the title string and optional icon for the title widget.

 You will want to call this before inserting into a menu.
     
*/
void kde_KPopupTitle_setTitle(kde_KPopupTitle* instPointer,qt_QString * text, qt_QPixmap * icon);

/** *
 Returns the current title.
     
*/
qt_QString * kde_KPopupTitle_title(kde_KPopupTitle* instPointer);

/** *
 Returns the current icon.
     
*/
qt_QPixmap * kde_KPopupTitle_icon(kde_KPopupTitle* instPointer);
qt_QSize * kde_KPopupTitle_sizeHint(kde_KPopupTitle* instPointer);
void kde_KPopupTitle_setText(kde_KPopupTitle* instPointer,qt_QString * text);
void kde_KPopupTitle_setIcon(kde_KPopupTitle* instPointer,qt_QPixmap * pix);
void kde_KPopupTitle_virtual_hook(kde_KPopupTitle* instPointer,int identifier, void* data);

#endif
