/* srmag.c
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <glib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "srmain.h"
#include "srmag.h"
#include "magxmlapi.h"
#include "libsrconf.h"
#include "srctrl.h"

#undef SRCORE_PANNING_DEBUG

typedef struct
{
	/*________<GENERAL PROPERTIES>_______*/
	/*____________< CURSOR>______________*/
	gboolean	 mag_cursor_state     ;
	gchar		*mag_cursor_name      ;
	gint		 mag_cursor_size      ;
	gboolean 	 mag_cursor_scale     ;	
	glong		 mag_cursor_color     ;
	/*____________</CURSOR>______________*/
	/*___________< CROSSWIRE>____________*/
	gboolean	 mag_crosswire_state  ;
	gboolean	 mag_crosswire_clip   ;
	gint		 mag_crosswire_size   ;
	glong		 mag_crosswire_color  ;
	/*___________</CROSSWIRE>____________*/
	/*________</GENERAL PROPERTIES>______*/

	/*________< ZOOMER PROPERTIES>_______*/
	/*________< ZOOMER  PLACEMENT>_______*/
	gint		 mag_border_width     ;
	glong		 mag_border_color     ;
	gint 		 mag_zp_left	      ;
	gint 		 mag_zp_top	      ;
	gint 		 mag_zp_right	      ;
	gint 		 mag_zp_bottom	      ;
	/*________</ZOOMER  PLACEMENT>_______*/

	/*________< ZOOMER  PARAMETERS>______*/
	gchar		*mag_id;
	gchar 		*mag_source;
	gchar 		*mag_target;
	
	gint		 mag_zoom_factor_x   ;
	gint		 mag_zoom_factor_y   ; 
	gboolean 	 mag_zoom_factor_lock;

/*	float 		contrast*/	
	gboolean	 mag_invert   ;	
	gchar		*mag_smoothing;


	gchar 		*mag_tracking      ;
	gchar 		*mag_mouse_tracking;
	
	gboolean	 mag_visible;
	/*________</ZOOMER  PARAMETERS>______*/
	/*________</ZOOMER PROPERTIES>_______*/
} Magnifier;

extern gboolean src_use_magnifier;
int 		magnifier_initialized 	= 0	;

void
src_magnifier_send (gchar *magoutput)
{
    static gboolean busy = FALSE;

    if (busy)
	return;
    busy = TRUE;
    if (magoutput)
    {
/*	fprintf (stderr,"\nXML:%s",magoutput);*/
	mag_xml_output (magoutput, 
			strlen (magoutput) );
    }
    busy = FALSE;
}

#define SRC_PANNING_REASON_CARET	1
#define SRC_PANNING_REASON_FOCUS	2

gboolean
src_magnifier_automatic_panning (gpointer data)
{
    static gpointer	last = NULL;
    static SRPoint 	point, start_point;  
    static gint reason;
    static SRRectangle	old_location_line;

    SRRectangle 	location_obj, location_line, location_char;
    SRObject 		*obj    = (SRObject *)data;    
    gchar 		*reason_, *magout = NULL;
    gboolean		stop_panning = FALSE;
    int 		step_x  = 2;/*TBR*/

    sro_add_reference (obj);

    if (last != data)
    {
	if (sro_get_reason (obj, &reason_))
	{
	    if (strcmp (reason_, "focus:") == 0)
		reason = SRC_PANNING_REASON_FOCUS;
	    else
		reason = SRC_PANNING_REASON_CARET;
	    SR_freeString (reason_);
	}
	else
	{
	    sro_release_reference (obj);
	    return FALSE;
	}
    }
    

    if (reason == SRC_PANNING_REASON_CARET)
    {
	SRLong index;
	if (!sro_text_get_caret_offset (obj, 
					&index, 
					SR_INDEX_CONTAINER))
	{
	    sro_release_reference (obj);
	    return FALSE;
	}
	if (!sro_text_get_location_at_index (obj, 
					    index, 
					    &location_char, 
					    SR_INDEX_CONTAINER))
	{
	    sro_release_reference (obj);
	    return FALSE;
	}
    }
    
    if (!sro_get_location (obj, SR_COORD_TYPE_SCREEN, &location_obj, SR_INDEX_CONTAINER))
    {
	sro_release_reference (obj);
	return FALSE;
    }

    if (data != last)
    {
	if (reason == SRC_PANNING_REASON_CARET)
	{
	    point.x = location_char.x;
	    point.y = location_char.y;
	    start_point = point;
	}
	else
	{
	    point.x = location_obj.x;
	    point.y = location_obj.y;
	    start_point = point;
	    
/*	    if (location_line.width < 0)
	    {
		point.x += location_obj.width;
		point.y += location_obj.height;
	    }
*/	}
    }
/*    if (point.y > location_obj.y + location_obj.height)
    {
	sro_release_reference (obj);
	stop_panning = TRUE;
    }
*/    
    if (!sro_text_get_text_location_from_point (obj, 
						&point, 
						SR_COORD_TYPE_SCREEN,
						SR_TEXT_BOUNDARY_LINE, 
						&location_line,
						SR_INDEX_CONTAINER))
    {
        sro_release_reference (obj);
        return FALSE;
    }
    old_location_line = location_line;

    if (location_line.width > 0)
    {
	point.x = MAX (0, MAX (point.x, location_line.x));
	point.y = MAX (0, MAX (point.y, location_line.y));
    }
    else
    {
	point.x = MIN (point.x, location_line.x);
	point.y = MIN (point.y, location_line.y);
    }
    
    if (data == last)
    {
	if (location_line.width > 0)
	    point.x += step_x;
	else
	    point.x -= step_x;
    }
    last = data;

    if (location_line.width > 0)
    {
	if (location_obj.x + location_obj.width < point.x || 
	    location_line.x + location_line.width < point.x)
	{
	    point.x = location_obj.x;
	    point.y = location_line.y + location_line.height;
	    if (!sro_text_get_text_location_from_point (obj, 
						&point, 
						SR_COORD_TYPE_SCREEN,
						SR_TEXT_BOUNDARY_LINE, 
						&location_line,
						SR_INDEX_CONTAINER))
	    {
		sro_release_reference (obj);
		return FALSE;
	    }
	    if (location_line.y == old_location_line.y)
		stop_panning = TRUE;
	}
    }
    else
    {
	if (location_line.x + location_line.width > point.x ||
	    location_obj.x > point.x ||
	    0 > point.x)
	{
	    point.x = location_obj.x + location_obj.width;
	    point.y = location_line.y + location_line.height;
	    if (!sro_text_get_text_location_from_point (obj, 
						&point, 
						SR_COORD_TYPE_SCREEN,
						SR_TEXT_BOUNDARY_LINE, 
						&location_line,
						SR_INDEX_CONTAINER))
	    {
		sro_release_reference (obj);
		return FALSE;
	    }
	    if (location_line.y == old_location_line.y)
		stop_panning = TRUE;
	}
    }
    
#ifdef SRCORE_PANNING_DEBUG
    fprintf (stderr,"\n !!!!!!PANNING is running %d %d %d %d  %d %d",
		    location_line.x,
		    location_line.y,
		    location_line.x + location_line.width ,
		    location_line.y + location_line.height,
		    point.x,
		    point.y);
#endif
    if (stop_panning)
	point = start_point;
    magout = g_strdup_printf ("<MAGOUT><ZOOMER ID =\"%s\" tracking=\"%s\" AlignmentX=\"0\" AlignementY=\"0\" ROILeft =\"%d\" ROITop =\"%d\" ROIWidth =\"%d\" ROIHeight=\"%d\"></ZOOMER></MAGOUT>",
				"generic_zoomer",
				"panning",
				point.x, point.y, point.x + 1, point.y + 1);

    src_magnifier_send (magout);
    g_free (magout);
    sro_release_reference (obj);
    if (stop_panning)
	return FALSE;
    return TRUE;
}

gboolean	panning     		= FALSE	;
static SRObject *old_panning = NULL;

static gboolean
src_magnifier_panning (SRObject *obj)
{
    static guint 	panning_handle = 0;
    
    if (panning_handle)
    {
	gtk_timeout_remove (panning_handle);
	panning_handle = 0;
    }
    
    if (old_panning)
	sro_release_reference (old_panning);
    old_panning = obj;
    if (old_panning)
	sro_add_reference (old_panning);

    if (panning)
    {
	panning_handle = gtk_timeout_add (100,
					src_magnifier_automatic_panning,
					old_panning);
    }
    return TRUE;
}


gboolean
src_magnifier_start_panning (SRObject *obj)
{
/*    SRObjectRoles role;*/

    sru_assert (obj);
    
/*    sro_get_role (obj, &role, SR_INDEX_CONTAINER);
    if (role == SR_ROLE_TEXT)*/
    if (sro_is_text (obj, SR_INDEX_CONTAINER) )
    {
	gchar *reason_;
	if (sro_get_reason (obj, &reason_))
	{
	    if (strcmp (reason_, "focus:") == 0 ||
		strcmp (reason_, "object:text-caret-moved") == 0)
	    {
		src_magnifier_panning (obj);
	    }
	    else
	    {
		src_magnifier_panning (NULL);
	    }
	    SR_freeString (reason_);
	}
    }
    else
    {
	src_magnifier_panning (NULL);
    }
    return TRUE;
}

gboolean
src_magnifier_stop_panning ()
{
    src_magnifier_panning (NULL);
    return TRUE;
}


gboolean 
src_magnifier_init ()
{
    int rv = 0;

    rv = mag_xml_init (NULL);

    srconf_unset_key (SRCORE_MAGNIF_SENSITIVE, SRCORE_PATH);
    SET_SRCORE_CONFIG_DATA (SRCORE_MAGNIF_SENSITIVE, 
			    CFGT_BOOL, 
			    &rv);
    if ( rv )
    {
	    magnifier_initialized = 1;
/*		"\n   Use layer 7 of the keypad for magnification commands."
		"\n   +---------------------------------------------------------------+ "
		"\n   | KEYS PRESSED FROM KEYPAD |             ACTION                 | "
		"\n   +--------------------------+------------------------------------+ "
		"\n   | -press \"0\"followed by \"7\"| change to layer 7 (magnifier layer)|"
		"\n   | -press \"8\"               | increase y zoom factor (vertical)  |"
		"\n   | -press \"2\"               | decrease y zoom factor (vertical)  |"
		"\n   | -press \"6\"               | increase x zoom factor (horizontal)|"
		"\n   | -press \"4\"               | decrease x zoom factor (horizontal)|"
		"\n   | -press \"5\"               | toggle between cursors             |"
		"\n   | -press \"Del\"             | invert on/off	                   |"
		"\n   +---------------------------------------------------------------+"
		"\n   !!!Currently working with 1024x768 resolution or bigger.\n");
*/
    }
    else
    {
	    magnifier_initialized = 0;
	    fprintf (stderr, "\n** Magnifier initialization failed."
			     "\n   (Possible cause : 1. You don't have gnome-mag installed"
			     "\n                     2. GNOME_Magnifier.server file is missing)\n");
    }
    old_panning = NULL;
    return rv;    
}

void
src_magnifier_create ()
{

/*
    fprintf (stderr, "\n** Magnifier is trying to begin.\n");
*/
    if (magnifier_initialized)
    {
	    src_magnifier_config_get_settings ();
	    fprintf (stderr, "\n** Magnifier is running.\n");
	    	    
    }

}

void
src_magnifier_terminate ()
{
    mag_xml_terminate();
    fprintf (stderr, "\n** Magnifier terminated.\n");
    if (old_panning)
	sro_release_reference (old_panning);
    old_panning = NULL;
}


static gchar*
src_magnifier_create_mml(const Magnifier *magnifier) 
{
    gchar *mml = NULL;

    if (magnifier == NULL) 			return NULL;
    if (magnifier->mag_cursor_name == NULL) 	return NULL;
    if (magnifier->mag_id == NULL) 		return NULL;

    if (magnifier->mag_source == NULL) 		return NULL;
/*
    if (magnifier->mag_target == NULL) 		return NULL;
*/
    if (magnifier->mag_smoothing == NULL ) 	return NULL;
    if (magnifier->mag_mouse_tracking == NULL)	return NULL;

    mml = g_strdup_printf ( "<MAGOUT cursor=\"%d\""
			    " CursorScale=\"%d\""			    
			    " CursorName=\"%s\""
			    " CursorSize=\"%d\""
			    " CursorColor=\"%ld\""
			    " crosswire=\"%d\""
			    " CrosswireClip=\"%d\""			    
			    " CrosswireSize=\"%d\""
			    " CrosswireColor=\"%ld\">"
			    " <ZOOMER ID=\"%s\" "
			    " source=\"%s\""
			    " BorderWidth=\"%d\""
			    " BorderColor=\"%ld\""
			    " ZPLeft=\"%d\""
			    " ZPTop=\"%d\""
			    " ZPWidth=\"%d\""
			    " ZPHeight=\"%d\""
			    " ZoomFactorX=\"%d\""
			    " ZoomFactorY=\"%d\""
			    " invert=\"%d\""
			    " smoothing=\"%s\""
			    " tracking=\"%s\""
			    " MouseTracking=\"%s\""
			    " visible=\"%d\"></ZOOMER></MAGOUT>",
			    magnifier->mag_cursor_state,
			    magnifier->mag_cursor_scale,
			    magnifier->mag_cursor_name,
			    magnifier->mag_cursor_size,
			    magnifier->mag_cursor_color,

			    magnifier->mag_crosswire_state,
			    magnifier->mag_crosswire_clip,			    
			    magnifier->mag_crosswire_size,
			    magnifier->mag_crosswire_color,

			    magnifier->mag_id,
			    magnifier->mag_source,
			    magnifier->mag_border_width,
			    magnifier->mag_border_color,
			    magnifier->mag_zp_left,
			    magnifier->mag_zp_top,
			    magnifier->mag_zp_right,
			    magnifier->mag_zp_bottom,
			    
			    magnifier->mag_zoom_factor_x,
			    magnifier->mag_zoom_factor_y,

			    magnifier->mag_invert,
			    magnifier->mag_smoothing,
			    
			    magnifier->mag_tracking,
			    magnifier->mag_mouse_tracking,

			    magnifier->mag_visible);
/*
    fprintf (stderr, "\n%s %d : \n%s\n",
		    __FILE__,
		    __LINE__,
		    mml);
*/
    return mml;
}

Magnifier*
src_magnifier_setting_new () 
{
    Magnifier *new_magnifier = NULL;

    new_magnifier = (Magnifier *)g_malloc (sizeof (Magnifier) );

    return new_magnifier;
}

Magnifier *
src_magnifier_load_defaults () 
{
    Magnifier *magnifier = src_magnifier_setting_new ();


    /*______________________< GENERAL PROPERTIES>________________________*/
    /*___________________________< CURSOR>_______________________________*/
    magnifier->mag_cursor_state = DEFAULT_MAGNIFIER_CURSOR		  ;
    magnifier->mag_cursor_name	= g_strdup (DEFAULT_MAGNIFIER_CURSOR_NAME);
    magnifier->mag_cursor_size  = DEFAULT_MAGNIFIER_CURSOR_SIZE		  ;
    magnifier->mag_cursor_scale = DEFAULT_MAGNIFIER_CURSOR_SCALE	  ;
    magnifier->mag_cursor_color = DEFAULT_MAGNIFIER_CURSOR_COLOR	  ;
    /*___________________________</CURSOR>_______________________________*/

    /*__________________________< CROSSWIRE>_____________________________*/
    magnifier->mag_crosswire_state = DEFAULT_MAGNIFIER_CROSSWIRE;
    magnifier->mag_crosswire_clip  = DEFAULT_MAGNIFIER_CROSSWIRE_CLIP ;    
    magnifier->mag_crosswire_size  = DEFAULT_MAGNIFIER_CROSSWIRE_SIZE ;
    magnifier->mag_crosswire_color = DEFAULT_MAGNIFIER_CROSSWIRE_COLOR;
    /*__________________________</CROSSWIRE>_____________________________*/
    /*_______________________</GENERAL PROPERTIES>_______________________*/


    /*_______________________< ZOOMER PROPERTIES>________________________*/
    /*_______________________< ZOOMER  PLACEMENT>________________________*/
    magnifier->mag_border_width	  = DEFAULT_MAGNIFIER_BORDER_WIDTH;
    magnifier->mag_border_color   = DEFAULT_MAGNIFIER_BORDER_COLOR;
    magnifier->mag_zp_left   	  = DEFAULT_MAGNIFIER_ZP_LEFT;
    magnifier->mag_zp_top   	  = DEFAULT_MAGNIFIER_ZP_TOP;
    magnifier->mag_zp_right   	  = DEFAULT_MAGNIFIER_ZP_WIDTH;
    magnifier->mag_zp_bottom   	  = DEFAULT_MAGNIFIER_ZP_HEIGHT;
    /*_______________________</ZOOMER  PLACEMENT>________________________*/

    /*______________________< ZOOMER  PARAMETERS>________________________*/
    magnifier->mag_id = g_strdup ("generic_zoomer");

    magnifier->mag_source = g_strdup (DEFAULT_MAGNIFIER_SOURCE);
    magnifier->mag_target = g_strdup (DEFAULT_MAGNIFIER_TARGET);
    
    magnifier->mag_zoom_factor_x    = DEFAULT_MAGNIFIER_ZOOM_FACTOR_XY ;
    magnifier->mag_zoom_factor_y    = DEFAULT_MAGNIFIER_ZOOM_FACTOR_XY ;
    magnifier->mag_zoom_factor_lock = DEFAULT_MAGNIFIER_ZOOM_FACTOR_LOCK;

    magnifier->mag_invert 	   = DEFAULT_MAGNIFIER_INVERT;
    magnifier->mag_smoothing	   = g_strdup (DEFAULT_MAGNIFIER_SMOOTHING);

    magnifier->mag_tracking 	   = g_strdup (DEFAULT_MAGNIFIER_TRACKING);
    magnifier->mag_mouse_tracking  = g_strdup (DEFAULT_MAGNIFIER_MOUSE_TRACKING);

    magnifier->mag_visible 	   = DEFAULT_MAGNIFIER_VISIBLE;
    /*______________________</ZOOMER  PARAMETERS>________________________*/
    /*______________________</ZOOMER  PROPERTIES>________________________*/
    return magnifier;
}

Magnifier *
src_magnifier_load_values () 
{
    Magnifier *magnifier = src_magnifier_setting_new ();
    gboolean   default_bool_val;
    gint       default_int_val;
/*    gchar     *default_string_val = NULL;*/

    /*_________________________< GENERAL PROPERTIES>__________________________*/
    /*_______________________________< CURSOR>________________________________*/
    default_bool_val = DEFAULT_MAGNIFIER_CURSOR;
    if (!srconf_get_data_with_default (MAGNIFIER_CURSOR, 
				       CFGT_BOOL, 
				       (gpointer)&magnifier->mag_cursor_state, 
				       (gpointer)&default_bool_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;
    
    if (!srconf_get_data_with_default (MAGNIFIER_CURSOR_NAME, 
				      CFGT_STRING, 
				      &magnifier->mag_cursor_name, 
				      (gpointer)DEFAULT_MAGNIFIER_CURSOR_NAME, 
				      MAGNIFIER_CONFIG_PATH)
	) return NULL;

    default_int_val = DEFAULT_MAGNIFIER_CURSOR_SIZE;
    if (!srconf_get_data_with_default (MAGNIFIER_CURSOR_SIZE, 
				       CFGT_INT, 
				       (gpointer)&magnifier->mag_cursor_size, 
				       (gpointer)&default_int_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;

    default_bool_val = DEFAULT_MAGNIFIER_CURSOR_SCALE;
    if (!srconf_get_data_with_default (MAGNIFIER_CURSOR_SCALE, 
				       CFGT_BOOL, 
				       (gpointer)&magnifier->mag_cursor_scale, 
				       (gpointer)&default_bool_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;

    default_int_val = DEFAULT_MAGNIFIER_CURSOR_COLOR;
    if (!srconf_get_data_with_default (MAGNIFIER_CURSOR_COLOR, 
				       CFGT_INT, 
				       (gpointer)&magnifier->mag_cursor_color, 
				       (gpointer)&default_int_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;
    /*______________________________</CURSOR>_________________________________*/

    /*_____________________________< CROSSWIRE>_______________________________*/
    default_int_val = DEFAULT_MAGNIFIER_CROSSWIRE;
    if (!srconf_get_data_with_default (MAGNIFIER_CROSSWIRE, 
				       CFGT_BOOL, 
				       (gpointer)&magnifier->mag_crosswire_state, 
				       (gpointer)&default_bool_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;

    default_bool_val = DEFAULT_MAGNIFIER_CROSSWIRE_CLIP;
    if (!srconf_get_data_with_default (MAGNIFIER_CROSSWIRE_CLIP, 
				       CFGT_BOOL, 
				       (gpointer)&magnifier->mag_crosswire_clip, 
				       (gpointer)&default_bool_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;

    default_int_val = DEFAULT_MAGNIFIER_CROSSWIRE_SIZE;
    if (!srconf_get_data_with_default (MAGNIFIER_CROSSWIRE_SIZE, 
				       CFGT_INT, 
				       (gpointer)&magnifier->mag_crosswire_size, 
				       (gpointer)&default_int_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;

    default_int_val = DEFAULT_MAGNIFIER_CROSSWIRE_COLOR;
    if (!srconf_get_data_with_default (MAGNIFIER_CROSSWIRE_COLOR, 
				       CFGT_INT, 
				       (gpointer)&magnifier->mag_crosswire_color, 
				       (gpointer)&default_int_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;
    /*______________________________</CROSSWIRE>______________________________*/
    /*__________________________</GENERAL PROPERTIES>_________________________*/


    /*__________________________< ZOOMER PROPERTIES>__________________________*/
    /*__________________________< ZOOMER  PLACEMENT>__________________________*/
    default_int_val = DEFAULT_MAGNIFIER_BORDER_WIDTH;
    if (!srconf_get_data_with_default (MAGNIFIER_BORDER_WIDTH, 
				       CFGT_INT, 
				       (gpointer)&magnifier->mag_border_width, 
				       (gpointer)&default_int_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;

    default_int_val = DEFAULT_MAGNIFIER_BORDER_COLOR;
    if (!srconf_get_data_with_default (MAGNIFIER_BORDER_COLOR, 
				       CFGT_INT, 
				       (gpointer)&magnifier->mag_border_color, 
				       (gpointer)&default_int_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;
	
    default_int_val = DEFAULT_MAGNIFIER_ZP_LEFT;
    if (!srconf_get_data_with_default (MAGNIFIER_ZP_LEFT, 
				       CFGT_INT, 
				       (gpointer)&magnifier->mag_zp_left, 
				       (gpointer)&default_int_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;

    default_int_val = DEFAULT_MAGNIFIER_ZP_TOP;
    if (!srconf_get_data_with_default (MAGNIFIER_ZP_TOP, 
				       CFGT_INT, 
				       (gpointer)&magnifier->mag_zp_top, 
				       (gpointer)&default_int_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;

    default_int_val = DEFAULT_MAGNIFIER_ZP_WIDTH;
    if (!srconf_get_data_with_default (MAGNIFIER_ZP_WIDTH, 
				       CFGT_INT, 
				       (gpointer)&magnifier->mag_zp_right, 
				       (gpointer)&default_int_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;

    default_int_val = DEFAULT_MAGNIFIER_ZP_HEIGHT;
    if (!srconf_get_data_with_default (MAGNIFIER_ZP_HEIGHT, 
				       CFGT_INT, 
				       (gpointer)&magnifier->mag_zp_bottom, 
				       (gpointer)&default_int_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;

    /*__________________________</ZOOMER  PLACEMENT>__________________________*/

    /*__________________________< ZOOMER  PARAMETERS>_________________________*/

    magnifier->mag_id = g_strdup ("generic_zoomer");
/*    if (!srconf_get_data_with_default (MAGNIFIER_ID, 
				         CFGT_STRING, 
					 &magnifier->mag_id, 
					 (gpointer)DEFAULT_MAGNIFIER_ID, 
					 MAGNIFIER_CONFIG_PATH)
	 ) return NULL;
*/
    if (!srconf_get_data_with_default (MAGNIFIER_SOURCE, 
				      CFGT_STRING, 
				      &magnifier->mag_source, 
				      (gpointer)DEFAULT_MAGNIFIER_SOURCE, 
				      MAGNIFIER_CONFIG_PATH)
	) return NULL;
    if (!srconf_get_data_with_default (MAGNIFIER_TARGET, 
				      CFGT_STRING, 
				      &magnifier->mag_target, 
				      (gpointer)DEFAULT_MAGNIFIER_TARGET, 
				      MAGNIFIER_CONFIG_PATH)
	) return NULL;



    default_int_val = DEFAULT_MAGNIFIER_ZOOM_FACTOR_XY;
    if (!srconf_get_data_with_default (MAGNIFIER_ZOOM_FACTOR_X, 
				       CFGT_INT, 
				       (gpointer)&magnifier->mag_zoom_factor_x, 
				       (gpointer)&default_int_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;
    if (!srconf_get_data_with_default (MAGNIFIER_ZOOM_FACTOR_Y, 
				       CFGT_INT, 
				       (gpointer)&magnifier->mag_zoom_factor_y, 
				       (gpointer)&default_int_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;

/*    magnifier->mag_zoom_factor_lock = DEFAULT_MAGNIFIER_ZOOM_FACTOR_LOCK;*/


    default_bool_val = DEFAULT_MAGNIFIER_INVERT;
    if (!srconf_get_data_with_default (MAGNIFIER_INVERT, 
				      CFGT_BOOL, 
				      (gpointer)&magnifier->mag_invert, 
				      (gpointer)&default_bool_val, 
				      MAGNIFIER_CONFIG_PATH)
	) return NULL;

    if (!srconf_get_data_with_default (MAGNIFIER_SMOOTHING, 
				      CFGT_STRING, 
				      &magnifier->mag_smoothing, 
				      (gpointer)DEFAULT_MAGNIFIER_SMOOTHING, 
				      MAGNIFIER_CONFIG_PATH)
	) return NULL;

    if (!srconf_get_data_with_default (MAGNIFIER_TRACKING, 
				      CFGT_STRING, 
				      &magnifier->mag_tracking, 
				      (gpointer)DEFAULT_MAGNIFIER_TRACKING, 
				      MAGNIFIER_CONFIG_PATH)
	) return NULL;
    if (!srconf_get_data_with_default (MAGNIFIER_MOUSE_TRACKING, 
				      CFGT_STRING, 
				      &magnifier->mag_mouse_tracking, 
				      (gpointer)DEFAULT_MAGNIFIER_MOUSE_TRACKING, 
				      MAGNIFIER_CONFIG_PATH)
	) return NULL;


    default_bool_val = DEFAULT_MAGNIFIER_VISIBLE;
    if (!srconf_get_data_with_default (MAGNIFIER_VISIBLE, 
				       CFGT_BOOL, 
				       (gpointer)&magnifier->mag_visible, 
				       (gpointer)&default_bool_val, 
				       MAGNIFIER_CONFIG_PATH)
	) return NULL;
	
    default_bool_val = DEFAULT_MAGNIFIER_PANNING;
    if (!srconf_get_data_with_default ( MAGNIFIER_PANNING,
				        CFGT_BOOL, 
					(gpointer)&panning, 
					(gpointer)&default_bool_val, 
					MAGNIFIER_CONFIG_PATH)
	) return NULL; 	

    /*_________________________</ZOOMER  PARAMETERS>__________________________*/
    /*_________________________</ZOOMER  PROPERTIES>__________________________*/

    return magnifier;
}


/**
 * Free Magnifier structure
**/
void
src_magnifier_setting_free (Magnifier* magnifier) 
{
    if (!magnifier) return;

    /*________<GENERAL PROPERTIES>_______*/
    /*____________< CURSOR>______________*/
    if (magnifier->mag_cursor_name)
    {
	g_free (magnifier->mag_cursor_name);
	magnifier->mag_cursor_name = NULL;
    }
    /*____________</CURSOR>______________*/
    /*________</GENERAL PROPERTIES>______*/

    /*________< ZOOMER PROPERTIES>_______*/
    /*________< ZOOMER  PARAMETERS>______*/
    if (magnifier->mag_id)
    {
	g_free (magnifier->mag_id);
	magnifier->mag_id = NULL;
    }
    if (magnifier->mag_source)
    {
	g_free (magnifier->mag_source);
	magnifier->mag_source = NULL;
    }
    if (magnifier->mag_target)
    {
	g_free (magnifier->mag_target);
	magnifier->mag_target = NULL;
    }

    if (magnifier->mag_smoothing)
    {
	g_free (magnifier->mag_smoothing);
	magnifier->mag_smoothing = NULL;
    }


    if (magnifier->mag_tracking)
    {
	g_free (magnifier->mag_tracking);
	magnifier->mag_tracking = NULL;
    }
    if (magnifier->mag_mouse_tracking)
    {
	g_free (magnifier->mag_mouse_tracking);
	magnifier->mag_mouse_tracking = NULL;
    }
    /*________</ZOOMER  PARAMETERS>______*/
    /*________</ZOOMER PROPERTIES>_______*/

    g_free (magnifier);
    magnifier = NULL;
}


gboolean
src_magnifier_config_set_defaults (Magnifier *magnifier) 
{

    if (!srconf_set_data (MAGNIFIER_ZOOM_FACTOR_LOCK,
			  CFGT_BOOL, 
			  (gpointer)&magnifier->mag_zoom_factor_lock,
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;
    if (!srconf_set_data (MAGNIFIER_ZOOM_FACTOR_Y,
			  CFGT_INT, 
			  (gpointer)&magnifier->mag_zoom_factor_y,
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;
    if (!srconf_set_data (MAGNIFIER_ZOOM_FACTOR_X,
			  CFGT_INT, 
			  (gpointer)&magnifier->mag_zoom_factor_x,
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;
	
    if (!srconf_set_data (MAGNIFIER_MOUSE_TRACKING,
			  CFGT_STRING, 
			  (gpointer)magnifier->mag_mouse_tracking,
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;	
    if (!srconf_set_data (MAGNIFIER_TRACKING, 
			  CFGT_STRING, 
			  (gpointer)magnifier->mag_tracking, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;

	
    if (!srconf_set_data (MAGNIFIER_CURSOR,
			  CFGT_BOOL, 
			  (gpointer)&magnifier->mag_cursor_state,
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;
    if (!srconf_set_data (MAGNIFIER_CURSOR_NAME,
			  CFGT_STRING, 
			  (gpointer)magnifier->mag_cursor_name,
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;
    if (!srconf_set_data (MAGNIFIER_CURSOR_SIZE, 
			  CFGT_INT, 
			  (gpointer)&magnifier->mag_cursor_size, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;
    if (!srconf_set_data (MAGNIFIER_CURSOR_SCALE, 
			  CFGT_BOOL, 
			  (gpointer)&magnifier->mag_cursor_scale, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;
	
    if (!srconf_set_data (MAGNIFIER_CURSOR_COLOR, 
			  CFGT_INT, 
			  (gpointer)&magnifier->mag_cursor_color, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;

    if (!srconf_set_data (MAGNIFIER_CROSSWIRE_SIZE, 
			  CFGT_INT, 
			  (gpointer)&magnifier->mag_crosswire_size, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;
    if (!srconf_set_data (MAGNIFIER_CROSSWIRE,
			  CFGT_BOOL,
			  (gpointer)&magnifier->mag_crosswire_state,
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;	
    if (!srconf_set_data (MAGNIFIER_CROSSWIRE_CLIP,
			  CFGT_BOOL,
			  (gpointer)&magnifier->mag_crosswire_clip,
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;
    if (!srconf_set_data (MAGNIFIER_CROSSWIRE_COLOR, 
			  CFGT_INT, 
			  (gpointer)&magnifier->mag_crosswire_color, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;

    if (!srconf_set_data (MAGNIFIER_BORDER_WIDTH, 
			  CFGT_INT, 
			  (gpointer)&magnifier->mag_border_width, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;
    if (!srconf_set_data (MAGNIFIER_BORDER_COLOR, 
			  CFGT_INT, 
			  (gpointer)&magnifier->mag_border_color, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;

    if (!srconf_set_data (MAGNIFIER_ZP_LEFT, 
			  CFGT_INT, 
			  (gpointer)&magnifier->mag_zp_left, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;

    if (!srconf_set_data (MAGNIFIER_ZP_TOP, 
			  CFGT_INT, 
			  (gpointer)&magnifier->mag_zp_top, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;

    if (!srconf_set_data (MAGNIFIER_ZP_WIDTH, 
			  CFGT_INT, 
			  (gpointer)&magnifier->mag_zp_right, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;

    if (!srconf_set_data (MAGNIFIER_ZP_HEIGHT, 
			  CFGT_INT, 
			  (gpointer)&magnifier->mag_zp_bottom, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;

    if (!srconf_set_data (MAGNIFIER_SOURCE, 
			  CFGT_STRING, 
			  (gpointer)magnifier->mag_source, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;
    if (!srconf_set_data (MAGNIFIER_TARGET, 
			  CFGT_STRING, 
			  (gpointer)magnifier->mag_target, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;

	
    if (!srconf_set_data (MAGNIFIER_PANNING,
			  CFGT_BOOL, 
			  (gpointer)&panning, 
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE; 	
    if (!srconf_set_data (MAGNIFIER_INVERT,
			  CFGT_BOOL, 
			  (gpointer)&magnifier->mag_invert,
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;
    if (!srconf_set_data (MAGNIFIER_SMOOTHING,
			  CFGT_STRING, 
			  (gpointer)magnifier->mag_smoothing,
			  MAGNIFIER_CONFIG_PATH)
	) return FALSE;
	
    if (!srconf_set_data (MAGNIFIER_VISIBLE, 
			  CFGT_BOOL, 
			  (gpointer)&magnifier->mag_visible, 
			   MAGNIFIER_CONFIG_PATH)
	) return FALSE;

    
    return TRUE;
}


void
src_magnifier_config_get_defaults () 
{
    Magnifier *magnifier = NULL;

    magnifier = src_magnifier_load_defaults ();
    src_magnifier_config_set_defaults (magnifier);
    src_magnifier_setting_free (magnifier);
}

void
src_magnifier_config_get_settings ()
{
    Magnifier *magnifier = NULL;
    gchar     *xml 	 = NULL;

    magnifier = src_magnifier_load_values ();
    xml       = src_magnifier_create_mml (magnifier);

/*
    fprintf (stderr, "\nCurrent setting XML:%s\n\n", xml);
*/
    src_magnifier_send (xml);

    src_magnifier_setting_free (magnifier);

    g_free (xml);
    xml = NULL;
}
