/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <libgnome/gnome-program.h>
#include <libgnomeui/gnome-ui-init.h>
#include <bonobo/bonobo-window.h>
#include <bonobo/bonobo-main.h>
#include "gul-toolbar.h"
#include "gul-toolbar-bonobo-view.h"
#include "gul-toolbar-tree-model.h"
#include "gul-bonobo-extensions.h"
#include "gul-toolbar-editor.h"
#include <gtk/gtkvbox.h>
#include <gtk/gtkentry.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkcellrenderertext.h>
#include <gtk/gtkcellrendererpixbuf.h>
#include <gtk/gtktreeview.h>

static GtkWidget *entry;
static GulToolbar *tb;
GulTbBonoboView *tbv;
GulTbTreeModel *tbm;
GulTbEditor *tbe;

#define GCONF_KEY "/apps/galeon/UI/Toolbar/setup"

enum
{
	TARGET_GTK_TREE_MODEL_ROW
};
static GtkTargetEntry tree_view_row_targets[] = {
	{ "GTK_TREE_MODEL_ROW", GTK_TARGET_SAME_APP, TARGET_GTK_TREE_MODEL_ROW }
};

static void
apply_clicked_cb (GtkButton *b, gpointer user_data)
{
	const gchar *s = gtk_entry_get_text (GTK_ENTRY (entry));
	gboolean ok = gul_toolbar_parse (tb, s);

	if (!ok)
	{
		g_warning ("Error parsing");
	}
}

static void
toolbar_changed_cb (GulToolbar *tb, gpointer user_data)
{
	gchar *s = gul_toolbar_to_string (tb);
	gtk_entry_set_text (GTK_ENTRY (entry), s);
	g_free (s);
}

static gboolean
win_delete_event_cb (GtkWidget *w, GdkEvent *ev)
{
	gtk_widget_destroy (w);
	g_object_unref (tb);
	g_object_unref (tbv);
	g_object_unref (tbm);

	bonobo_main_quit ();

	return TRUE;
}

static gboolean
start (gpointer data)
{
	BonoboWindow *win;
	BonoboUIContainer *container;
	BonoboUIComponent *ui;
	Bonobo_UIContainer corba_container;
	char *tbpath;
	GtkWidget *b;
	GtkWidget *vbox;
	GtkTreeView *tv;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GulToolbar *avail;

	win = BONOBO_WINDOW (bonobo_window_new ("tbtest", "Toolbar Test"));
	gtk_window_set_default_size (GTK_WINDOW (win), 300, 200);
	container = bonobo_window_get_ui_container (win);
        corba_container = BONOBO_OBJREF (container);
	ui = bonobo_ui_component_new_default ();
	bonobo_ui_component_set_container (ui, 
					   corba_container, 
					   NULL);


	tbpath = gul_bonobo_add_dockitem (ui, "tb1", 1);


	tb = gul_toolbar_new ();
	
	tbv = gul_tb_bonobo_view_new ();
	
	gul_tb_bonobo_view_set_toolbar (tbv, tb);
	gul_tb_bonobo_view_set_path (tbv, ui, tbpath);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox);
	bonobo_window_set_contents (win, vbox);

	entry = gtk_entry_new ();
	gtk_widget_show (entry);
	gtk_box_pack_start (GTK_BOX (vbox), entry, FALSE, TRUE, 0);

	g_signal_connect (tb, "changed", G_CALLBACK (toolbar_changed_cb), NULL);
	if (!gul_toolbar_parse (tb, "zoom"))
	{
		g_print ("Error parsing\n");
	}

	b = gtk_button_new_with_label ("Apply");
	gtk_widget_show (b);
	gtk_box_pack_start (GTK_BOX (vbox), b, FALSE, TRUE, 0);
	g_signal_connect (b, "clicked", G_CALLBACK (apply_clicked_cb), NULL);	
	
	/* the tree view */
	tbm = gul_tb_tree_model_new ();
	gul_tb_tree_model_set_toolbar (tbm, tb);

	tv = GTK_TREE_VIEW (gtk_tree_view_new ());
	gtk_widget_show (GTK_WIDGET (tv));
	gtk_box_pack_start (GTK_BOX (vbox), GTK_WIDGET (tv), TRUE, TRUE, 0);
	
	column = gtk_tree_view_column_new ();
	renderer = gtk_cell_renderer_pixbuf_new ();
	
	gtk_tree_view_column_pack_start (column, renderer, FALSE);
	gtk_tree_view_column_set_attributes (column, renderer,
                                             "pixbuf", GUL_TB_TREE_MODEL_COL_ICON, 
					     NULL);
	
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, renderer,
                                             "text", GUL_TB_TREE_MODEL_COL_NAME, 
					     NULL);
	gtk_tree_view_column_set_title (column,  "Name");
	gtk_tree_view_column_set_resizable (column, TRUE);
	gtk_tree_view_append_column (GTK_TREE_VIEW (tv), column);

	gtk_tree_view_enable_model_drag_source (GTK_TREE_VIEW (tv),
						GDK_BUTTON1_MASK,
						tree_view_row_targets,
						G_N_ELEMENTS (tree_view_row_targets),
						GDK_ACTION_MOVE | GDK_ACTION_COPY);
	gtk_tree_view_enable_model_drag_dest (GTK_TREE_VIEW (tv),
					      tree_view_row_targets,
					      G_N_ELEMENTS (tree_view_row_targets),
					      GDK_ACTION_MOVE | GDK_ACTION_COPY);

	gtk_tree_view_set_model (tv, GTK_TREE_MODEL (tbm));
	
	g_signal_connect (win, "delete-event", G_CALLBACK (win_delete_event_cb), NULL);
	gtk_widget_show (GTK_WIDGET (win));

	gul_toolbar_listen_to_gconf (tb, GCONF_KEY);

	tbe = gul_tb_editor_new ();
	gul_tb_editor_set_toolbar (tbe, tb);
	avail = gul_toolbar_new ();

#define AVAILABLE_TOOLBAR_ITEMS \
	"back=std_toolitem(item=back);" \
	"back_history=navigation_history(direction=back);" \
	"up=std_toolitem(item=up);" \
	"up_history=navigation_history(direction=up);" \
	"forward=std_toolitem(item=forward);" \
	"forward_history=navigation_history(direction=forward);" \
	"stop=std_toolitem(item=stop);" \
	"reload=std_toolitem(item=reload);" \
	"home=std_toolitem(item=home);" \
	"favicon=favicon;" \
	"location=location;" \
	"zoom=zoom;" \
	"spinner=spinner"

	gul_toolbar_parse (avail, AVAILABLE_TOOLBAR_ITEMS);
	gul_tb_editor_set_available (tbe, avail);
	g_object_unref (avail);
	gul_tb_editor_show (tbe);
	
	return FALSE;
}

int
main (int argc, char *argv[])
{

	gnome_program_init (PACKAGE, VERSION,
			    LIBGNOMEUI_MODULE, argc, argv,
			    GNOME_PARAM_HUMAN_READABLE_NAME, "Toolbar Tester",
			    NULL);

	g_idle_add ((GSourceFunc) start, NULL);

	bonobo_main ();

	return 0;
}
