/*
 * libieee1284 - IEEE 1284 library
 * Copyright (C) 2001  Tim Waugh <twaugh@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>

#include "delay.h"

extern const struct parport_access_methods io_access_methods;
extern const struct parport_access_methods ppdev_access_methods;
extern const struct parport_access_methods lpt_access_methods;

static inline void
delay (int which)
{
  struct timeval tv;
  lookup_delay (which, &tv);
  select (0, NULL, NULL, NULL, &tv);
}

/*
 * Local Variables:
 * eval: (c-set-style "gnu")
 * End:
 */
