/*
 *  Copyright (C) 2001-2002, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kjs/interpreter.h>

#include <kjsembed/jsconsolewidget.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/dialogfactory.h>

int main( int argc, char **argv )
{
    KAboutData about( "test-kjsembed", I18N_NOOP("KJS Embed Test"), "0.1",
		      I18N_NOOP("Test"),
		      KAboutData::License_LGPL, I18N_NOOP("(c) 2001-2002 Richard Moore") );
    KCmdLineArgs::init( argc, argv, &about );
    KApplication app;

    // Setup Interpreter
    KJS::Object global( new KJS::ObjectImp() );
    KJS::Interpreter *js = new KJS::Interpreter( global );

    // Create Console Widget
    KJSEmbed::JSConsoleWidget *win = new KJSEmbed::JSConsoleWidget( js );

    // Add Bindings
    win->addBindings( js->globalExec(), global );
    KJSEmbed::DialogFactory::addBindings( js->globalExec(), global );

    KJSEmbed::JSObjectProxy *appProxy = new KJSEmbed::JSObjectProxy( js, &app );
    KJS::Object appObj( appProxy );
    appProxy->addBindings( js->globalExec(), appObj );
    global.put( js->globalExec(), "app", KJS::Object( appProxy ) );

    KJSEmbed::JSObjectProxy *consoleProxy = new KJSEmbed::JSObjectProxy( js, win );
    KJS::Object consoleObj( consoleProxy );
    consoleProxy->addBindings( js->globalExec(), consoleObj );
    global.put( js->globalExec(), "console", KJS::Object( consoleProxy ) );

    // Setup Window
    app.setMainWidget( win );
    app.connect( &app, SIGNAL( lastWindowClosed() ), SLOT(quit()) );
    win->resize( 600, 450 );
    win->show();

    return app.exec();
}

// Local Variables:
// c-basic-offset: 4
// End:
