/***************************************************************************
                            KHTMLPart.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KHTMLPART_H
#define KHTMLPART_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/ReadOnlyPart.h>

/**

 This class is khtml's main class. It features an almost complete
 web browser, and html renderer.

 The easiest way to use this class (if you just want to display a an HTML
 page at some URL) is the following:

 <pre>
 KURL url = "http://www.kde.org";
 KHTMLPart *w = new -KHTMLPart;
 -[w openURL];
 -[w view]->resize(500, 400);
 -[w show];
 </pre>

 By default Java and JavaScript support are disabled. You can enable them by
 using the @ref -setJavaEnabled and @ref -setJScriptEnabled methods.

 Some apps want to write their HTML code directly into the widget instead of
 it opening an url. You can also do that in the following way:

 <pre>
 QString myHTMLCode = ...;
 KHTMLPart *w = new -KHTMLPart;
 -[w begin];
 -[w write];
 ...
 -[w end];
 </pre>

 You can do as many calls to write as you want. But there are two
 @ref -write methods, one accepting a @ref QString one accepting a
 @p char @p * argument. You should use one or the other
 (but not both) since the method using
 the @p char @p * argument does an additional decoding step to convert the
 written data to Unicode.

 @author Lars Knoll (knoll@kde.org)

 @version $Id: KHTMLPart.h,v 1.4 2002/03/23 11:01:20 rdale Exp $
 
 @short HTML Browser Widget.
*/

@class Job;
@class HTMLDocument;
@class DOMDocument;
@class DOMNode;
@class BrowserExtension;
@class KJavaAppletContext;
@class Range;
@class QDataStream;
@class KHTMLSettings;
@class URLArgs;
@class KParts;
@class KHTMLSettings;
@class MouseMoveEvent;
@class MousePressEvent;
@class MouseReleaseEvent;
@class MouseDoubleClickEvent;
@class DrawContentsEvent;
@class KConfig;
@class QColor;
@class KJavaScriptAdvice;
@class KHTMLView;
@class QPainter;
@class QCursor;
@class URLArgs;

@interface KHTMLPart : ReadOnlyPart

/** 
 Constructs a new KHTMLPart.

 KHTML basically consists of two objects: The KHTMLPart itself,
 holding the document data (DOM document), and the @ref KHTMLView,
 derived from @ref QScrollView, in which the document content is
 rendered in. You can specify two different parent objects for a
 KHTMLPart, one parent for the KHTMLPart document and on parent
 for the @ref KHTMLView. If the second @p parent argument is 0L, then
 @p parentWidget is used as parent for both objects, the part and
 the view.
   
*/
- initWithWidget: (QWidget *)parentWidget widgetname: (NSString *)widgetname parent: (QObject *)parent name: (NSString *)name prof: (int)prof;
- init;
- initWithHTMLView: (KHTMLView*)view parent: (QObject *)parent name: (NSString *)name prof: (int)prof;
- initWithHTMLView: (KHTMLView*)view ;

/** 
 Destructor.
   
*/
- (void) dealloc;

/** 
 Opens the specified URL @p url.

 Reimplemented from @ref -[KParts ReadOnlyPart]::openURL .
   
*/
- (BOOL) openURL: (KURL*)url;

/** 
 Stops loading the document and kill all data requests (for images, etc.)
   
*/
- (BOOL) closeURL;

/** 
 is called when a certain error situation (i.e. connection timed out) occured.
 default implementation either shows a KIO error dialog or loads a more verbose
 error description a as page, depending on the users configuration.
 @p job is the job that signaled the error situation
   
*/
- showError: (Job*)job;

/** 
 Returns a reference to the DOM HTML document (for non-HTML documents, returns null)
   
*/
- (HTMLDocument*) htmlDocument;

/** 
 Returns a reference to the DOM document.
   
*/
- (DOMDocument*) document;

/** 
 Returns the node that has the keyboard focus.
   
*/
- (DOMNode*) activeNode;

/** 
 Returns a pointer to the @ref -[KParts BrowserExtension].
   
*/
- (BrowserExtension*) browserExtension;

/** 
 Returns a pointer to the HTML document's view.
   
*/
- (KHTMLView*) view;

/** 
 Enable/disable Javascript support. Note that this will
 in either case permanently override the default usersetting.
 If you want to have the default UserSettings, don't call this
 method.
   
*/
- setJScriptEnabled: (BOOL)enable;

/** 
 Returns @p true if Javascript support is enabled or @p false
 otherwise.
   
*/
- (BOOL) jScriptEnabled;

/** 
 Enable/disable the automatic forwarding by <meta http-equiv="refresh" ....>
   
*/
- setMetaRefreshEnabled: (BOOL)enable;

/** 
 Returns @p true if automtaic forwarding is enabled.
   
*/
- (BOOL) metaRefreshEnabled;

/** 
 Execute the specified snippet of JavaScript code.

 Returns @p true if JavaScript was enabled, no error occured
 and the code returned true itself or @p false otherwise.

   
*/
- (QVariant*) executeScript: (NSString *)script;

/** 
 Same as above except the Node parameter specifying the 'this' value.
   
*/
- (QVariant*) executeScript: (DOMNode*)n script: (NSString *)script;

/** 
 Enables or disables Drag'n'Drop support. A drag operation is started if
 the users drags a link.
   
*/
- setDNDEnabled: (BOOL)b;

/** 
 Returns whether Dragn'n'Drop support is enabled or not.
   
*/
- (BOOL) dndEnabled;

/** 
 Enables/disables Java applet support. Note that calling this function
 will permanently override the User settings about Java applet support.
 Not calling this function is the only way to let the default settings
 apply.
   
*/
- setJavaEnabled: (BOOL)enable;

/** 
 Return if Java applet support is enabled/disabled.
   
*/
- (BOOL) javaEnabled;

/** 
 Returns the java context of the applets. If no applet exists, 0 is returned.
   
*/
- (KJavaAppletContext*) javaContext;

/** 
 Returns the java context of the applets. If no context exists yet, a new one is
 created.
   
*/
- (KJavaAppletContext*) createJavaContext;

/** 
 Enables or disables plugins via, default is enabled
   
*/
- setPluginsEnabled: (BOOL)enable;

/** 
 Returns trie if plugins are enabled/disabled.
   
*/
- (BOOL) pluginsEnabled;

/** 
 Specifies whether images contained in the document should be loaded
 automatically or not.

 @note Request will be ignored if called before @ref -begin.
   
*/
- setAutoloadImages: (BOOL)enable;

/** 
 Returns whether images contained in the document are loaded automatically
 or not.
 @note that the returned information is unrelieable as long as no -begin
 was called.
   
*/
- (BOOL) autoloadImages;

/** 
 Security option.

 Specify whether only local references ( stylesheets, images, scripts, subdocuments )
 should be loaded. ( default false - everything is loaded, if the more specific
 options allow )
   
*/
- setOnlyLocalReferences: (BOOL)enable;

/** 
 Returnd whether references should be loaded ( default false )

*/
- (BOOL) onlyLocalReferences;
- enableJScript: (BOOL)e;
- enableJava: (BOOL)e;
- enablePlugins: (BOOL)e;
- autoloadImages: (BOOL)e;
- enableMetaRefresh: (BOOL)e;
- (BOOL) setCharset: (NSString *)arg1 bool: (BOOL)arg2;
- (KURL*) baseURL;
- (NSString *) baseTarget;

/** 
 Returns the URL for the background Image (used by save background)
   
*/
- (KURL*) backgroundURL;

/** 
 Schedules a redirection after @p delay seconds.
   
*/
- scheduleRedirection: (int)delay url: (NSString *)url lockHistory: (BOOL)lockHistory;
- scheduleRedirection: (int)delay url: (NSString *)url ;

/** 
 Clears the widget and prepares it for new content.

 If you want @ref -url to return
 for example "file:/tmp/test.html", you can use the following code:
 <PRE>
 -[view begin]( KURL("file:/tmp/test.html" ) );
 </PRE>

 All child frames and the old document are removed if you call
 this method.
   
*/
- begin: (KURL*)url xOffset: (int)xOffset yOffset: (int)yOffset;
- begin;

/** 
 Writes another part of the HTML code to the widget.

 You may call
 this function many times in sequence. But remember: The fewer calls
 you make, the faster the widget will be.

 The HTML code is send through a decoder which decodes the stream to
 Unicode.

 The @p len parameter is needed for streams encoded in utf-16,
 since these can have \0 chars in them. In case the encoding
 you're using isn't utf-16, you can safely leave out the length
 parameter.

 Attention: Don't mix calls to @ref write( const char *) with calls
 to @ref write( const QString & ).

 The result might not be what you want.
   
*/
- write: (NSString *)str len: (int)len;
- write: (NSString *)str ;

/** 
 Writes another part of the HTML code to the widget.

 You may call
 this function many times in sequence. But remember: The fewer calls
 you make, the faster the widget will be.
   
*/
- write: (NSString *)str;

/** 
 Call this after your last call to @ref -write.
   
*/
- end;

/** 
 Paints the HTML page to a QPainter. See @ref -[KHTMLView paint]for details
   
*/
- paint: (QPainter *)arg1 rect: (QRect*)arg2 int: (int)arg3 int: (int*)arg4;
- paint: (QPainter *)arg1 rect: (QRect*)arg2 ;

/** 
 Sets the encoding the page uses.

 This can be different from the charset. The widget will try to reload the current page in the new
 encoding, if -url is not empty.
   
*/
- (BOOL) setEncoding: (NSString *)name override: (BOOL)override;
- (BOOL) setEncoding: (NSString *)name ;

/** 
 Returns the encoding the page currently uses.

 Note that the encoding might be different from the charset.
   
*/
- (NSString *) encoding;

/** 
 Sets a user defined style sheet to be used on top of the HTML 4
 default style sheet.

 This gives a wide range of possibilities to
 change the layout of the page.
   
*/
- setUserStyleSheetWithURL: (KURL*)url;

/** 
 Sets a user defined style sheet to be used on top of the HTML 4
 default style sheet.

 This gives a wide range of possibilities to
 change the layout of the page.
   
*/
- setUserStyleSheet: (NSString *)styleSheet;

/** 
 Sets the standard font style.

*/
- setStandardFont: (NSString *)name;

/** 
 Sets the fixed font style.

*/
- setFixedFont: (NSString *)name;

/** 
 Finds the anchor named @p name.

 If the anchor is found, the widget
 scrolls to the closest position. Returns @p if the anchor has
 been found.
   
*/
- (BOOL) gotoAnchor: (NSString *)name;

/** 
 Sets the cursor to use when the cursor is on a link.
   
*/
- setURLCursor: (QCursor *)c;

/** 
 Returns the cursor which is used when the cursor is on a link.
   
*/
- (QCursor*) urlCursor;

/** 
 Initiates a text search.
   
*/
- findTextBegin;

/** 
 Finds the next occurence of the string or expression.
 If isRegExp is true then str is converted to a QRegExp, and caseSensitive is ignored.
   
*/
- (BOOL) findTextNext: (NSString *)str forward: (BOOL)forward caseSensitive: (BOOL)caseSensitive isRegExp: (BOOL)isRegExp;

/** 
 Sets the Zoom factor. The value is given in percent, larger values mean a
 generally larger font and larger page contents. It is not guaranteed that
 all parts of the page are scaled with the same factor though.

 The given value should be in the range of 20..300, values outside that
 range are not guaranteed to work. A value of 100 will disable all zooming
 and show the page with the sizes determined via the given lengths in the
 stylesheets.
   
*/
- setZoomFactor: (int)percent;

/** 
 Returns the current zoom factor.
   
*/
- (int) zoomFactor;

/** 
 Returns the text the user has marked.
   
*/
- (NSString *) selectedText;

/** 
 Returns the selected part of the HTML.
   
*/
- (Range*) selection;

/** 
 Sets the current selection.
   
*/
- setSelection: (int)arg1;

/** 
 Has the user selected anything?

  Call @ref -selectedText to
 retrieve the selected text.

*/
- (BOOL) hasSelection;

/** 
 Marks all text in the document as selected.
   
*/
- selectAll;

/** 
 Convenience method to show the document's view.

 Equivalent to -widget->-show or -view->-show .
   
*/
- show;

/** 
 Convenience method to hide the document's view.

 Equivalent to -widget->-hide or -view->-hide.
   
*/
- hide;

/** 
 Returns a reference to the partmanager instance which
 manages html frame objects.
   
*/
- (PartManager*) partManager;

/** 
 Saves the KHTMLPart's complete state (including child frame
 objects) to the provided @ref QDataStream.

 This is called from the @ref -saveState method of the
  @ref -browserExtension.
   
*/
- saveState: (QDataStream *)stream;

/** 
 Restores the KHTMLPart's previously saved state (including
 child frame objects) from the provided QDataStream.

 This is called from the @ref -restoreState method of the
 @ref -browserExtension .

*/
- restoreState: (QDataStream *)stream;

/** 
 Returns the @p Node currently under the mouse
   
*/
- (DOMNode*) nodeUnderMouse;

/** 

   
*/
- (KHTMLSettings*) settings;

/** 
 Returns a pointer to the parent KHTMLPart if the part is a frame
 in an HTML frameset.

  Returns 0L otherwise.
   
*/
- (KHTMLPart*) parentPart;

/** 
 Returns a list of names of all frame (including iframe) objects of
 the current document. Note that this method is not working recursively
 for sub-frames.
   
*/
- (NSArray *) frameNames;

/** 
 Finds a frame by name. Returns 0L if frame can't be found.
   
*/
- (KHTMLPart*) findFrame: (NSString *)f;

/** 
 Return the current frame (the one that has focus)
 Not necessarily a direct child of ours, framesets can be nested.
 Returns "this" if this part isn't a frameset.
   
*/
- (ReadOnlyPart*) currentFrame;

/** 
 Returns whether a frame with the specified name is exists or not.
 In contrary to the @ref findFrame method this one also returns true
 if the frame is defined but no displaying component has been
 found/loaded, yet.
   
*/
- (BOOL) frameExists: (NSString *)frameName;

/** 
 Called by KJS.
 Sets the StatusBarText assigned
 via window.status
   
*/
- setJSStatusBarText: (NSString *)text;

/** 
 Called by KJS.
 Sets the DefaultStatusBarText assigned
 via window.defaultStatus
   
*/
- setJSDefaultStatusBarText: (NSString *)text;

/** 
 Called by KJS.
 Returns the StatusBarText assigned
 via window.status
   
*/
- (NSString *) jsStatusBarText;

/** 
 Called by KJS.
 Returns the DefaultStatusBarText assigned
 via window.defaultStatus
   
*/
- (NSString *) jsDefaultStatusBarText;

/** 
 Referrer used for links in this page.
   
*/
- (NSString *) referrer;

/** 
 Last-modified date (in raw string format), if received in the [HTTP] headers.
   
*/
- (NSString *) lastModified;

/** 
 Loads a style sheet into the stylesheet cache.
   
*/
- preloadStyleSheet: (NSString *)url stylesheet: (NSString *)stylesheet;

/** 
 Loads a script into the script cache.
   
*/
- preloadScript: (NSString *)url script: (NSString *)script;

/** 

   
*/
- (BOOL) restored;

/** 
 Sets the focussed node of the document to the specified node. If the node is a form control, the control will
 receive focus in the same way that it would if the user had clicked on it or tabbed to it with the keyboard. For
 most other types of elements, there is no visul indiction of whether or not they are focussed.

 See @ref activeNode

*/
- setActiveNode: (DOMNode*)node;

/** 
 Stops all animated images on the current and child pages
   
*/
- stopAnimations;
- (NSString *) dcopObjectId;

/** 
 returns a KURL object for the given url. Use when
 you know what you're doing.
   
*/
- (KURL*) completeURL: (NSString *)url;

/** 
 presents a detailed error message to the user.
 @p errorCode kio error code, eg -[KIO ERR_SERVER_TIMEOUT].
 @p text kio additional information text.
 @p url the url that triggered the error.
   
*/
- htmlError: (int)errorCode text: (NSString *)text reqUrl: (KURL*)reqUrl;

/** 
 Internal empty reimplementation of @ref -[KParts ReadOnlyPart]::openFile .
   
*/
- (BOOL) openFile;
- urlSelected: (NSString *)url button: (int)button state: (int)state _target: (NSString *)_target args: (URLArgs*)args;
- urlSelected: (NSString *)url button: (int)button state: (int)state _target: (NSString *)_target ;

/** 
 This method is called when a new embedded object (include html frames) is to be created.
 Reimplement it if you want to add support for certain embeddable objects without registering
 them in the KDE wide registry system (KSyCoCa) . Another reason for re-implementing this
 method could be if you want to derive from KTHMLPart and also want all html frame objects
 to be a object of your derived type, in which case you should return a new instance for
 the mimetype 'text/html' .
   
*/
- (ReadOnlyPart*) createPart: (QWidget *)parentWidget widgetName: (NSString *)widgetName parent: (QObject *)parent name: (NSString *)name mimetype: (NSString *)mimetype serviceName: (NSString *)serviceName serviceTypes: (NSArray *)serviceTypes params: (NSArray *)params;
+ (int) DefaultGUI;
+ (int) BrowserViewGUI;
@end

/** Override these methods in subclasses of KHTMLPart to customise event handling behaviour */
@protocol KHTMLPartEventHandling

/** 
 Eventhandler for the -[khtml MouseDoubleMoveEvent].
   
*/
- khtmlMouseMoveEvent:(MouseMoveEvent*) event;

/** 
 Convenience method which is called when the Part received a @ref PartActivateEvent .
 Reimplement this if you don't want to reimplement @ref event and test for the event yourself
 or even install an event filter.
     
*/
- partActivateEvent:(PartActivateEvent*) event;

/** 
 Convenience method which is called when the Part received a
 @ref PartSelectEvent .
 Reimplement this if you don't want to reimplement @ref event and
 test for the event yourself or even install an event filter.
     
*/
- partSelectEvent:(PartSelectEvent*) event;
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) event;

/** 
 Internal reimplementation of -[KParts Part]::guiActivateEvent .
   
*/
- guiActivateEvent:(GUIActivateEvent*) event;

/** 
 Eventhandler of the -[khtml MousePressEvent].
   
*/
- khtmlMousePressEvent:(MousePressEvent*) event;

/** 
 Eventhandler for the -[khtml MouseMoveEvent].
   
*/
- khtmlMouseReleaseEvent:(MouseReleaseEvent*) event;

/** 
 Eventhandler for the -[khtml MouseDoubleClickEvent].
   
*/
- khtmlMouseDoubleClickEvent:(MouseDoubleClickEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;

/** 
 Eventhandler for the -[khtml DrawContentsEvent].
   
*/
- khtmlDrawContentsEvent:(DrawContentsEvent*) arg1;
@end


#endif
