# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

$effects_dir = "/usr/local/share/emu10k1";
$tone = "Tone Control";

######################### We start with some black magic to print on failure.
# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..1\n"; }
END {print "not ok 1\n" unless $loaded;}
use Emu10K1;

if( Emu10K1::errcode() ) {
  print "not ok 1\n";
  exit(1);
}

$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

Emu10K1::debug(1);
Emu10K1::printPatches;


Emu10K1::setGprInt($tone,"bass",0x100);
Emu10K1::setGprDelay($tone,"bass",1.0);
Emu10K1::setGprFrac($tone,"bass",1.0);
Emu10K1::setGpr($tone,"bass",0x100);
Emu10K1::setGpr($tone,"bass",0.5);
Emu10K1::setGpr($tone,"bass","#0.5");
Emu10K1::setGpr($tone,"bass","#-0.5");
Emu10K1::setGpr($tone,"bass","&1.0");

printf "Bass: %x %f %f\n",Emu10K1::getGpr($tone,"bass"),
  Emu10K1::getGprFrac($tone,"bass"),Emu10K1::getGprDelay($tone,"bass");

Emu10K1::loadPatchAs("$effects_dir/tone.bin","Tone X1","ADC Rec L");
Emu10K1::loadPatchAs("$effects_dir/tone.bin","Tone X2","Analog R");
Emu10K1::loadPatchAs("$effects_dir/gain_2.bin","Gain X","Rear");
Emu10K1::printPatches();
Emu10K1::unloadPatch("Tone X1");
Emu10K1::unloadPatch("Tone X2");
Emu10K1::unloadPatch("Gain X");
Emu10K1::printPatches();

# check for fd leaks
Emu10K1::debug(0);
for(1..1000) {
  Emu10K1::setGpr($tone,"bass",0);
}

# test deferred-update mode
Emu10K1::debug(1);
Emu10K1::deferGprUpdates;
Emu10K1::debug(0);
for(1..1000) {
  Emu10K1::setGpr($tone,"bass",0);
}
Emu10K1::debug(1);
Emu10K1::dspLoad();
