#ifndef __buglistjob_h__
#define __buglistjob_h__

#include "xmlbugjob.h"
#include "package.h"
#include "bug.h"

#include <qdom.h>

class BugListJob : public XmlBugJob
{
    Q_OBJECT
public:
    BugListJob( BugServer * );
    virtual ~BugListJob();

    void start( const Package &pkg, const QString &component );

signals:
    void bugListAvailable( const Package &pkg, const QString &component, const Bug::List &bugs );

protected:
    virtual void process( const QByteArray &data );

    Bug parseDomElement( const QDomElement &element );

private:
    Package m_package;
    QString m_component;
};

#endif

/*
 * vim:ts=4:sw=4:et
 */
