/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2001	  by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef FINDOPTIONS_H
#define FINDOPTIONS_H

#include <qregexp.h>

class QString;
class QChar;

class FindOptions
{
public:
   QString findStr;

   bool caseSensitive;
   bool wholeWords;
   bool fromCursor;
   bool backwards;
   bool isRegExp;

   bool inMsgid;
   bool inMsgstr;
   bool inComment;

   bool ignoreAccelMarker;
   bool ignoreContextInfo;
   
   bool askForNextFile;
   bool askForSave;	// whether should ask before saving or save automatically when loading next file
   bool inAllFiles;	// whether search should be done in all files
   bool inMarkedFiles;  // whether search should be restricted to marked ones
   bool inTemplates;

   // these are non-persistent options - not saved into configuration database
   bool askFile;	// whether findNext should ask catalog manager for next file
   QRegExp contextInfo;	// actual settings of context info regular expression
   QChar accelMarker;	// actual settings of accelerator marker
   
};

class ReplaceOptions : public FindOptions
{
public:
   QString replaceStr;
   bool ask;
};


#endif
