/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmsolidobject.h"
#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"

#include <kdebug.h>
#include "pmglobals.h"

PMSolidObject::PMSolidObject( )
      : Base( )
{
   m_inverse = false;
   m_hollow = PMUnspecified;
}

PMSolidObject::~PMSolidObject( )
{
}

bool PMSolidObject::isA( PMObjectType t ) const
{
   if( t == PMTSolidObject )
      return true;
   return Base::isA( t );
}

void PMSolidObject::serialize( PMOutputDevice& dev ) const
{
   Base::serialize( dev );
   switch( m_hollow )
   {
      case PMTrue:
         dev.writeLine( "hollow" );
         break;
      case PMFalse:
         dev.writeLine( "hollow false" );
         break;
      case PMUnspecified:
         break;
   }
   if( m_inverse )
      dev.writeLine( "inverse" );
}

void PMSolidObject::serialize( QDomElement& e, QDomDocument& doc ) const
{
   switch( m_hollow )
   {
      case PMTrue:
         e.setAttribute( "hollow", "1" );
         break;
      case PMFalse:
         e.setAttribute( "hollow", "0" );
         break;
      case PMUnspecified:
         break;
   }
   e.setAttribute( "inverse", m_inverse );

   Base::serialize( e, doc );
}

void PMSolidObject::readAttributes( const PMXMLHelper& h )
{
   m_hollow = h.threeStateAttribute( "hollow" );
   m_inverse = h.boolAttribute( "inverse", false );

   Base::readAttributes( h );
}

void PMSolidObject::setHollow( PMThreeState h )
{
   if( m_hollow != h )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTSolidObject, PMHollowID, m_hollow );
      m_hollow = h;
   }
}

void PMSolidObject::setInverse( bool yes )
{
   if( m_inverse != yes )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTSolidObject, PMInverseID, m_inverse );
      m_inverse = yes;
   }
}

void PMSolidObject::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == PMTSolidObject )
      {
         switch( data->valueID( ) )
         {
            case PMInverseID:
               setInverse( data->boolData( ) );
               break;
            case PMHollowID:
               setHollow( data->threeStateData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMSolidObject::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}
