#include "settings.h"
#include "settings.moc"

#include <qlabel.h>
#include <qlayout.h>
#include <qcheckbox.h>

#include <klocale.h>
#include <knuminput.h>


GameConfig::GameConfig()
    : KConfigWidget(i18n("Game"), "misc")
{
    QGridLayout *top = new QGridLayout(this, 3, 2, KDialog::marginHint(),
                                       KDialog::spacingHint());
    top->setColStretch(1, 1);

    QLabel *label = new QLabel(this);
    top->addWidget(label, 0, 0);
    KIntNumInput *in = new KIntNumInput(this);
    in->setRange(0, 100); // #### just to have a slider
    KConfigItem *set = configCollection()->plug("init level", in);
    set->setProxyLabel(label);
    top->addWidget(in, 0, 1);

    QCheckBox *cb = new QCheckBox(this);
    configCollection()->plug("show piece shadow", cb);
    top->addMultiCellWidget(cb, 1, 1, 0, 1);

    cb = new QCheckBox(this);
    configCollection()->plug("show next piece", cb);
    top->addMultiCellWidget(cb, 2, 2, 0, 1);
}
