#include "field.h"
#include "field.moc"

#include <qwhatsthis.h>

#include <klocale.h>

#include "generic/gmisc_ui.h"
#include "base/board.h"


KSField::KSField(QWidget *parent)
    : Field(parent)
{
    QWhatsThis::add(removedList, i18n("Display the number of lines removed "
                                      "simultaneously."));
    for (uint i=0; i<4; i++) {
        KGameLCD *lcd = new KGameLCD(5, removedList);
        removedList->append(lcd);
        lcd->setLeadingString(QString::number(i+1));
    }

    connect(board, SIGNAL(removedLinesUpdated(uint, uint)),
            SLOT(removedLinesUpdated(uint, uint)));
}

void KSField::removedLinesUpdated(uint i, uint removed)
{
    Q_ASSERT( i<4 );
    KGameLCD *lcd = static_cast<KGameLCD *>(removedList->lcd(i));
    lcd->displayInt(removed);
    if (removed) lcd->highlight();
}
