/***************************************************************************
                          fixedcircle.cpp  -  description
                             -------------------
    begin                : Sat May 6 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qinputdialog.h"

#include "fixedcircle.h"

FixedCircle::FixedCircle(): GeoObjects()
{
  kapp->config()->setGroup( "Sizes" );
	width = kapp->config()->readNumEntry( "LineWidth", 1 );

  zOrder = 0;
	ID = ID_fixedCircle;
  identificator = "FixedCircle";

	acceptsQPoint = false;
	acceptsGeoPoint = true;
	canBeDestroyed = false;

	int temp[] = { ID_geoPoint, 1, -1 };
	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
}

FixedCircle::~FixedCircle()
{
}

void FixedCircle::paint( QPainter *p )
{
	if ( initComplete )
	{
		if ( isChosen )
		{
			p->setPen( QPen( Qt::black,8, Qt::SolidLine ) );
			p->drawEllipse( surroundingRect );
			p->setPen( QPen( QColor(255,192,0), 4, Qt::SolidLine ) );
			p->drawEllipse( surroundingRect );
		}
		else
		{
			p->setBrush( Qt::NoBrush );
			p->setPen( QPen( color, width, Qt::SolidLine ) );
			p->drawEllipse( surroundingRect );
		}
	}
}

bool FixedCircle::contains( QPoint *pt )
{
	Coordinates coord1, coord2;

	coord1 = Coordinates( *pt );
	coord2 = parents.first()->getCoordinates();

	double dist = coord1.getDistance( coord2 );

	if ( ( dist < radius + width ) && ( dist > radius - width ) )
	{
		return true;
	}
	else
 {
		return false;
	}
}

void FixedCircle::move()
{
 	Coordinates coord1;

 	coord1 = parents.first()->getCoordinates();

 	int x, y, dx, dy;
 	x = coord1.getI_X() - (int)radius;
 	y = coord1.getI_Y() - (int)radius;
 	dx = 2 * (int)radius;
 	dy = 2 * (int)radius;
		
 	surroundingRect = QRect( x, y, dx, dy );
}

void FixedCircle::moveMe( Coordinates & coords )
{
	Coordinates coord1;

	coord1 = parents.first()->getCoordinates();

	coords = coords - coord1;
	coords.normalize( 1 );
	coords *= radius;
	coords += coord1;
}

void FixedCircle::moveMe( Coordinates & coords, double /*position*/ )
{
	Coordinates coord1;

	coord1 = parents.first()->getCoordinates();

	coords = coords - coord1;
	coords.normalize( 1 );
	coords *= radius;
	coords += coord1;
}

double FixedCircle::positionMe( Coordinates & coords )
{
	moveMe( coords );

	return 0;
}

void FixedCircle::initObject( GeoObjects* obj )
{
	//	I will take GeoObject as one of my new parents.
  parents.append( obj );

	if ( processParams( obj ) )
	{

		GeoObjects *actual;
		int newLevel = 1;

		for ( actual = parents.first(); actual; actual = parents.next() )
		{
			if ( actual->getLevel() >= newLevel )
			{
				newLevel = actual->getLevel() + 1;
			}
			actual->children.append( this );
			actual->setChosen( false );
		}

		level = newLevel;

		// Ask for radius
		bool ok = FALSE;
		double res = QInputDialog::getDouble( i18n("Circle with Fixed Diameter"),
				i18n("Please enter diameter:"), 1.0, 0, 2147483647, 2, &ok );
		if ( ok )
		{
			float rad = res;
			m_realRadius = rad / 2;
			radius = MetricsCenter::convertGridToCanvas( rad )/2;
		}	else {
		 	radius =  0;
		}

		move();

		initComplete = true;
	}
	else
	{
		parents.current()->setChosen( true );
	}
}

void FixedCircle::writeToFile( KSimpleConfig *config )
{
	config->writeEntry( "Geo", ID_fixedCircle );
	config->writeEntry( "Color", getColor() );
	config->writeEntry( "Size", width );
	config->writeEntry( "Radius", MetricsCenter::convertCanvasToGrid( radius ) );
	config->writeEntry( "RealRadius", m_realRadius );
}

void FixedCircle::readFromFile( KSimpleConfig *config )
{
	color = config->readColorEntry( "Color" );
	width = 	config->readNumEntry( "Size" );
	QString strRad;
	strRad = config->readEntry( "Radius" );

	float rad = strRad.toFloat();
  	radius = MetricsCenter::convertGridToCanvas( rad );

        strRad = config->readEntry( "RealRadius" );
        m_realRadius = strRad.toFloat();

	initComplete = true;
}

void FixedCircle::getObjectOverlay( QList <QRect> & list )
{
	QRect rect( surroundingRect );

	rect.setWidth( rect.width() + ( ID_overlayRectSize ) );
	rect.setHeight( rect.height() + ( ID_overlayRectSize ) );
	rect.moveCenter( surroundingRect.center() );

	double rad = ( rect.width() / 2 );

	QRect rect1( rect.topLeft(), rect.center() );

	QRect rect2( rect );
	rect2.setLeft( rect2.left() + rad );
	rect2.setBottom( rect2.top() + rad );

	QRect rect3( rect );
	rect3.setRight( rect3.right() - rad );
	rect3.setTop( rect3.top() + rad );

	QRect rect4( rect.center(), rect.bottomRight() );

	Coordinates coord( rect.center() );

	getCircleOverlay( list, ID_overlayRectSize, rect1, coord, rad );
	getCircleOverlay( list, ID_overlayRectSize, rect2, coord, rad );
	getCircleOverlay( list, ID_overlayRectSize, rect3, coord, rad );
	getCircleOverlay( list, ID_overlayRectSize, rect4, coord, rad );
}

