/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __CLOCK_H
#define __CLOCK_H

#include <qlcdnumber.h>
#include <qlabel.h>
#include <qtoolbutton.h>
#include <qguardedptr.h>
#include <qdatetime.h>
#include <qvbox.h>
#include <qstringlist.h>
#include <qevent.h>

#include <kpanelapplet.h>
#include <kdirwatch.h>

class QTimer;
class QBoxLayout;
class KConfig;
class DatePicker;
class QPixmap;
class ClockSettings;

namespace KIO
{
  class Job;
}

class ClockApplet;

// base class for all clock types
class ClockWidget
{

public:
	ClockWidget(ClockApplet *applet, ClockSettings* settings);
	virtual ~ClockWidget();

	virtual QWidget* widget()=0;
	virtual int preferedWidthForHeight(int h) const =0;
	virtual int preferedHeightForWidth(int w) const =0;
	virtual void updateClock()=0;
	virtual void forceUpdate()=0;

protected:
	ClockApplet *_applet;
	ClockSettings *_settings;
	QTime _time;
};


class PlainClock : public QLabel, public ClockWidget
{
  Q_OBJECT

public:
	PlainClock(ClockApplet *applet, ClockSettings* settings, QWidget *parent=0, const char *name=0);
	~PlainClock();

	QWidget* widget()    { return this; }
	int preferedWidthForHeight(int h) const;
	int preferedHeightForWidth(int w) const;
	void updateClock();
	void forceUpdate();

protected:
	QString _timeStr;
};


class DigitalClock : public QLCDNumber, public ClockWidget
{
  Q_OBJECT

public:
	DigitalClock(ClockApplet *applet, ClockSettings* settings, QWidget *parent=0, const char *name=0);
	~DigitalClock();

	QWidget* widget()    { return this; }
	int preferedWidthForHeight(int h) const;
	int preferedHeightForWidth(int w) const;
	void updateClock();
	void forceUpdate();

protected:
	void paintEvent( QPaintEvent*);
	void drawContents( QPainter * p);
	void resizeEvent ( QResizeEvent *ev);
	void styleChange( QStyle& );

	QPixmap *_buffer;
	QString _timeStr;
};


class AnalogClock : public QFrame, public ClockWidget
{
  Q_OBJECT

public:
	AnalogClock(ClockApplet *applet, ClockSettings* settings, QWidget *parent=0, const char *name=0);
	~AnalogClock();

	QWidget* widget()                        { return this; }
	int preferedWidthForHeight(int h) const  { return h; }
	int preferedHeightForWidth(int w) const  { return w; }
	void updateClock();
	void forceUpdate();

protected:
	virtual void paintEvent(QPaintEvent *);
	void styleChange(QStyle&);
	void initBackgroundPixmap();

	QPixmap *_spPx;
	int _bgScale;
};


class FuzzyClock : public QFrame, public ClockWidget
{
  Q_OBJECT

public:
	FuzzyClock(ClockApplet *applet, ClockSettings* settings, QWidget *parent=0, const char *name=0);
	~FuzzyClock();

	QWidget* widget()    { return this; }
	int preferedWidthForHeight(int h) const;
	int preferedHeightForWidth(int w) const;
	void updateClock();
	void forceUpdate();

protected:
	virtual void drawContents(QPainter *p);

	QStringList hourNames;
	QStringList normalFuzzy;
	QStringList normalFuzzyOne;
	QStringList dayTime;

	QString _timeStr;
};


class ClockApplet : public KPanelApplet
{
  Q_OBJECT

public:
	ClockApplet(const QString& configFile, Type t = Normal, int actions = 0,
	            QWidget *parent = 0, const char *name = 0);
	~ClockApplet();

	int widthForHeight(int h) const;
	int heightForWidth(int w) const;
	void preferences();
	Orientation getOrientation()    { return orientation(); }
	void resizeRequest()            { emit(updateLayout()); }

	int TZoffset;
	QTime clockGetTime();
	QDate clockGetDate();

protected slots:
	void slotApplySettings();
	void slotUpdate();
	void slotCalendarDeleted();
	void slotEnableCalendar();
	void slotCopyMenuActivated( int id );
	void slotUpdateToolTip();

protected:
	void toggleCalendar();
	void openContextMenu();
	void updateDateLabel();
	void showZone(int z);
	void nextZone();
	void prevZone();

	void paletteChange(const QPalette &)   { slotApplySettings(); }
	void mousePressEvent(QMouseEvent *ev);
	void wheelEvent(QWheelEvent* e);
	bool eventFilter(QObject *, QEvent *);

	ClockSettings *_settings;
	DatePicker *_calendar;
	bool _disableCalendar;
	ClockWidget *_clock;
	QLabel *_date;
	QDate _lastDate;
	QTimer *_timer;
};

#endif
