  	/* ------------------------------------------------------------
 	*        Page down,  decrementing the cw speed with  2 wpm
 	*
 	*--------------------------------------------------------------*/

#include "speeddown.h"
#include "tlf.h"
#include "cwkeyer.h"
#include "clear_display.h"

int speeddown(void)
{

extern int speed;
extern char speedstr[];
extern char tonestr[];
extern int trxmode;
extern int keyerport;
extern int cfd;

char outstr[30]  = "", buff[3] = "";

int  retval;

if (trxmode != CWMODE)          /* bail out, this is an SSB contest */
		return (0);	

if (keyerport == COM1_KEYER) {
	
	if (speed >= 1)
	{
	speed--;
	
	strncpy(buff, speedstr+(speed * 2), 2);
	buff[2] = '\0';
	strcpy(outstr , "cwkeyset ");
	strcat(outstr, tonestr);
	strcat(outstr  ,  " ");
	strcat (outstr, buff);

	system(outstr);
	}
}

if (keyerport == LPT_KEYER) {

 	if (speed >= 1) {
 	
 		speed--;
 		
 		strncpy(buff, speedstr+(speed * 2), 2);
		buff[2] = '\0';
		
//		fd = open("/dev/cwkeyer0", O_RDWR );
 	
		retval = ioctl(cfd, CWKEYER_IOCSSPEED, atoi(buff));
		if	(retval)
		{
			mvprintw(24,0, "keyer not active; switching to SSB");
			trxmode = SSBMODE;
			clear_display();
		}
//		close(fd);

 	}
}

return (speed);	
}

