/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import COM.rsa.jsafe.SunJSSE_bg;
import COM.rsa.jsafe.SunJSSE_bi;
import COM.rsa.jsafe.SunJSSE_bq;
import COM.rsa.jsafe.SunJSSE_dm;
import COM.rsa.jsafe.SunJSSE_n;
import COM.rsa.jsafe.SunJSSE_w;
import com.sun.net.ssl.internal.ssl.JS_PrivateKey;
import com.sun.net.ssl.internal.ssl.JS_PublicKey;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public abstract class JS_KeyPairGenerator
extends KeyPairGeneratorSpi
implements Cloneable,
Serializable {
    protected SunJSSE_bq jsafeKeyPair;
    private String a;
    private int b = 1;
    private static final int c = 1;
    private static final int d = 2;

    public JS_KeyPairGenerator(String string, String string2) throws NoSuchAlgorithmException {
        this.a = string2;
        try {
            this.jsafeKeyPair = SunJSSE_bq.a(string, "Java");
        }
        catch (SunJSSE_n sunJSSE_n) {
            throw new NoSuchAlgorithmException("Cannot perform this algorithm.");
        }
    }

    public String getAlgorithm() {
        return this.a;
    }

    protected abstract SunJSSE_dm getSystemParameters(AlgorithmParameterSpec var1, int var2, SecureRandom var3) throws InvalidAlgorithmParameterException;

    protected abstract int[] getKeyPairGenParameters(AlgorithmParameterSpec var1, int var2, SecureRandom var3) throws InvalidAlgorithmParameterException;

    public void initialize(int n, SecureRandom secureRandom) {
        if (this.jsafeKeyPair == null) {
            return;
        }
        if (n < 512 || n > 2048) {
            throw new InvalidParameterException("Modulus size must range from 512 to 2048");
        }
        if (n <= 0) {
            n = 1024;
        }
        if (secureRandom == null) {
            try {
                secureRandom = SunJSSE_w.getInstance("SHA1Random", "Java");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        try {
            SunJSSE_dm sunJSSE_dm = this.getSystemParameters(null, n, secureRandom);
            int[] nArray = this.getKeyPairGenParameters(null, n, secureRandom);
            this.jsafeKeyPair.a(sunJSSE_dm, nArray, secureRandom);
            this.b = 2;
        }
        catch (SunJSSE_n sunJSSE_n) {
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {}
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (this.jsafeKeyPair == null) {
            return;
        }
        if (secureRandom == null) {
            try {
                secureRandom = SunJSSE_w.getInstance("SHA1Random", "Java");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        try {
            SunJSSE_dm sunJSSE_dm = this.getSystemParameters(algorithmParameterSpec, -1, secureRandom);
            int[] nArray = this.getKeyPairGenParameters(algorithmParameterSpec, -1, secureRandom);
            this.jsafeKeyPair.a(sunJSSE_dm, nArray, secureRandom);
            this.b = 2;
        }
        catch (SunJSSE_n sunJSSE_n) {
            throw new InvalidAlgorithmParameterException("Unknown algorithm parameter spec.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPair generateKeyPair() {
        if (this.jsafeKeyPair == null) {
            return null;
        }
        KeyPair keyPair = null;
        SunJSSE_bg sunJSSE_bg = null;
        SunJSSE_bi sunJSSE_bi = null;
        try {
            Serializable serializable;
            if (this.b == 1) {
                serializable = SunJSSE_w.getInstance("SHA1Random", "Java");
                this.initialize(1024, (SecureRandom)serializable);
            }
            this.jsafeKeyPair.c();
            sunJSSE_bg = this.jsafeKeyPair.i();
            sunJSSE_bi = this.jsafeKeyPair.h();
            serializable = JS_PublicKey.getInstance(sunJSSE_bg);
            JS_PrivateKey jS_PrivateKey = JS_PrivateKey.getInstance(sunJSSE_bi);
            keyPair = new KeyPair((PublicKey)serializable, jS_PrivateKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            keyPair = null;
        }
        catch (SunJSSE_n sunJSSE_n) {
            keyPair = null;
        }
        finally {
            if (sunJSSE_bg != null) {
                sunJSSE_bg.a();
            }
            if (sunJSSE_bi != null) {
                sunJSSE_bi.a();
            }
        }
        return keyPair;
    }

    public Object clone() throws CloneNotSupportedException {
        JS_KeyPairGenerator jS_KeyPairGenerator = (JS_KeyPairGenerator)super.clone();
        if (this.jsafeKeyPair != null) {
            jS_KeyPairGenerator.jsafeKeyPair = (SunJSSE_bq)this.jsafeKeyPair.clone();
        }
        return jS_KeyPairGenerator;
    }

    void a() {
        if (this.jsafeKeyPair != null) {
            this.jsafeKeyPair.a();
        }
        this.jsafeKeyPair = null;
    }

    protected void finalize() {
        this.a();
    }
}

