/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sun.security.util.Debug;

class PKIXMasterCertPathValidator {
    private static final Debug debug = Debug.getInstance("certpath");
    private List certPathCheckers;

    PKIXMasterCertPathValidator(List list) {
        this.certPathCheckers = list;
    }

    void validate(CertPath certPath, List list) throws CertPathValidatorException {
        X509Certificate x509Certificate = null;
        PKIXCertPathChecker pKIXCertPathChecker = null;
        int n2 = list.size();
        if (debug != null) {
            debug.println("--------------------------------------------------------------");
            debug.println("Executing PKIX certification path validation algorithm.");
        }
        int n3 = 0;
        while (n3 < n2) {
            Set set;
            if (debug != null) {
                debug.println("Checking cert" + (n3 + 1) + " ...");
            }
            if ((set = (x509Certificate = (X509Certificate)list.get(n3)).getCriticalExtensionOIDs()) == null) {
                set = Collections.EMPTY_SET;
            }
            if (debug != null && !set.isEmpty()) {
                debug.println("Set of critical extensions:");
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    debug.println((String)iterator.next());
                }
            }
            int n4 = 0;
            while (n4 < this.certPathCheckers.size()) {
                if (debug != null) {
                    debug.println("-Using checker" + (n4 + 1) + " ...");
                }
                pKIXCertPathChecker = (PKIXCertPathChecker)this.certPathCheckers.get(n4);
                if (n3 == 0) {
                    pKIXCertPathChecker.init(false);
                }
                try {
                    pKIXCertPathChecker.check(x509Certificate, set);
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    throw new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n2 - (n3 + 1));
                }
                if (debug != null) {
                    debug.println("-checker" + (n4 + 1) + " validation succeeded");
                }
                ++n4;
            }
            if (debug != null) {
                debug.println("checking for unresolvedCritExts");
            }
            if (!set.isEmpty()) {
                throw new CertPathValidatorException("unrecognized critical extension(s)", null, certPath, n2 - (n3 + 1));
            }
            if (debug != null) {
                debug.println("\ncert" + (n3 + 1) + " validation succeeded.\n");
            }
            ++n3;
        }
        if (debug != null) {
            debug.println("Cert path validation succeeded. (PKIX validation algorithm)");
            debug.println("--------------------------------------------------------------");
        }
    }
}

