/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.AttributedCharacterIterator;
import sun.print.ProxyGraphics2D;

public abstract class PathGraphics
extends ProxyGraphics2D {
    private Printable mPainter;
    private PageFormat mPageFormat;
    private int mPageIndex;
    private boolean mCanRedraw;

    protected PathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n2, boolean bl2) {
        super(graphics2D, printerJob);
        this.mPainter = printable;
        this.mPageFormat = pageFormat;
        this.mPageIndex = n2;
        this.mCanRedraw = bl2;
    }

    protected Printable getPrintable() {
        return this.mPainter;
    }

    protected PageFormat getPageFormat() {
        return this.mPageFormat;
    }

    protected int getPageIndex() {
        return this.mPageIndex;
    }

    public boolean canDoRedraws() {
        return this.mCanRedraw;
    }

    public abstract void redrawRegion(Rectangle2D var1, double var2, double var4, Rectangle2D var6, AffineTransform var7) throws PrinterException;

    public void drawLine(int n2, int n3, int n4, int n5) {
        Paint paint = this.getPaint();
        try {
            AffineTransform affineTransform = this.getTransform();
            if (this.getClip() != null) {
                this.deviceClip(this.getClip().getPathIterator(affineTransform));
            }
            this.deviceDrawLine(n2, n3, n4, n5, (Color)paint);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void drawRect(int n2, int n3, int n4, int n5) {
        Paint paint = this.getPaint();
        try {
            AffineTransform affineTransform = this.getTransform();
            if (this.getClip() != null) {
                this.deviceClip(this.getClip().getPathIterator(affineTransform));
            }
            this.deviceFrameRect(n2, n3, n4, n5, (Color)paint);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void fillRect(int n2, int n3, int n4, int n5) {
        Paint paint = this.getPaint();
        try {
            AffineTransform affineTransform = this.getTransform();
            if (this.getClip() != null) {
                this.deviceClip(this.getClip().getPathIterator(affineTransform));
            }
            this.deviceFillRect(n2, n3, n4, n5, (Color)paint);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void clearRect(int n2, int n3, int n4, int n5) {
        this.fill(new Rectangle2D.Float(n2, n3, n4, n5), this.getBackground());
    }

    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.draw(new RoundRectangle2D.Float(n2, n3, n4, n5, n6, n7));
    }

    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fill(new RoundRectangle2D.Float(n2, n3, n4, n5, n6, n7));
    }

    public void drawOval(int n2, int n3, int n4, int n5) {
        this.draw(new Ellipse2D.Float(n2, n3, n4, n5));
    }

    public void fillOval(int n2, int n3, int n4, int n5) {
        this.fill(new Ellipse2D.Float(n2, n3, n4, n5));
    }

    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.draw(new Arc2D.Float(n2, n3, n4, n5, n6, n7, 0));
    }

    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fill(new Arc2D.Float(n2, n3, n4, n5, n6, n7, 2));
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        if (n2 > 0) {
            float f2 = nArray[0];
            float f3 = nArray2[0];
            int n3 = 1;
            while (n3 < n2) {
                float f4 = nArray[n3];
                float f5 = nArray2[n3];
                this.draw(new Line2D.Float(f2, f3, f4, f5));
                f2 = f4;
                f3 = f5;
                ++n3;
            }
        }
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        this.draw(new Polygon(nArray, nArray2, n2));
    }

    public void drawPolygon(Polygon polygon) {
        this.draw(polygon);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        this.fill(new Polygon(nArray, nArray2, n2));
    }

    public void fillPolygon(Polygon polygon) {
        this.fill(polygon);
    }

    public void drawString(String string, int n2, int n3) {
        this.drawString(string, (float)n2, (float)n3);
    }

    public void drawString(String string, float f2, float f3) {
        if (string.length() == 0) {
            return;
        }
        TextLayout textLayout = new TextLayout(string, this.getFont(), this.getFontRenderContext());
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f2, f3));
        this.fill(shape);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        this.drawString(attributedCharacterIterator, (float)n2, (float)n3);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException("attributedcharacteriterator is null");
        }
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f2, f3));
        this.fill(shape);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        this.fill(glyphVector.getOutline(f2, f3));
    }

    public void draw(Shape shape) {
        this.fill(this.getStroke().createStrokedShape(shape));
    }

    public void fill(Shape shape) {
        Paint paint = this.getPaint();
        try {
            this.fill(shape, (Color)paint);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void fill(Shape shape, Color color) {
        AffineTransform affineTransform = this.getTransform();
        if (this.getClip() != null) {
            this.deviceClip(this.getClip().getPathIterator(affineTransform));
        }
        this.deviceFill(shape.getPathIterator(affineTransform), color);
    }

    protected abstract void deviceFill(PathIterator var1, Color var2);

    protected abstract void deviceClip(PathIterator var1);

    protected abstract void deviceFrameRect(int var1, int var2, int var3, int var4, Color var5);

    protected abstract void deviceDrawLine(int var1, int var2, int var3, int var4, Color var5);

    protected abstract void deviceFillRect(int var1, int var2, int var3, int var4, Color var5);
}

