/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.print;

import java.awt.Frame;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.StringTokenizer;
import sun.awt.print.PrintControl;
import sun.awt.print.PrintDialog;
import sun.awt.print.PrinterCapabilities;
import sun.awt.print.PrinterListUpdatable;

public class AwtPrintControl
extends PrintControl {
    private static String[] sortedPrinterList = null;
    private static long lastPrinterListQueryMillis = 0L;
    private static final long QUERY_INTERVAL = 900000L;
    private static final String DEST_PROP = "awt.print.destination";
    private static final String PRINTER = "printer";
    private static final String FILE = "file";
    private static final String PRINTER_PROP = "awt.print.printer";
    private static final String FILENAME_PROP = "awt.print.fileName";
    private static final String NUMCOPIES_PROP = "awt.print.numCopies";
    private static final String OPTIONS_PROP = "awt.print.options";
    private static final String ORIENT_PROP = "awt.print.orientation";
    private static final String PORTRAIT = "portrait";
    private static final String LANDSCAPE = "landscape";
    private static final String PAPERSIZE_PROP = "awt.print.paperSize";
    private static final String LETTER = "letter";
    private static final String LEGAL = "legal";
    private static final String EXECUTIVE = "executive";
    private static final String A4 = "a4";
    private Properties props;

    public AwtPrintControl(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        super(frame, string, jobAttributes, pageAttributes);
    }

    public AwtPrintControl(Frame frame, String string, Properties properties) {
        super(frame, string, null, null);
        this.props = properties;
        this.translateInputProps();
    }

    public String getDefaultPrinterName() {
        String string = "lp";
        try {
            Process process;
            final String[] stringArray = new String[3];
            if (System.getProperty("os.name").equals("Linux")) {
                stringArray[0] = "/bin/sh";
                stringArray[1] = "-c";
                stringArray[2] = "/usr/sbin/lpc status | grep : | sed -ne '1,1 s/://p'";
            } else {
                stringArray[0] = "/usr/bin/sh";
                stringArray[1] = "-c";
                stringArray[2] = "/usr/bin/lpstat -d|/usr/bin/expand|/usr/bin/cut -f4 -d' '";
            }
            try {
                process = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return Runtime.getRuntime().exec(stringArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
            process.waitFor();
            if (process.exitValue() == 0) {
                InputStream inputStream = process.getInputStream();
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                string = new String(byArray).trim();
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {}
        return string;
    }

    public boolean getCapabilities(PrinterCapabilities printerCapabilities) {
        printerCapabilities.setCapabilities(3L);
        return true;
    }

    public void getPrinterList(final PrinterListUpdatable printerListUpdatable) {
        long l2 = System.currentTimeMillis();
        if (sortedPrinterList != null && l2 - lastPrinterListQueryMillis < 900000L) {
            printerListUpdatable.updatePrinterList(sortedPrinterList);
            return;
        }
        lastPrinterListQueryMillis = l2;
        new Thread(new Runnable(){

            public void run() {
                String[] stringArray = null;
                try {
                    Process process;
                    String[] stringArray2 = new String[3];
                    if (System.getProperty("os.name").equals("Linux")) {
                        stringArray2[0] = "/bin/sh";
                        stringArray2[1] = "-c";
                        stringArray2[2] = "/usr/sbin/lpc status | grep : | sed -e 's/://'";
                    } else {
                        stringArray2[0] = "/usr/bin/sh";
                        stringArray2[1] = "-c";
                        stringArray2[2] = "/usr/bin/lpstat -v|/usr/bin/expand|/usr/bin/cut -f3 -d' '|/usr/bin/cut -f1 -d':'|/usr/bin/sort -u";
                    }
                    try {
                        process = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(this, stringArray2){
                            private final /* synthetic */ String[] val$cmd;
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$cmd = stringArray;
                            }

                            public Object run() throws IOException {
                                return Runtime.getRuntime().exec(this.val$cmd);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (IOException)privilegedActionException.getException();
                    }
                    process.waitFor();
                    if (process.exitValue() == 0) {
                        InputStream inputStream = process.getInputStream();
                        String string = "";
                        while (inputStream.available() > 0) {
                            byte[] byArray = new byte[inputStream.available()];
                            inputStream.read(byArray);
                            string = string + new String(byArray);
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        int n2 = stringTokenizer.countTokens();
                        stringArray = new String[n2];
                        int n3 = 0;
                        while (n3 < n2) {
                            stringArray[n3] = stringTokenizer.nextToken();
                            ++n3;
                        }
                    }
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AwtPrintControl.access$002(stringArray);
                printerListUpdatable.updatePrinterList(sortedPrinterList);
            }
        }).start();
    }

    private void translateInputProps() {
        if (this.props == null) {
            return;
        }
        String string = this.props.getProperty(DEST_PROP);
        if (string != null) {
            if (string.equals(PRINTER)) {
                this.setDestAttrib(JobAttributes.DestinationType.PRINTER);
            } else if (string.equals(FILE)) {
                this.setDestAttrib(JobAttributes.DestinationType.FILE);
            }
        }
        if ((string = this.props.getProperty(PRINTER_PROP)) != null) {
            this.setPrinterAttrib(string);
        }
        if ((string = this.props.getProperty(FILENAME_PROP)) != null) {
            this.setFileNameAttrib(string);
        }
        if ((string = this.props.getProperty(NUMCOPIES_PROP)) != null) {
            this.setCopiesAttrib(Integer.parseInt(string));
        }
        if ((string = this.props.getProperty(OPTIONS_PROP)) != null) {
            this.setOptions(string);
        }
        if ((string = this.props.getProperty(ORIENT_PROP)) != null) {
            if (string.equals(PORTRAIT)) {
                this.setOrientAttrib(PageAttributes.OrientationRequestedType.PORTRAIT);
            } else if (string.equals(LANDSCAPE)) {
                this.setOrientAttrib(PageAttributes.OrientationRequestedType.LANDSCAPE);
            }
        }
        if ((string = this.props.getProperty(PAPERSIZE_PROP)) != null) {
            if (string.equals(LETTER)) {
                this.setMediaAttrib(PageAttributes.MediaType.LETTER.hashCode());
            } else if (string.equals(LEGAL)) {
                this.setMediaAttrib(PageAttributes.MediaType.LEGAL.hashCode());
            } else if (string.equals(EXECUTIVE)) {
                this.setMediaAttrib(PageAttributes.MediaType.EXECUTIVE.hashCode());
            } else if (string.equals(A4)) {
                this.setMediaAttrib(PageAttributes.MediaType.A4.hashCode());
            }
        }
    }

    private void translateOutputProps() {
        int n2;
        if (this.props == null) {
            return;
        }
        this.props.setProperty(DEST_PROP, this.getDestAttrib() == JobAttributes.DestinationType.PRINTER ? PRINTER : FILE);
        String string = this.getPrinterAttrib();
        if (string != null && !string.equals("")) {
            this.props.setProperty(PRINTER_PROP, this.getPrinterAttrib());
        }
        if ((string = this.getFileNameAttrib()) != null && !string.equals("")) {
            this.props.setProperty(FILENAME_PROP, string);
        }
        if ((n2 = this.getCopiesAttrib()) > 0) {
            this.props.setProperty(NUMCOPIES_PROP, "" + n2);
        }
        if ((string = this.getOptions()) != null && !string.equals("")) {
            this.props.setProperty(OPTIONS_PROP, string);
        }
        this.props.setProperty(ORIENT_PROP, this.getOrientAttrib() == PageAttributes.OrientationRequestedType.PORTRAIT ? PORTRAIT : LANDSCAPE);
        PageAttributes.MediaType mediaType = PrintControl.SIZES[this.getMediaAttrib()];
        string = mediaType == PageAttributes.MediaType.LETTER ? LETTER : (mediaType == PageAttributes.MediaType.LEGAL ? LEGAL : (mediaType == PageAttributes.MediaType.EXECUTIVE ? EXECUTIVE : (mediaType == PageAttributes.MediaType.A4 ? A4 : mediaType.toString())));
        this.props.setProperty(PAPERSIZE_PROP, string);
    }

    protected void createAttributes(PrintDialog printDialog) {
        super.createAttributes(printDialog);
        this.translateOutputProps();
    }

    static /* synthetic */ String[] access$002(String[] stringArray) {
        sortedPrinterList = stringArray;
        return stringArray;
    }
}

