/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.auth.kerberos.ServicePermission;

final class KrbServicePermissionCollection
extends PermissionCollection
implements Serializable {
    private Vector permissions = new Vector();

    public boolean implies(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)permission;
        int n2 = servicePermission.getMask();
        int n3 = 0;
        int n4 = n2;
        Enumeration enumeration = this.permissions.elements();
        while (enumeration.hasMoreElements()) {
            ServicePermission servicePermission2 = (ServicePermission)enumeration.nextElement();
            if ((n4 & servicePermission2.getMask()) == 0 || !servicePermission2.impliesIgnoreMask(servicePermission)) continue;
            if (((n3 |= servicePermission2.getMask()) & n2) == n2) {
                return true;
            }
            n4 = n2 ^ n3;
        }
        return false;
    }

    public void add(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        this.permissions.add(0, permission);
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

