/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Menu
extends MenuItem
implements MenuContainer,
Accessible {
    Vector items = new Vector();
    boolean tearOff;
    boolean isHelpMenu;
    private static final String base = "menu";
    private static int nameCounter;
    private static final long serialVersionUID = -8809584163345499784L;
    private int menuSerializedDataVersion = 1;

    public Menu() throws HeadlessException {
        this("", false);
    }

    public Menu(String string) throws HeadlessException {
        this(string, false);
    }

    public Menu(String string, boolean bl2) throws HeadlessException {
        super(string);
        this.tearOff = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenu(this);
            }
            int n2 = this.getItemCount();
            int n3 = 0;
            while (n3 < n2) {
                MenuItem menuItem = this.getItem(n3);
                menuItem.parent = this;
                menuItem.addNotify();
                ++n3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = this.getItemCount();
            int n3 = 0;
            while (n3 < n2) {
                this.getItem(n3).removeNotify();
                ++n3;
            }
            super.removeNotify();
        }
    }

    public boolean isTearOff() {
        return this.tearOff;
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.countItemsImpl();
    }

    final int countItemsImpl() {
        return this.items.size();
    }

    public MenuItem getItem(int n2) {
        return this.getItemImpl(n2);
    }

    final MenuItem getItemImpl(int n2) {
        return (MenuItem)this.items.elementAt(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem add(MenuItem menuItem) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (menuItem.parent != null) {
                menuItem.parent.remove(menuItem);
            }
            this.items.addElement(menuItem);
            menuItem.parent = this;
            MenuPeer menuPeer = (MenuPeer)this.peer;
            if (menuPeer != null) {
                menuItem.addNotify();
                menuPeer.addItem(menuItem);
            }
            return menuItem;
        }
    }

    public void add(String string) {
        this.add(new MenuItem(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(MenuItem menuItem, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n2 < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            int n3 = this.getItemCount();
            Vector vector = new Vector();
            int n4 = n2;
            while (n4 < n3) {
                vector.addElement(this.getItem(n2));
                this.remove(n2);
                ++n4;
            }
            this.add(menuItem);
            int n5 = 0;
            while (n5 < vector.size()) {
                this.add((MenuItem)vector.elementAt(n5));
                ++n5;
            }
        }
    }

    public void insert(String string, int n2) {
        this.insert(new MenuItem(string), n2);
    }

    public void addSeparator() {
        this.add("-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSeparator(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n2 < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            int n3 = this.getItemCount();
            Vector vector = new Vector();
            int n4 = n2;
            while (n4 < n3) {
                vector.addElement(this.getItem(n2));
                this.remove(n2);
                ++n4;
            }
            this.addSeparator();
            int n5 = 0;
            while (n5 < vector.size()) {
                this.add((MenuItem)vector.elementAt(n5));
                ++n5;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuItem menuItem = this.getItem(n2);
            this.items.removeElementAt(n2);
            MenuPeer menuPeer = (MenuPeer)this.peer;
            if (menuPeer != null) {
                menuItem.removeNotify();
                menuItem.parent = null;
                menuPeer.delItem(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(MenuComponent menuComponent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = this.items.indexOf(menuComponent);
            if (n2 >= 0) {
                this.remove(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = this.getItemCount();
            int n3 = n2 - 1;
            while (n3 >= 0) {
                this.remove(n3);
                --n3;
            }
        }
    }

    boolean handleShortcut(KeyEvent keyEvent) {
        int n2 = this.getItemCount();
        int n3 = 0;
        while (n3 < n2) {
            MenuItem menuItem = this.getItem(n3);
            if (menuItem.handleShortcut(keyEvent)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        int n2 = this.getItemCount();
        int n3 = 0;
        while (n3 < n2) {
            MenuItem menuItem = this.getItem(n3).getShortcutMenuItem(menuShortcut);
            if (menuItem != null) {
                return menuItem;
            }
            ++n3;
        }
        return null;
    }

    synchronized Enumeration shortcuts() {
        Vector vector = new Vector();
        int n2 = this.getItemCount();
        int n3 = 0;
        while (n3 < n2) {
            Object object;
            MenuItem menuItem = this.getItem(n3);
            if (menuItem instanceof Menu) {
                object = ((Menu)menuItem).shortcuts();
                while (object.hasMoreElements()) {
                    vector.addElement(object.nextElement());
                }
            } else {
                object = menuItem.getShortcut();
                if (object != null) {
                    vector.addElement(object);
                }
            }
            ++n3;
        }
        return vector.elements();
    }

    void deleteShortcut(MenuShortcut menuShortcut) {
        int n2 = this.getItemCount();
        int n3 = 0;
        while (n3 < n2) {
            this.getItem(n3).deleteShortcut(menuShortcut);
            ++n3;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, HeadlessException {
        objectInputStream.defaultReadObject();
        int n2 = 0;
        while (n2 < this.items.size()) {
            MenuItem menuItem = (MenuItem)this.items.elementAt(n2);
            menuItem.parent = this;
            ++n2;
        }
    }

    public String paramString() {
        String string = ",tearOff=" + this.tearOff + ",isHelpMenu=" + this.isHelpMenu;
        return super.paramString() + string;
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenu();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Menu.initIDs();
        }
        nameCounter = 0;
    }

    protected class AccessibleAWTMenu
    extends MenuItem.AccessibleAWTMenuItem {
        protected AccessibleAWTMenu() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }
    }
}

