/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.pool;

import com.sun.jndi.ldap.LdapPoolManager;
import com.sun.jndi.ldap.pool.ConnectionDesc;
import com.sun.jndi.ldap.pool.Pool;
import com.sun.jndi.ldap.pool.PoolCallback;
import com.sun.jndi.ldap.pool.PooledConnection;
import com.sun.jndi.ldap.pool.PooledConnectionFactory;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;

final class Connections
implements PoolCallback {
    private static final boolean debug = Pool.debug;
    private static final boolean trace = LdapPoolManager.trace;
    private static final int DEFAULT_SIZE = 10;
    private final int maxSize;
    private final int prefSize;
    private final List conns;
    private boolean closed = false;
    private Reference ref;

    Connections(Object object, int n2, int n3, int n4, PooledConnectionFactory pooledConnectionFactory) throws NamingException {
        this.maxSize = n4;
        if (n4 > 0) {
            this.prefSize = Math.min(n3, n4);
            n2 = Math.min(n2, n4);
        } else {
            this.prefSize = n3;
        }
        this.conns = new ArrayList(n4 > 0 ? n4 : 10);
        this.ref = new SoftReference(object);
        this.d("init size=", n2);
        this.d("max size=", n4);
        this.d("preferred size=", n3);
        int n5 = 0;
        while (n5 < n2) {
            PooledConnection pooledConnection = pooledConnectionFactory.createPooledConnection(this);
            this.td("Create ", pooledConnection, pooledConnectionFactory);
            this.conns.add(new ConnectionDesc(pooledConnection));
            ++n5;
        }
    }

    synchronized PooledConnection get(long l2, PooledConnectionFactory pooledConnectionFactory) throws NamingException {
        PooledConnection pooledConnection;
        long l3 = l2 > 0L ? System.currentTimeMillis() : 0L;
        long l4 = l2;
        this.d("get(): before");
        while ((pooledConnection = this.getOrCreateConnection(pooledConnectionFactory)) == null) {
            if (l2 > 0L && l4 <= 0L) {
                throw new CommunicationException("Timeout exceeded while waiting for a connection: " + l2 + "ms");
            }
            try {
                this.d("get(): waiting");
                if (l4 > 0L) {
                    this.wait(l4);
                } else {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted while waiting for a connection");
            }
            if (l2 <= 0L) continue;
            long l5 = System.currentTimeMillis();
            l4 = l2 - (l5 - l3);
        }
        this.d("get(): after");
        return pooledConnection;
    }

    private PooledConnection getOrCreateConnection(PooledConnectionFactory pooledConnectionFactory) throws NamingException {
        int n2 = this.conns.size();
        PooledConnection pooledConnection = null;
        if (this.prefSize <= 0 || n2 >= this.prefSize) {
            int n3 = 0;
            while (n3 < n2) {
                ConnectionDesc connectionDesc = (ConnectionDesc)this.conns.get(n3);
                pooledConnection = connectionDesc.tryUse();
                if (pooledConnection != null) {
                    this.d("get(): use ", pooledConnection);
                    this.td("Use ", pooledConnection);
                    return pooledConnection;
                }
                ++n3;
            }
        }
        if (this.maxSize > 0 && n2 >= this.maxSize) {
            return null;
        }
        pooledConnection = pooledConnectionFactory.createPooledConnection(this);
        this.td("Create and use ", pooledConnection, pooledConnectionFactory);
        this.conns.add(new ConnectionDesc(pooledConnection, true));
        return pooledConnection;
    }

    public synchronized boolean releasePooledConnection(PooledConnection pooledConnection) {
        ConnectionDesc connectionDesc = new ConnectionDesc(pooledConnection);
        int n2 = this.conns.indexOf(connectionDesc);
        this.d("release(): ", pooledConnection);
        if (n2 >= 0) {
            if (this.closed || this.prefSize > 0 && this.conns.size() > this.prefSize) {
                this.d("release(): closing ", pooledConnection);
                this.td("Close ", pooledConnection);
                this.conns.remove(connectionDesc);
                pooledConnection.closeConnection();
            } else {
                this.d("release(): release ", pooledConnection);
                this.td("Release ", pooledConnection);
                connectionDesc = (ConnectionDesc)this.conns.get(n2);
                connectionDesc.release();
            }
            this.notifyAll();
            this.d("release(): notify");
            return true;
        }
        return false;
    }

    public synchronized boolean removePooledConnection(PooledConnection pooledConnection) {
        if (this.conns.remove(new ConnectionDesc(pooledConnection))) {
            this.d("remove(): ", pooledConnection);
            this.notifyAll();
            this.d("remove(): notify");
            this.td("Remove ", pooledConnection);
            if (this.conns.isEmpty()) {
                this.ref = null;
            }
            return true;
        }
        this.d("remove(): not found ", pooledConnection);
        return false;
    }

    synchronized boolean expire(long l2) {
        Iterator iterator = this.conns.iterator();
        while (iterator.hasNext()) {
            ConnectionDesc connectionDesc = (ConnectionDesc)iterator.next();
            if (!connectionDesc.expire(l2)) continue;
            this.d("expire(): removing ", connectionDesc);
            this.td("Expired ", connectionDesc);
            iterator.remove();
        }
        return this.conns.isEmpty();
    }

    synchronized void close() {
        this.expire(System.currentTimeMillis());
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getStats() {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        long l2 = 0L;
        Connections connections = this;
        synchronized (connections) {
            n2 = this.conns.size();
            int n6 = 0;
            while (n6 < n2) {
                ConnectionDesc connectionDesc = (ConnectionDesc)this.conns.get(n6);
                l2 += connectionDesc.getUseCount();
                switch (connectionDesc.getState()) {
                    case 0: {
                        ++n4;
                        break;
                    }
                    case 1: {
                        ++n3;
                        break;
                    }
                    case 2: {
                        ++n5;
                    }
                }
                ++n6;
            }
        }
        return "size=" + n2 + "; use=" + l2 + "; busy=" + n4 + "; idle=" + n3 + "; expired=" + n5;
    }

    private void d(String string, Object object) {
        if (debug) {
            this.d(string + object);
        }
    }

    private void d(String string, int n2) {
        if (debug) {
            this.d(string + n2);
        }
    }

    private void d(String string) {
        if (debug) {
            System.err.println(this + "." + string + "; size: " + this.conns.size());
        }
    }

    private void td(String string, Object object, Object object2) {
        if (trace) {
            this.td(string + object + "[" + object2 + "]");
        }
    }

    private void td(String string, Object object) {
        if (trace) {
            this.td(string + object);
        }
    }

    private void td(String string) {
        if (trace) {
            System.err.println(string);
        }
    }
}

