/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class WindowsComboBoxUI
extends BasicComboBoxUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.comboBox.setRequestFocusEnabled(true);
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap actionMap = (ActionMap)UIManager.get("ComboBox.actionMap");
        if (actionMap != null) {
            actionMap.put("selectPrevious", new UpAction());
            actionMap.put("selectNext", new DownAction());
        }
    }

    protected ComboPopup createPopup() {
        return new WindowsComboPopup(this.comboBox);
    }

    protected ComboBoxEditor createEditor() {
        return new WindowsComboBoxEditor();
    }

    static class UpAction
    extends AbstractAction {
        UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled()) {
                WindowsComboBoxUI windowsComboBoxUI = (WindowsComboBoxUI)jComboBox.getUI();
                if (!jComboBox.isEditable() || jComboBox.isEditable() && windowsComboBoxUI.isPopupVisible(jComboBox)) {
                    windowsComboBoxUI.selectPreviousPossibleValue();
                }
            }
        }
    }

    static class DownAction
    extends AbstractAction {
        DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled()) {
                WindowsComboBoxUI windowsComboBoxUI = (WindowsComboBoxUI)jComboBox.getUI();
                if (!jComboBox.isEditable() || jComboBox.isEditable() && windowsComboBoxUI.isPopupVisible(jComboBox)) {
                    windowsComboBoxUI.selectNextPossibleValue();
                }
            }
        }
    }

    public static class WindowsComboBoxEditor
    extends BasicComboBoxEditor.UIResource {
        public void setItem(Object object) {
            super.setItem(object);
            this.editor.selectAll();
        }
    }

    protected class WindowsComboPopup
    extends BasicComboPopup {
        public WindowsComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        protected KeyListener createKeyListener() {
            return new InvocationKeyHandler();
        }

        protected class InvocationKeyHandler
        extends BasicComboPopup.InvocationKeyHandler {
            protected InvocationKeyHandler() {
                super(WindowsComboPopup.this);
            }
        }
    }
}

