/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.orbutil;

import com.sun.corba.se.internal.corba.ORB;
import com.sun.corba.se.internal.core.ORBVersion;
import com.sun.corba.se.internal.core.ORBVersionImpl;
import com.sun.corba.se.internal.orbutil.ORBClassLoader;
import com.sun.corba.se.internal.orbutil.ValueHandlerImpl_1_3;
import com.sun.corba.se.internal.orbutil.ValueHandlerImpl_1_3_1;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public final class ORBUtility {
    private static StructMember[] members = null;
    private static final Hashtable exceptionClassNames = new Hashtable();
    private static final Hashtable exceptionRepositoryIds = new Hashtable();
    static /* synthetic */ Class class$org$omg$CORBA$TypeCode;

    private ORBUtility() {
    }

    private static StructMember[] systemExceptionMembers(org.omg.CORBA.ORB oRB) {
        if (members == null) {
            members = new StructMember[3];
            ORBUtility.members[0] = new StructMember("id", oRB.create_string_tc(0), null);
            ORBUtility.members[1] = new StructMember("minor", oRB.get_primitive_tc(TCKind.tk_long), null);
            ORBUtility.members[2] = new StructMember("completed", oRB.get_primitive_tc(TCKind.tk_long), null);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypeCode getSystemExceptionTypeCode(org.omg.CORBA.ORB oRB, String string, String string2) {
        Class clazz = class$org$omg$CORBA$TypeCode == null ? (class$org$omg$CORBA$TypeCode = ORBUtility.class$("org.omg.CORBA.TypeCode")) : class$org$omg$CORBA$TypeCode;
        synchronized (clazz) {
            return oRB.create_exception_tc(string, string2, ORBUtility.systemExceptionMembers(oRB));
        }
    }

    private static boolean isSystemExceptionTypeCode(TypeCode typeCode, org.omg.CORBA.ORB oRB) {
        StructMember[] structMemberArray = ORBUtility.systemExceptionMembers(oRB);
        try {
            return typeCode.kind().value() == 22 && typeCode.member_count() == 3 && typeCode.member_type(0).equal(structMemberArray[0].type) && typeCode.member_type(1).equal(structMemberArray[1].type) && typeCode.member_type(2).equal(structMemberArray[2].type);
        }
        catch (BadKind badKind) {
            return false;
        }
        catch (Bounds bounds) {
            return false;
        }
    }

    public static void insertSystemException(SystemException systemException, Any any) {
        OutputStream outputStream = any.create_output_stream();
        org.omg.CORBA.ORB oRB = outputStream.orb();
        String string = systemException.getClass().getName();
        String string2 = ORBUtility.repositoryIdOf(string);
        outputStream.write_string(string2);
        outputStream.write_long(systemException.minor);
        outputStream.write_long(systemException.completed.value());
        any.read_value(outputStream.create_input_stream(), ORBUtility.getSystemExceptionTypeCode(oRB, string2, string));
    }

    public static SystemException extractSystemException(Any any) {
        InputStream inputStream = any.create_input_stream();
        org.omg.CORBA.ORB oRB = inputStream.orb();
        if (!ORBUtility.isSystemExceptionTypeCode(any.type(), oRB)) {
            return new UNKNOWN(1398079692, CompletionStatus.COMPLETED_MAYBE);
        }
        return ORBUtility.readSystemException(inputStream);
    }

    public static ValueHandler createValueHandler(ORB oRB) {
        if (oRB == null) {
            return Util.createValueHandler();
        }
        ORBVersion oRBVersion = oRB.getORBVersion();
        if (oRBVersion == null) {
            return Util.createValueHandler();
        }
        if (oRBVersion.equals(ORBVersionImpl.OLD)) {
            return new ValueHandlerImpl_1_3();
        }
        if (oRBVersion.equals(ORBVersionImpl.NEW)) {
            return new ValueHandlerImpl_1_3_1();
        }
        return Util.createValueHandler();
    }

    public static boolean isLegacyORB(ORB oRB) {
        try {
            ORBVersion oRBVersion = oRB.getORBVersion();
            return oRBVersion.equals(ORBVersionImpl.OLD);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean isForeignORB(ORB oRB) {
        if (oRB == null) {
            return false;
        }
        try {
            return oRB.getORBVersion().equals(ORBVersionImpl.FOREIGN);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static int bytesToInt(byte[] byArray, int n2) {
        int n3 = byArray[n2++] << 24 & 0xFF000000;
        int n4 = byArray[n2++] << 16 & 0xFF0000;
        int n5 = byArray[n2++] << 8 & 0xFF00;
        int n6 = byArray[n2++] << 0 & 0xFF;
        return n3 | n4 | n5 | n6;
    }

    public static void intToBytes(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 0 & 0xFF);
    }

    public static int hexOf(char c2) {
        int n2 = c2 - 48;
        if (n2 >= 0 && n2 <= 9) {
            return n2;
        }
        n2 = c2 - 97 + 10;
        if (n2 >= 10 && n2 <= 15) {
            return n2;
        }
        n2 = c2 - 65 + 10;
        if (n2 >= 10 && n2 <= 15) {
            return n2;
        }
        throw new DATA_CONVERSION(1398079693, CompletionStatus.COMPLETED_NO);
    }

    public static void writeSystemException(SystemException systemException, OutputStream outputStream) {
        String string = ORBUtility.repositoryIdOf(systemException.getClass().getName());
        outputStream.write_string(string);
        outputStream.write_long(systemException.minor);
        outputStream.write_long(systemException.completed.value());
    }

    public static SystemException readSystemException(InputStream inputStream) {
        try {
            String string = ORBUtility.classNameOf(inputStream.read_string());
            SystemException systemException = (SystemException)ORBClassLoader.loadClass(string).newInstance();
            systemException.minor = inputStream.read_long();
            systemException.completed = CompletionStatus.from_int(inputStream.read_long());
            return systemException;
        }
        catch (Exception exception) {
            return new UNKNOWN(1398079693, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public static String classNameOf(String string) {
        String string2 = null;
        string2 = (String)exceptionClassNames.get(string);
        if (string2 == null) {
            string2 = "org.omg.CORBA.UNKNOWN";
        }
        return string2;
    }

    public static boolean isSystemException(String string) {
        String string2 = null;
        string2 = (String)exceptionClassNames.get(string);
        return string2 != null;
    }

    public static String repositoryIdOf(String string) {
        String string2 = (String)exceptionRepositoryIds.get(string);
        if (string2 == null) {
            string2 = "IDL:omg.org/CORBA/UNKNOWN:1.0";
        }
        return string2;
    }

    public static int[] parseVersion(String string) {
        if (string == null) {
            return new int[0];
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length && (cArray[n2] < '0' || cArray[n2] > '9')) {
            if (n2 == cArray.length) {
                return new int[0];
            }
            ++n2;
        }
        int n3 = n2 + 1;
        int n4 = 1;
        while (n3 < cArray.length) {
            if (cArray[n3] == '.') {
                ++n4;
            } else if (cArray[n3] < '0' || cArray[n3] > '9') break;
            ++n3;
        }
        int[] nArray = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            int n6 = string.indexOf(46, n2);
            if (n6 == -1 || n6 > n3) {
                n6 = n3;
            }
            nArray[n5] = n2 >= n6 ? 0 : Integer.parseInt(string.substring(n2, n6));
            n2 = n6 + 1;
            ++n5;
        }
        return nArray;
    }

    public static int compareVersion(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (nArray2 == null) {
            nArray2 = new int[]{};
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n2 >= nArray2.length || nArray[n2] > nArray2[n2]) {
                return 1;
            }
            if (nArray[n2] < nArray2[n2]) {
                return -1;
            }
            ++n2;
        }
        return nArray.length == nArray2.length ? 0 : -1;
    }

    public static int compareVersion(String string, String string2) {
        return ORBUtility.compareVersion(ORBUtility.parseVersion(string), ORBUtility.parseVersion(string2));
    }

    /*
     * Unable to fully structure code
     */
    public static String objectToString(Object var0) {
        block35: {
            if (var0 == null) {
                return "null";
            }
            var1_1 = new StringBuffer();
            var2_2 = var0.getClass();
            var3_3 = var2_2.getComponentType();
            if (var0 instanceof Properties) {
                var4_4 = (Properties)var0;
                var1_1.append(var2_2.getName());
                var1_1.append("(");
                var5_6 = var4_4.propertyNames();
                while (var5_6.hasMoreElements()) {
                    var6_17 = (String)var5_6.nextElement();
                    var7_29 = var4_4.getProperty(var6_17);
                    var1_1.append(" ");
                    var1_1.append(var6_17);
                    var1_1.append("=");
                    var1_1.append(var7_29);
                }
                var1_1.append(" )");
                return var1_1.toString();
            }
            try {
                var2_2.getDeclaredMethod("toString", null);
                return var0.toString();
            }
            catch (Exception var4_5) {
                if (var3_3 != null) break block35;
                try {
                    var5_7 = var2_2.getFields();
                }
                catch (SecurityException var6_18) {
                    return var0.toString();
                }
                var1_1.append(var2_2.getName());
                var1_1.append("(");
                var6_19 = 0;
                ** while (var6_19 < var5_7.length)
            }
lbl-1000:
            // 1 sources

            {
                var7_30 = var5_7[var6_19];
                var1_1.append(" ");
                var1_1.append(var7_30.getName());
                var1_1.append("=");
                try {
                    var8_31 = var7_30.get(var0);
                    var1_1.append(ORBUtility.objectToString(var8_31));
                }
                catch (Exception var8_32) {
                    var1_1.append("???");
                }
                ++var6_19;
                continue;
            }
lbl62:
            // 1 sources

            var1_1.append(" )");
            return var1_1.toString();
        }
        var1_1.append(var3_3.getName());
        var1_1.append("[");
        if (var3_3 == Boolean.TYPE) {
            var5_8 = (boolean[])var0;
            var1_1.append(var5_8.length);
            var1_1.append("](");
            var6_20 = 0;
            while (var6_20 < var5_8.length) {
                var1_1.append(" ");
                var1_1.append(var5_8[var6_20]);
                ++var6_20;
            }
        } else if (var3_3 == Byte.TYPE) {
            var5_9 = (byte[])var0;
            var1_1.append(var5_9.length);
            var1_1.append("](");
            var6_21 = 0;
            while (var6_21 < var5_9.length) {
                var1_1.append(" ");
                var1_1.append(var5_9[var6_21]);
                ++var6_21;
            }
        } else if (var3_3 == Short.TYPE) {
            var5_10 = (short[])var0;
            var1_1.append(var5_10.length);
            var1_1.append("](");
            var6_22 = 0;
            while (var6_22 < var5_10.length) {
                var1_1.append(" ");
                var1_1.append(var5_10[var6_22]);
                ++var6_22;
            }
        } else if (var3_3 == Integer.TYPE) {
            var5_11 = (int[])var0;
            var1_1.append(var5_11.length);
            var1_1.append("](");
            var6_23 = 0;
            while (var6_23 < var5_11.length) {
                var1_1.append(" ");
                var1_1.append(var5_11[var6_23]);
                ++var6_23;
            }
        } else if (var3_3 == Long.TYPE) {
            var5_12 = (long[])var0;
            var1_1.append(var5_12.length);
            var1_1.append("](");
            var6_24 = 0;
            while (var6_24 < var5_12.length) {
                var1_1.append(" ");
                var1_1.append(var5_12[var6_24]);
                ++var6_24;
            }
        } else if (var3_3 == Character.TYPE) {
            var5_13 = (char[])var0;
            var1_1.append(var5_13.length);
            var1_1.append("](");
            var6_25 = 0;
            while (var6_25 < var5_13.length) {
                var1_1.append(" ");
                var1_1.append(var5_13[var6_25]);
                ++var6_25;
            }
        } else if (var3_3 == Float.TYPE) {
            var5_14 = (float[])var0;
            var1_1.append(var5_14.length);
            var1_1.append("](");
            var6_26 = 0;
            while (var6_26 < var5_14.length) {
                var1_1.append(" ");
                var1_1.append(var5_14[var6_26]);
                ++var6_26;
            }
        } else if (var3_3 == Double.TYPE) {
            var5_15 = (double[])var0;
            var1_1.append(var5_15.length);
            var1_1.append("](");
            var6_27 = 0;
            while (var6_27 < var5_15.length) {
                var1_1.append(" ");
                var1_1.append(var5_15[var6_27]);
                ++var6_27;
            }
        } else {
            var5_16 = (Object[])var0;
            var1_1.append(var5_16.length);
            var1_1.append("](");
            var6_28 = 0;
            while (var6_28 < var5_16.length) {
                var1_1.append(" ");
                var1_1.append(ORBUtility.objectToString(var5_16[var6_28]));
                ++var6_28;
            }
        }
        var1_1.append(" ]");
        return var1_1.toString();
    }

    public static void dprint(Object object, String string) {
        System.out.println(object.getClass().getName() + "(" + Thread.currentThread() + "): " + string);
    }

    public static void dprint(String string, String string2) {
        System.out.println(string + "(" + Thread.currentThread() + "): " + string2);
    }

    public void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public static void dprint(Object object, String string, Throwable throwable) {
        System.out.println(object.getClass().getName() + '(' + Thread.currentThread() + "): " + string);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public static String[] concatenateStringArrays(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray3[n2] = stringArray[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray2.length) {
            stringArray3[n3 + stringArray.length] = stringArray2[n3];
            ++n3;
        }
        return stringArray3;
    }

    public static void throwNotSerializableForCorba(String string) {
        throw new BAD_PARAM(string, 1330446342, CompletionStatus.COMPLETED_MAYBE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_CONTEXT:1.0", "org.omg.CORBA.BAD_CONTEXT");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_INV_ORDER:1.0", "org.omg.CORBA.BAD_INV_ORDER");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_OPERATION:1.0", "org.omg.CORBA.BAD_OPERATION");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_PARAM:1.0", "org.omg.CORBA.BAD_PARAM");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_TYPECODE:1.0", "org.omg.CORBA.BAD_TYPECODE");
        exceptionClassNames.put("IDL:omg.org/CORBA/COMM_FAILURE:1.0", "org.omg.CORBA.COMM_FAILURE");
        exceptionClassNames.put("IDL:omg.org/CORBA/DATA_CONVERSION:1.0", "org.omg.CORBA.DATA_CONVERSION");
        exceptionClassNames.put("IDL:omg.org/CORBA/IMP_LIMIT:1.0", "org.omg.CORBA.IMP_LIMIT");
        exceptionClassNames.put("IDL:omg.org/CORBA/INTF_REPOS:1.0", "org.omg.CORBA.INTF_REPOS");
        exceptionClassNames.put("IDL:omg.org/CORBA/INTERNAL:1.0", "org.omg.CORBA.INTERNAL");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_FLAG:1.0", "org.omg.CORBA.INV_FLAG");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_IDENT:1.0", "org.omg.CORBA.INV_IDENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_OBJREF:1.0", "org.omg.CORBA.INV_OBJREF");
        exceptionClassNames.put("IDL:omg.org/CORBA/MARSHAL:1.0", "org.omg.CORBA.MARSHAL");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_MEMORY:1.0", "org.omg.CORBA.NO_MEMORY");
        exceptionClassNames.put("IDL:omg.org/CORBA/FREE_MEM:1.0", "org.omg.CORBA.FREE_MEM");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_IMPLEMENT:1.0", "org.omg.CORBA.NO_IMPLEMENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_PERMISSION:1.0", "org.omg.CORBA.NO_PERMISSION");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_RESOURCES:1.0", "org.omg.CORBA.NO_RESOURCES");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_RESPONSE:1.0", "org.omg.CORBA.NO_RESPONSE");
        exceptionClassNames.put("IDL:omg.org/CORBA/OBJ_ADAPTER:1.0", "org.omg.CORBA.OBJ_ADAPTER");
        exceptionClassNames.put("IDL:omg.org/CORBA/INITIALIZE:1.0", "org.omg.CORBA.INITIALIZE");
        exceptionClassNames.put("IDL:omg.org/CORBA/PERSIST_STORE:1.0", "org.omg.CORBA.PERSIST_STORE");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSIENT:1.0", "org.omg.CORBA.TRANSIENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/UNKNOWN:1.0", "org.omg.CORBA.UNKNOWN");
        exceptionClassNames.put("IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0", "org.omg.CORBA.OBJECT_NOT_EXIST");
        exceptionClassNames.put("IDL:omg.org/CORBA/INVALID_TRANSACTION:1.0", "org.omg.CORBA.INVALID_TRANSACTION");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_REQUIRED:1.0", "org.omg.CORBA.TRANSACTION_REQUIRED");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_ROLLEDBACK:1.0", "org.omg.CORBA.TRANSACTION_ROLLEDBACK");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_POLICY:1.0", "org.omg.CORBA.INV_POLICY");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_UNAVAILABLE:1.0", "org.omg.CORBA.TRANSACTION_UNAVAILABLE");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_MODE:1.0", "org.omg.CORBA.TRANSACTION_MODE");
        Enumeration enumeration = exceptionClassNames.keys();
        try {
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                String string = (String)object;
                String string2 = (String)exceptionClassNames.get(string);
                exceptionRepositoryIds.put(string2, string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
    }
}

