/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.usability;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import sun.plugin.AppletViewer;
import sun.plugin.usability.Trace;

public class Steamer
implements ActionListener {
    private Timer ticker;
    private static final int NUMBER_OF_IMAGES = 1;
    private static final String img_base = "sun/plugin/usability/cup";
    private static final String broken_image = "sun/plugin/usability/graybox_broken.gif";
    private static Image[] cups = new Image[1];
    private static Image broken_graybox_image = null;
    private String custom_image_file = null;
    private Image custom_image;
    private int current_image_number = 0;
    private URL codebase;
    private boolean applet_error = false;
    private int X_coordinate = 6;
    private int Y_coordinate = 6;
    AppletViewer av;
    private static MediaTracker tracker;
    private static boolean init;

    public Steamer(AppletViewer appletViewer) {
        this.av = appletViewer;
    }

    private void loadDefaultImages() {
        if (init) {
            return;
        }
        init = true;
        this.loadFirstImage();
        Steamer.loadOtherImages();
    }

    public void init() {
        tracker = new MediaTracker((Component)((Object)this.av));
        this.loadDefaultImages();
        if (this.custom_image_file != null) {
            this.loadCustomImage();
        } else {
            this.startTimer();
        }
    }

    public void stop() {
        this.stopTimer();
        this.av.repaint();
    }

    public void error() {
        this.applet_error = true;
        this.X_coordinate = 6;
        this.Y_coordinate = 6;
        this.custom_image = null;
    }

    public void destroy() {
        this.stopTimer();
    }

    public synchronized void startTimer() {
    }

    public synchronized void stopTimer() {
    }

    private void loadFirstImage() {
        if (cups[0] == null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    cups[0] = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("sun/plugin/usability/cup1.gif"));
                    tracker.addImage(cups[0], 2);
                    try {
                        tracker.waitForID(2);
                        Steamer.this.av.repaint();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            };
            Thread thread = new Thread(runnable, "Default Image Loader");
            thread.start();
        }
    }

    private static synchronized void loadOtherImages() {
        Runnable runnable = new Runnable(){

            public void run() {
                int n = 1;
                while (n < 1) {
                    String string = Steamer.img_base + (n + 1) + ".gif";
                    cups[n] = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string));
                    ++n;
                }
            }
        };
        Thread thread = new Thread(runnable, "Graybox Image Loader");
        thread.start();
    }

    private void loadCustomImage() {
        Runnable runnable = new Runnable(){

            public void run() {
                block4: {
                    try {
                        if (Steamer.this.custom_image_file == null) break block4;
                        URL uRL = new URL(Steamer.this.codebase, Steamer.this.custom_image_file);
                        Steamer.this.custom_image = Toolkit.getDefaultToolkit().getImage(uRL);
                        tracker.addImage(Steamer.this.custom_image, 1);
                        Steamer.this.X_coordinate = 0;
                        Steamer.this.Y_coordinate = 0;
                        try {
                            tracker.waitForID(1);
                            Steamer.this.av.repaint();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        Trace.msgPrintln("image_failed");
                    }
                }
            }
        };
        Thread thread = new Thread(runnable, "Custom Image Loader");
        thread.start();
    }

    public Image getCurrentImage() {
        if (this.applet_error) {
            this.stopTimer();
            broken_graybox_image = new ImageIcon(ClassLoader.getSystemResource(broken_image)).getImage();
            return broken_graybox_image;
        }
        if (this.custom_image != null) {
            return this.custom_image;
        }
        this.startTimer();
        return this.getCurrentImage(this.current_image_number);
    }

    private Image getCurrentImage(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = n;
        while (n2 >= 0) {
            if (cups[n2] != null) {
                return cups[n2];
            }
            --n2;
        }
        return null;
    }

    public Point getImgCoordinates() {
        return new Point(this.X_coordinate, this.Y_coordinate);
    }

    public void setCustomImage(URL uRL, String string) {
        this.X_coordinate = 0;
        this.Y_coordinate = 0;
        this.codebase = uRL;
        this.custom_image_file = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ++this.current_image_number;
        this.current_image_number %= 1;
        this.av.repaint();
    }

    static {
        init = false;
    }
}

