/***************************************************************************
                          klprfax.cpp  -  description
                             -------------------
    begin                : Thu May 24 23:17:55 'Europe/Amsterdam' 2001
    copyright            : (C) 2001 by Hans Dijkema
    email                : hdijkema@hum.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "klprfax.moc"

#include <kmessagebox.h>
#include <kaboutapplication.h>
#include <klocale.h>
#include <kio/netaccess.h>
#include <kstandarddirs.h>
#include <kabc/stdaddressbook.h>
#include <kdebug.h>

#include <qfile.h>

#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>

#include <fcntl.h>
#include <unistd.h>


Klprfax::Klprfax(KApplication *_app,KConfigBase *cnf,QCString faxF,QWidget *parent, const char *_name) : QWidget(parent, _name)
{
QString        nil="";

   app=_app;

   fatal=false;
   findEFax();

   // Dialog

   dlg=new QGrid(5,QGrid::Vertical,this);
   dlg->setMargin(10);
   dlg->setSpacing(10);

   // Fax numbers

   names=new klprfax_table(1,2,dlg);
   names->setMinimumSize(200,100);
   names->setMaximumSize(1024,120);
   names->setSelectionMode(QTable::NoSelection);
   {QHeader *h=names->horizontalHeader();
      h->setLabel(0,i18n("Name"));
      h->setLabel(1,i18n("Fax No."));
   }

   // Search all entries with fax numbers

   KABC::AddressBook *ab = KABC::StdAddressBook::self();
   
   KABC::AddressBook::Iterator it;
   
   int rows=-1,col0=0,col1=0;
   for( it = ab->begin(); it != ab->end(); ++it ) {
     QString name,fax0,fax1,fax2,fax3;
     if (NameFax(*it,name,fax0,fax1,fax2,fax3)) {
        klprfax_widget *tmp;

	rows+=1;if (rows>=names->numRows()) { names->setNumRows(rows+1); }

	tmp=new klprfax_widget(rows,0,names);
	tmp->add(name);
	tmp->commit();
	tmp->adjustSize();
	if (tmp->width()>col0) { col0=tmp->widget()->width()+5; }
qWarning("col0 = %d", col0);
        tmp=new klprfax_widget(rows,1,names);
        tmp->add(fax0);tmp->add(fax1);tmp->add(fax2);tmp->add(fax3);
	tmp->commit();
	tmp->adjustSize();
	if (tmp->widget()->width()>col1) { col1=tmp->widget()->width()+5; }
qWarning("col1 = %d", col1);

        names->adjustRow(rows);
     }
   }
   names->setColumnWidth(0,col0);
   names->setColumnWidth(1,col1);
   names->adjustSize();

   // Headers

   edits=new QGrid(2,dlg);
   edits->setSpacing(10);
   edits->setMargin(10);
   edits->setFrameStyle(QFrame::Box|QFrame::Raised);

   lfrom=new QLabel(edits);
   lfrom->setText(i18n("your header :"));
   from=new QLineEdit(edits);
   from->setMinimumWidth(200);

   lfromFax=new QLabel(edits);
   lfromFax->setText(i18n("your fax :"));
   fromFax=new QLineEdit(edits);

   conf=cnf;
   conf->setGroup("klprfax");
   {QString ft,fft;
     ft=conf->readEntry("from",nil);
     fft=conf->readEntry("fromFax",nil);
     from->setText(ft);
     fromFax->setText(fft);
   }

   lprefix=new QLabel(edits);
   lprefix->setText(i18n("Dial prefix :"));
   prefix=new QLineEdit(edits);
   prefix->setText(conf->readEntry("dialprefix",nil));

   // Progress bar

   progr=new QGrid(2,dlg);
   progr->setSpacing(10);

   doing=new QLabel(progr);
   doing->setText(i18n("doing nothing"));
   progress=new QProgressBar(progr);
   progress->setTotalSteps(4);
   progress->reset();

   // Buttons

   buttons=new QGrid(5,dlg);
   buttons->setSpacing(10);

   about=new QPushButton(buttons);about->setText(i18n("&About"));
   configure=new QPushButton(buttons);configure->setText(i18n("&Save Config"));
   noFax=new QPushButton(buttons);noFax->setText(i18n("&Done"));
   goFax=new QPushButton(buttons);goFax->setText(i18n("&Fax Document"));
   gogoFax=new QPushButton(buttons);gogoFax->setText(i18n("&Fax With Prefix"));

   connect(about,SIGNAL(clicked()),SLOT(doAbout()) );
   connect(configure, SIGNAL(clicked()), SLOT(setConfig()) );
   connect(noFax, SIGNAL(clicked()), SLOT(noFaxing()) );
   connect(goFax, SIGNAL(clicked()), SLOT(goFaxing()) );
   connect(gogoFax, SIGNAL(clicked()), SLOT(gogoFaxing()) );

   // Log list

   log = new QListBox(dlg);
   log->setMinimumHeight(80);
   log->setMaximumHeight(80);

   // adjust the dialog size

   dlg->adjustSize();
   //adjustSize();
   setFixedSize(dlg->width(),dlg->height());

   // Read the fax to fax.

   {QString cwd;
    char line[4096];
      getcwd(line,4096);
      cwd.sprintf("%s",line);
      faxFile=faxF;faxFile=cwd+"/"+faxFile;
      {FILE *f=fopen(faxFile.latin1(),"rb");
          if (f==NULL) { faxFile=faxF; }
          f=fopen(faxFile.latin1(),"rb");
          if (f==NULL) {
            KMessageBox::error(this,i18n("Can't open file to fax"));
            fatal=true;
          }
      }
   }

   // Set the Done button behaviour to default

   canCancel=false;

   // Set the kprocess behaviour

   connect(&efax_helper,SIGNAL(receivedStdout(KProcess *,char *,int )),SLOT(efaxOutput(KProcess *,char *,int )));
   connect(&efax_helper,SIGNAL(receivedStderr(KProcess *,char *,int )),SLOT(efaxOutput(KProcess *,char *,int )));
   connect(&efax_helper,SIGNAL(processExited(KProcess *)),SLOT(efaxExited(KProcess *)));
}

Klprfax::~Klprfax()
{
   delete script;
}

/** No descriptions */
bool Klprfax::NameFax(KABC::Addressee & a,QString & name, QString & fax0,QString & fax1, QString & fax2, QString & fax3)
{
  KABC::PhoneNumber::List numbers = a.phoneNumbers();

  bool isFax=false;
  int fn=0;
  
  KABC::PhoneNumber::List::Iterator it;
  for( it = numbers.begin(); it != numbers.end(); ++it ) {
    if ( (*it).type() & KABC::PhoneNumber::Fax ) {
      QString fax = (*it).number();
      kdDebug() << "Found " << a.realName() << ": " << fax << endl;
      isFax = true;
      switch (fn++) {
        case 0 : fax0=fax;
        break;
        case 1 : fax1=fax;
        break;
        case 2 : fax2=fax;
        break;
        case 3 : fax3=fax;
        break;
	default : kdDebug() << "Too many fax numbers." << endl;
      }
    }
  }

  if (isFax) {
    name=a.realName();
  }

  return isFax;
}

/** No descriptions */
void Klprfax::noFaxing()
{
  if (canCancel) {
    doLog(i18n("Cancelling efax..."));
    if (!efax_helper.kill(SIGTERM)) {
      doLog(i18n("Cancelling persistent efax..."));
      efax_helper.kill(SIGKILL);
    }
  }
  else {
    close();
  }
}

void Klprfax::setConfig(void)
{
  conf->setGroup("klprfax");
  conf->writeEntry("from",from->text());
  conf->writeEntry("fromFax",fromFax->text());
  conf->writeEntry("dialprefix",prefix->text().stripWhiteSpace());
}

void Klprfax::gogoFaxing()
{
  dialPrefix=true;
  Fax();
}


/** No descriptions */
void Klprfax::goFaxing()
{
  dialPrefix=false;
  Fax();
}

void Klprfax::Fax()
{
  QString device;
  QFile dev("/etc/klprfax");
  if (dev.open(IO_ReadOnly))
  {
     dev.readLine(device, 1024);
     device = device.stripWhiteSpace();
     dev.close();
  }
  if (device.isEmpty()) {
     KMessageBox::error(this,i18n("No modem device configured, run klprfax as root"));
     return;
  }

  klprfax_widget *it = 0;
  if (names->currentRow()!=-1) {
    it=(klprfax_widget *) names->cellWidget(names->currentRow(),1);
  }
  if (!it || it->text().isEmpty()) {
    KMessageBox::sorry(this,i18n("You must select a fax number first."));
    return;
  }

  QString tel=it->text();
  if (dialPrefix) {
    tel=prefix->text().stripWhiteSpace()+tel;   // add the prefix
  }

  it=(klprfax_widget *) names->cellWidget(names->currentRow(),0);
  QString name=it->text();

  // Now start the faxing!!!

  script = new KTempFile(QString::null, "fax");
  script->setAutoDelete(true);
  dir = locateLocal("tmp", QString("faxd.%1").arg(getpid()));

  doing->setText(i18n("preparing fax command..."));
  progress->setProgress(1);

  QFile fax_file(path_fax);
  if (!fax_file.open(IO_ReadOnly))
  {
     QString msg=i18n("Can't open '%1'").arg(path_fax);
     KMessageBox::error(this,msg);
     return;
  } 

  QTextStream fax_stream(&fax_file);
  QTextStream &script_stream = *(script->textStream());
  script_stream.setEncoding(QTextStream::Locale);

  while(!fax_stream.atEnd())
  {
     QString line = fax_stream.readLine();

     if (line.startsWith("NAME="))
        script_stream << QString("NAME=\"%1\"\n").arg(from->text());
     else if (line.startsWith("FROM="))
        script_stream << QString("FROM=\"%1\"\n").arg(fromFax->text());
     else if (line.startsWith("FAILRETRIES=") ||
              line.startsWith("BUSYRETRIES=")) 
        ;// skip line
     else if (line.startsWith("DEV="))
        script_stream << QString("DEV=\"%1\"\n").arg(device);
     else if (line.startsWith("FAX="))
        script_stream << QString("FAX=%1\n").arg(path_fax);
     else if (line.startsWith("EFAX="))
        script_stream << QString("EFAX=%1\n").arg(path_efax);
     else if (line.startsWith("EFIX="))
        script_stream << QString("EFIX=%1\n").arg(path_efix);
     else 
        script_stream << line << endl;
  }
  fax_file.close();
  script->close();

  doing->setText(i18n("copying input file..."));
  progress->setProgress(2);

  mkdir(QFile::encodeName(dir),S_IRWXU);
  if (chdir(QFile::encodeName(dir))==-1) {
     QString msg=i18n("Can't change directory to : %1").arg(dir);
     KMessageBox::error(this,msg);
     return;
  }

  KURL url_source;
  url_source.setPath(faxFile);
  KURL url_dest;
  url_dest.setPath(dir+"/faxfile");
  KIO::NetAccess::copy(url_source, url_dest);

  doing->setText(i18n("efax is running..."));
  progress->setProgress(3);

  enableAll(false);
  log->clear();
  efax_helper.clearArguments();
  efax_diagnostic="";

  doLog(i18n("name=%1 ").arg(name)+i18n("fax no.=%1").arg(tel));

  chmod(QFile::encodeName(script->name()),S_IXUSR|S_IRUSR|S_IWUSR);

  efax_helper << script->name();
  efax_helper << "send" << "\""+tel+"\"" << url_dest.path();

  if (!efax_helper.start(KProcess::NotifyOnExit,KProcess::AllOutput)) {
     KMessageBox::error(this,i18n("Can't start efax process"));
     enableAll();
  }
}

/** No descriptions */
void Klprfax::findEFax()
{
  path_fax = KStandardDirs::findExe("fax");
  path_efax = KStandardDirs::findExe("efax");
  path_efix = KStandardDirs::findExe("efix");

  if (path_fax.isEmpty())
  {
     KMessageBox::error(this,"Can't find 'fax' on this system, "
                             "the klprfax package didn't install right.");
     fatal=true;
  }
  else if (path_efax.isEmpty())
  {
     KMessageBox::error(this,"Can't find 'efax' on this system, "
                             "the klprfax package didn't install right.");
     fatal=true;
  }
  else if (path_efix.isEmpty())
  {
     KMessageBox::error(this,"Can't find 'efix' on this system, "
                             "the klprfax package didn't install right.");
     fatal=true;
  }
}


void Klprfax::doAbout()
{
   KAboutApplication(this).exec();
}


void Klprfax::efaxOutput(KProcess *proc,char *buf, int  len)
{
  int i;
  for(i=0;i<len;i++) {
    if (buf[i]=='\n') {
      doLog(efax_diagnostic);
      efax_diagnostic="";
    }
    else {
      efax_diagnostic+=buf[i];
    }
  }
}

void Klprfax::efaxExited(KProcess *p)
{
  QString txt;
  bool    err=false;

  if (!p->normalExit()) {
    txt=i18n("efax has been canceled");
    doing->setText("CANCELED");
    progress->setProgress(4);
    err=true;
  }
  else {
    int status=p->exitStatus();
    if (status==0) {
      doing->setText("fax successfully sent");
      progress->setProgress(4);
    }
    else {
          switch (status) {
             case 1 : txt=i18n("number busy or modem already in use");
             break;
             case 2 : txt=i18n("Is your modem connected?");
             break;
             case 3 : txt=i18n("modem error, maybe no fax at the other side?");
             break;
             case 4 : txt=i18n("no response from modem");
             break;
             case 5 : txt=i18n("efax has been canceled");
             break;
             default: txt=i18n("I can't figure out what happened");
          }
          doing->setText(i18n("NO SUCCESS"));
          progress->setProgress(4);
          err=true;
    }
  }

  if (err) {
    txt+=i18n("\nlog can be found at '")+dir+"'";
    txt+=i18n("\nYou can watch it before closing this box");
    KMessageBox::sorry(this,txt);
  }

  KURL url_dir;
  url_dir.setPath(dir);
  KIO::NetAccess::del(url_dir);

  delete script;
  script = 0;

  enableAll();
}


void Klprfax::enableAll(bool yes)
{
  goFax->setEnabled(yes);
  if (yes)
    noFax->setText(i18n("&Done")); 
  else 
    noFax->setText(i18n("&Cancel")); 

  canCancel=!yes;
  gogoFax->setEnabled(yes);
  about->setEnabled(yes);
  configure->setEnabled(yes);
}


void Klprfax::doLog(QString s)
{
  log->insertItem(s);
  log->setCurrentItem(log->count()-1);
}
