#ifndef BASE_DEFINES_H
#define BASE_DEFINES_H

#include "ghighscores.h"


#define GIFT_SHOWER_TIMEOUT  800
#define GIFT_POOL_TIMEOUT   2000

#define SHADOW_HEIGHT 10

#define GI_WIDTH     15
#define GI_HEIGHT    11
#define ARROW_HEIGHT  3
#define ARROW_WIDTH   7

#define LED_WIDTH  15
#define LED_HEIGHT 15
#define LED_SPACING 5

struct MainData {
    const char *name, *trName, *description, *homepage, *removedLabel;
};

struct BoardInfo {
    uint width, height;
    bool withPieces;

    uint minBlockSize, maxBlockSize;
    bool blockSizeMustBeOdd;

    uint baseTime, dropDownTime, beforeGlueTime, afterGlueTime;
    uint beforeRemoveTime, afterRemoveTime, afterGiftTime;
    uint nbBumpStages, nbToggles, nbFallStages;

    uint nbGiftLeds, maxGiftsToSend, giftShowerTimeout, giftPoolTimeout;
};

extern const char *OP_GROUP;

class BaseBoard;
class BaseField;
class AI;

class Factory
{
 public:
    Factory();
    virtual ~Factory();

    static Factory *self() { return _self; }

    virtual BaseBoard *createBoard(bool graphic, QWidget *parent) = 0;
    virtual BaseField *createField(QWidget *parent) = 0;
    virtual AI *createAI() { return 0; }

    virtual const MainData &mainData() const = 0;
    virtual const BoardInfo &boardInfo() const = 0;

 protected:
    virtual KSettingWidget *createAISettings() { return 0; }
    virtual KSettingWidget *createAppearanceSettings() = 0;
    virtual KSettingWidget *createGameSettings() = 0;

 private:
    static Factory *_self;
};

#endif
