/***************************************************************************
                          geoobjects.h  -  description
                             -------------------
    begin                : Sat Feb 19 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GEOOBJECTS_H
#define GEOOBJECTS_H

#include <qpoint.h>
#include <qpointarray.h>
#include <qpaintdevice.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qspinbox.h>
#include <qptrlist.h>
#include <qlineedit.h>
#include <qrect.h>
#include <qobject.h>
#include <qcolor.h>
#include <qdrawutil.h>
#include <qbutton.h>
#include <qnamespace.h>

#include <iostream.h>

#include <kapplication.h>
#include <math.h>
#include <vector>
#include <list>

#include <ksimpleconfig.h>
#include <kiconloader.h>
#include "metricscenter.h"
#include "coordinates.h"

#include "resource.h"

/**
  *@author Marc Bartsch
  */

class GeoObjects
{
	public:
	
		GeoObjects();
		virtual ~GeoObjects();

		virtual bool 					getMovable();
		virtual bool 					getTrace();
		virtual bool 					getAcceptsQPoint();
		virtual bool 					getAcceptsGeoPoint();
		virtual bool 					getAcceptsQPointOnly();
		virtual bool 					getCanBeDestroyed();
		virtual bool 					getInitComplete();
		virtual int 					getID();
		virtual int 					getLevel();
		virtual int		 				getSize();
		virtual int 					getZOrder();
		virtual double				getRadius();
		virtual double 				getAngle();
		virtual void					getObjectOverlay( QList <QRect> & );
		virtual QPoint 				getQPoint();
		virtual Coordinates		getCoordinates();
		virtual Coordinates		getStartCoordinates();
		virtual Coordinates		getEndCoordinates();
		virtual QColor 				getColor();
		virtual QString 			identify();
		virtual bool 					isGeoPoint();

		virtual void 					setChosen( bool chosen );
		virtual void 					setTrace( bool tr );
		virtual void 					setInitComplete( bool initComplete );
		virtual void 					setColor( QColor col );
		virtual void 					setSize( int sizeValue );
		virtual void 					setWidth( int widthValue );
		virtual void					setMoveOffset( QPoint *pt );
		virtual void 					setMoveOffset( Coordinates & coords );
		virtual void					setLevel( int level );
		virtual void					setUniqueID( int uniqueID );
		virtual void					setZOrder( int zOrder );

	  virtual void 					initObject( GeoObjects *obj );
	  virtual void 					initObject( QPoint *pts );
	  virtual void 					initObject( GeoObjects *pt, QPoint *pts );
	  virtual void 					paint( QPainter *p );
	  virtual void 					move( QPoint *pt );
	  virtual void 					move();
		virtual void 					moveMe( Coordinates & coords );
		virtual void 					moveMe( Coordinates & coords, double position );
		virtual double				positionMe( Coordinates & coords );
		virtual bool 					validParameter( GeoObjects *obj );
	  virtual bool 					contains( QPoint *pt );
		virtual void 					deleteObjects( QList <GeoObjects> & list );
		virtual void 					addObjects( QList <GeoObjects> & list );

		virtual void 					writeToFile( KSimpleConfig *config );
		virtual void 					readFromFile( KSimpleConfig *config );

	  QList <GeoObjects> parents;
	  QList <GeoObjects> children;

	protected:

		void convertParams( int list[], int length );
		bool processParams( GeoObjects *obj );
		bool isGeoPoint( GeoObjects *obj );
		bool isGeoLine( GeoObjects *obj );

		void getLineOverlay( QList <QRect> & list, int size, Coordinates coord1, Coordinates coord2 );
		void getCircleOverlay( QList <QRect> & list, int size, QRect rect, Coordinates coord, double rad );

		struct myParams
		{
			int ID;
			int num;
		};

		struct pointInfo
		{
			Coordinates coords;
			Coordinates printCoords;
			QPointArray arrow;
			bool				drawArrow;
			bool				goBeyond;
		};

		typedef std::list <myParams> parameterList;
		parameterList params;

	  QList <QRect> 		 trace;

		bool initComplete;
		bool acceptsQPoint;
		bool acceptsQPointOnly;
		bool acceptsGeoPoint;
		bool canBeDestroyed;
    bool isChosen;
		bool isMovable;
		bool isTrace;
		int	 width;
		int  size;
		double  radius;
		int  lineThickness;
		int  ID;
		int  uniqueID;
		int  zOrder;
		int  level;

		QColor  color;
    QString identificator;
		QRect	  surroundingRect;

		Coordinates coords;
		Coordinates moveOffset;

		pointInfo startCoords;
		pointInfo endCoords;
};

#endif

