/***************************************************************************
                          circle.cpp  -  description
                             -------------------
    begin                : Mon Mar 27 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "circle.h"

Circle::Circle(): GeoObjects()
{
  kapp->config()->setGroup( "Sizes" );
	width = kapp->config()->readNumEntry( "LineWidth", 1 );

  zOrder = 0;
	ID = ID_circle;
  identificator = "Circle";

	acceptsQPoint = false;
	acceptsGeoPoint = true;
	canBeDestroyed = false;

	int temp[] = { ID_geoPoint, 2, -1 };
	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
}

Circle::~Circle()
{
}

void Circle::paint( QPainter *p )
{

	if ( initComplete )
	{
		if ( isChosen )
		{
			p->setPen( QPen( Qt::black,8, Qt::SolidLine ) );
			p->drawEllipse( surroundingRect );
			p->setPen( QPen( QColor( 255,192,0 ), 4, Qt::SolidLine ) );
			p->drawEllipse( surroundingRect );
		}
		else
		{
			p->setBrush( Qt::NoBrush );
			p->setPen( QPen( color, width, Qt::SolidLine ) );
			p->drawEllipse( surroundingRect );
		}
	}
}

bool Circle::contains( QPoint *pt )
{
	Coordinates coord1, coord2, coord3;

	coord1 = Coordinates( *pt );
	coord2 = parents.first()->getCoordinates();
	coord3 = parents.next()->getCoordinates();

	double dist = coord1.getDistance( coord2 );
	double radius  = coord3.getDistance( coord2 );

	if ( ( dist < radius + width ) && ( dist > radius - width ) )
	{
		return true;
	}
	else
 {
		return false;
	}
}

void Circle::move()
{
 	Coordinates coord1, coord2;

 	coord1 = parents.first()->getCoordinates();
 	coord2 = parents.next()->getCoordinates();

 	int radius  = (int) coord1.getDistance( coord2 );

 	int x, y, dx, dy;
 	x = coord1.getI_X() - radius;
 	y = coord1.getI_Y() - radius;
 	dx = 2 * radius;
 	dy = 2 * radius;
		
 	surroundingRect = QRect( x, y, dx, dy );
}

void Circle::moveMe( Coordinates & coords )
{
	Coordinates coord1, coord2;

	coord1 = parents.first()->getCoordinates();
	coord2 = parents.next()->getCoordinates();

	double radius = coord2.getDistance( coord1 );

	coords = coords - coord1;
	coords.normalize( 1 );
	coords *= radius;
	coords += coord1;
}

void Circle::moveMe( Coordinates & coords, double position )
{
	Coordinates coord1, coord2;

	coord1 = parents.first()->getCoordinates();
	coord2 = parents.next()->getCoordinates();

	double radius = coord2.getDistance( coord1 );

	coords = coords - coord1;
	coords.normalize( 1 );
	coords *= radius;
	coords += coord1;
}

double Circle::positionMe( Coordinates & coords )
{
	moveMe( coords );

	return 0;
}

void Circle::writeToFile( KSimpleConfig *config )
{
	config->writeEntry( "Geo", ID_circle );
	config->writeEntry( "Color", getColor() );
	config->writeEntry( "Size", width );
}

void Circle::readFromFile( KSimpleConfig *config )
{
	color = config->readColorEntry( "Color" );
	width = config->readNumEntry( "Size" );
	initComplete = true;
}

void Circle::getObjectOverlay( QList <QRect> & list )
{
	QRect rect( surroundingRect );

	rect.setWidth( rect.width() + ( ID_overlayRectSize ) );
	rect.setHeight( rect.height() + ( ID_overlayRectSize ) );
	rect.moveCenter( surroundingRect.center() );

	double rad = ( rect.width() / 2 );

	QRect rect1( rect.topLeft(), rect.center() );

	QRect rect2( rect );
	rect2.setLeft( rect2.left() + rad );
	rect2.setBottom( rect2.top() + rad );

	QRect rect3( rect );
	rect3.setRight( rect3.right() - rad );
	rect3.setTop( rect3.top() + rad );

	QRect rect4( rect.center(), rect.bottomRight() );

	Coordinates coord( rect.center() );

	getCircleOverlay( list, ID_overlayRectSize, rect1, coord, rad );
	getCircleOverlay( list, ID_overlayRectSize, rect2, coord, rad );
	getCircleOverlay( list, ID_overlayRectSize, rect3, coord, rad );
	getCircleOverlay( list, ID_overlayRectSize, rect4, coord, rad );
}
