/***************************************************************************
                          kquestion.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Javier Campos Morales
    email                : javi_c@ctv.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kquestion.h"
#include "kquestion.moc"

#include <qlayout.h>
#include <qcolor.h>
#include <qpixmap.h>

KQuestion::KQuestion(QWidget *parent, const char *name ) : QFrame(parent,name)
{
	initGUI();
}

KQuestion::~KQuestion()
{
}

/** Init graphical interface */
void KQuestion::initGUI()
{
	this->setFrameShape( QFrame::Box );
	this->setFrameShadow( QFrame::Plain );
	this->setPalette( QPalette( QColor(255, 255, 255) ) );

	QHBoxLayout *Form1Layout = new QHBoxLayout( this );
	Form1Layout->setSpacing( 0 );
	Form1Layout->setMargin( 5 );

	Picture = new QLabel( this, "PixmapLabel1" );
	Picture->setScaledContents( FALSE );
	Picture->setPalette( QPalette( QColor(255, 255, 255) ) );
	Form1Layout->addWidget( Picture );

	View = new QTextView( this, "TextView1" );
	View->setFrameShape( QTextView::NoFrame );
	View->setHScrollBarMode( QTextView::AlwaysOff );
	View->setTextFormat( QTextView::RichText );
	View->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)7, true ) );
	Form1Layout->addWidget( View );
}

/** Set text */
void KQuestion::setText( const QString &text)
{
	View->setText( text );
}

/** Set pixmap */
void KQuestion::setPixmap( const QString &pixmap)
{
	Picture->setPixmap( QPixmap(pixmap) );
}
