/***************************************************************************
                            QListBox.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QLISTBOX_H
#define QLISTBOX_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QScrollView.h>
#include <qtobjc/QListBoxItem.h>

@class QContextMenuEvent; 
@class QIMEvent; 
@class QTabletEvent; 

@interface QListBox : QScrollView 
- initWithWidget: (QWidget *)parent name: (NSString *)name f: (int)f;
- init;
- (void) dealloc;
- setFont: (QFont *)arg1;
- (unsigned int) count;
- insertStringList: (NSArray *)arg1 index: (int)index;
- insertStringList: (NSArray *)arg1 ;
- insertStrList: (NSArray *)arg1 index: (int)index;
- insertStrList: (NSArray *)arg1 ;
- insertStrList: (NSArray *)arg1 index: (int)index;
- insertStrList: (NSArray *)arg1 ;
- insertStrList: (NSString *)arg1 numStrings: (int)numStrings index: (int)index;
- insertText: (NSString *)arg1 ;
- insertListBoxItem: (QListBoxItem *)arg1 index: (int)index;
- insertListBoxItem: (QListBoxItem *)arg1 ;
- insertListBoxItem: (QListBoxItem *)arg1 after: (QListBoxItem *)after;
- insertTextItem: (NSString *)text index: (int)index;
- insertTextItem: (NSString *)text ;
- insertPixmapItem: (QPixmap *)pixmap index: (int)index;
- insertPixmapItem: (QPixmap *)pixmap ;
- insertPixmapItem: (QPixmap *)pixmap text: (NSString *)text index: (int)index;
- insertPixmapItem: (QPixmap *)pixmap text: (NSString *)text ;
- removeIntItem: (int)index;
- (NSString *) text: (int)index;
- (QPixmap*) pixmap: (int)index;
- changeListBoxItem: (QListBoxItem *)arg1 index: (int)index;
- changeTextItem: (NSString *)text index: (int)index;
- changePixmapItem: (QPixmap *)pixmap index: (int)index;
- changePixmapItem: (QPixmap *)pixmap text: (NSString *)text index: (int)index;
- takeItem: (QListBoxItem *)arg1;
- (int) numItemsVisible;
- (int) currentItem;
- (NSString *) currentText;
- setCurrentItem: (int)index;
- setCurrentListBoxItem: (QListBoxItem *)arg1;
- centerCurrentItem;
- (int) topItem;
- setTopItem: (int)index;
- setBottomItem: (int)index;
- (long) maxItemWidth;
- setSelectionMode: (int)arg1;
- (int) selectionMode;
- setMultiSelection: (BOOL)multi;
- (BOOL) isMultiSelection;
- setListBoxItemSelected: (QListBoxItem *)arg1 bool: (BOOL)arg2;
- setSelected: (int)arg1 bool: (BOOL)arg2;
- (BOOL) isSelected: (int)arg1;
- (BOOL) isListBoxItemSelected: (QListBoxItem *)arg1;
- (QSize*) sizeHint;
- (QSize*) minimumSizeHint;
- (QListBoxItem*) item: (int)index;
- (int) index: (QListBoxItem *)arg1;
- (QListBoxItem*) findListBoxItem: (NSString *)text compare: (int)compare;
- (QListBoxItem*) findListBoxItem: (NSString *)text ;
- triggerUpdate: (BOOL)doLayout;
- (BOOL) itemVisible: (int)index;
- (BOOL) listBoxItemVisible: (QListBoxItem *)arg1;
- setColumnMode: (int)arg1;
//- setColumnMode: (int)arg1;
- setRowMode: (int)arg1;
//- setRowMode: (int)arg1;
- (int) columnMode;
- (int) rowMode;
- (int) numColumns;
- (int) numRows;
- (BOOL) variableWidth;
- setVariableWidth: (BOOL)arg1;
- (BOOL) variableHeight;
- setVariableHeight: (BOOL)arg1;
//- viewportPaintEvent: (QPaintEvent*)arg1;
- (BOOL) dragSelect;
- setDragSelect: (BOOL)arg1;
- (BOOL) autoScroll;
- setAutoScroll: (BOOL)arg1;
- (BOOL) autoScrollBar;
- setAutoScrollBar: (BOOL)enable;
- (BOOL) scrollBar;
- setScrollBar: (BOOL)enable;
- (BOOL) autoBottomScrollBar;
- setAutoBottomScrollBar: (BOOL)enable;
- (BOOL) bottomScrollBar;
- setBottomScrollBar: (BOOL)enable;
- (BOOL) smoothScrolling;
- setSmoothScrolling: (BOOL)arg1;
- (BOOL) autoUpdate;
- setAutoUpdate: (BOOL)arg1;
- setFixedVisibleLines: (int)lines;
- (int) inSort: (QListBoxItem *)arg1;
- (int) inSortWithString: (NSString *)text;
- (int) cellHeight: (int)i;
- (int) cellHeight;
- (int) cellWidth;
- (int) cellWidth: (int)i;
- (int) numCols;
- (int) itemHeight: (int)index;
- (int) itemHeight;
- (QListBoxItem*) itemAt: (QPoint*)arg1;
- (QRect*) itemRect: (QListBoxItem *)item;
- (QListBoxItem*) firstItem;
- sort: (BOOL)ascending;
- sort;
- clear;
- ensureCurrentVisible;
- clearSelection;
- selectAll: (BOOL)select;
- invertSelection;
- (BOOL) eventFilter: (QObject *)o e: (QEvent *)e;
- updateIntItem: (int)index;
- updateListBoxItem: (QListBoxItem *)arg1;
- updateCellWidth;
- (int) totalWidth;
- (int) totalHeight;
- paintCell: (QPainter *)arg1 row: (int)row col: (int)col;
- toggleCurrentItem;
- (BOOL) isRubberSelecting;
- doLayout;
- windowActivationChange: (BOOL)arg1;
- (BOOL) itemYPos: (int)index yPos: (int*)yPos;
- (int) findItem: (int)yPos;
- clearInputString;
+ (int) Single;
+ (int) Multi;
+ (int) Extended;
+ (int) NoSelection;
+ (int) FixedNumber;
+ (int) FitToWidth;
+ (int) FitToHeight;
+ (int) Variable;
@end

/** Override these methods in subclasses of QListBox to customise event handling behaviour */
@protocol QListBoxEventHandling
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) e;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) arg1;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- contentsDropEvent:(QDropEvent*) arg1;
- focusInEvent:(QFocusEvent*) e;
- imEndEvent:(QIMEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) arg1;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- contentsMouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- contentsMouseReleaseEvent:(QMouseEvent*) arg1;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) arg1;
- contentsMouseMoveEvent:(QMouseEvent*) arg1;
- contentsMousePressEvent:(QMouseEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- viewportResizeEvent:(QResizeEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
