/***************************************************************************
                            KImageEffect.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KIMAGEEFFECT_H
#define KIMAGEEFFECT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 This class includes various @ref QImage based graphical effects.

 Everything is
 static, so there is no need to create an instance of this class. You can
 just call the static methods. They are encapsulated here merely to provide
 a common namespace.
 
 @short 
 This class includes various @ref QImage based graphical effects.
*/
@class QImage;
@class QSize;
@class QColor;

@interface  KImageEffect : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Create a gradient from color a to color b of the specified type.

*/
+ (QImage*) gradient: (QSize *)size ca: (QColor *)ca cb: (QColor *)cb type: (int)type ncols: (int)ncols;
+ (QImage*) gradient: (QSize *)size ca: (QColor *)ca cb: (QColor *)cb type: (int)type ;

/** 
 Create an unbalanced gradient.

 An unbalanced gradient is a gradient where the transition from
 color a to color b is not linear, but in this case, exponential.

*/
+ (QImage*) unbalancedGradient: (QSize *)size ca: (QColor *)ca cb: (QColor *)cb type: (int)type xfactor: (int)xfactor yfactor: (int)yfactor ncols: (int)ncols;
+ (QImage*) unbalancedGradient: (QSize *)size ca: (QColor *)ca cb: (QColor *)cb type: (int)type ;

/** 
 Blends a color into the destination image, using an opacity
 value for blending one into another. Very fast direct pixel 
 manipulation is used.

*/
+ (QImage*) blendColor: (QColor *)clr dst: (QImage *)dst opacity: (float)opacity;

/** 
 Blend the src image into the destination image, using an opacity
 value for blending one into another. Very fast direct pixel 
 manipulation is used.

*/
+ (QImage*) blend: (QImage *)src dst: (QImage *)dst opacity: (float)opacity;

/** 
 Blend the provided image into a background of the indicated color.

*/
+ (QImage*) blend: (QImage *)image initial_intensity: (float)initial_intensity bgnd: (QColor *)bgnd eff: (int)eff anti_dir: (BOOL)anti_dir;
+ (QImage*) blend: (QImage *)image initial_intensity: (float)initial_intensity bgnd: (QColor *)bgnd eff: (int)eff ;

/** 
 Blend an image into another one, using a gradient type
 for blending from one to another.

*/
+ (QImage*) blend: (QImage *)image1 image2: (QImage *)image2 gt: (int)gt xf: (int)xf yf: (int)yf;
+ (QImage*) blend: (QImage *)image1 image2: (QImage *)image2 gt: (int)gt ;

/** 
 Blend an image into another one, using a color channel of a
 third image for the decision of blending from one to another.

*/
+ (QImage*) blend: (QImage *)image1 image2: (QImage *)image2 blendImage: (QImage *)blendImage channel: (int)channel;

/** 
 Blend an image into another one, using alpha in the expected way.

*/
+ (BOOL) blend: (QImage *)upper lower: (QImage *)lower output: (QImage *)output;

/** 
 Blend an image into another one, using alpha in the expected way and
 over coordinates @p x and @p y with respect to the lower image.
 The output is a QImage which is the @p upper image already blended
 with the @p lower one, so its size will be (in general) the same than
 @p upper instead of the same size than @p lower like the method above.
 In fact, the size of @p output is like upper's one only when it can be
 painted on lower, if there has to be some clipping, output's size will
 be the clipped area and x and y will be set to the correct up-left corner
 where the clipped rectangle begins.
     
*/
+ (BOOL) blend: (int)x y: (int)y upper: (QImage *)upper lower: (QImage *)lower output: (QImage *)output;

/** 
 Blend an image into another one, using alpha in the expected way and
 over coordinates @p x and @p y with respect to the lower image.
 The output is painted in the own @p lower image. This is an optimization
 of the @ref blend method above provided by convenience.
     
*/
+ (BOOL) blendOnLower: (int)x y: (int)y upper: (QImage *)upper lower: (QImage *)lower;

/** 
 Modifies the intensity of a pixmap's RGB channel component.

*/
+ (QImage*) channelIntensity: (QImage *)image percent: (float)percent channel: (int)channel;

/** 
 Fade an image to a certain background color.

 The number of colors will not be changed.

*/
+ (QImage*) fade: (QImage *)img val: (float)val color: (QColor *)color;

/** 
 This recolors a pixmap. The most dark color will become color a,
 the most bright one color b, and in between.

*/
+ (QImage*) flatten: (QImage *)image ca: (QColor *)ca cb: (QColor *)cb ncols: (int)ncols;
+ (QImage*) flatten: (QImage *)image ca: (QColor *)ca cb: (QColor *)cb ;

/** 
 Build a hash on any given @ref QImage

*/
+ (QImage*) hash: (QImage *)image lite: (int)lite spacing: (unsigned int)spacing;
+ (QImage*) hash: (QImage *)image ;

/** 
 Either brighten or dim the image by a specified percent.
 For example, .50 will modify the colors by 50%.

*/
+ (QImage*) intensity: (QImage *)image percent: (float)percent;

/** 
 Modulate the image with a color channel of another image.

*/
+ (QImage*) modulate: (QImage *)image modImage: (QImage *)modImage reverse: (BOOL)reverse type: (int)type factor: (int)factor channel: (int)channel;

/** 
 Convert an image to grayscale.

*/
+ (QImage*) toGray: (QImage *)image fast: (BOOL)fast;
+ (QImage*) toGray: (QImage *)image ;

/** 
 Desaturate an image evenly.

*/
+ (QImage*) desaturate: (QImage *)image desat: (float)desat;
+ (QImage*) desaturate: (QImage *)image ;

/** 
 Fast, but low quality contrast of an image. Also see contrastHSV.

*/
+ (QImage*) contrast: (QImage *)image c: (int)c;

/** 
 Dither an image using Floyd-Steinberg dithering for low-color
 situations.

*/
+ (QImage*) dither: (QImage *)img palette: (QColor*)palette size: (int)size;

/** 
 Calculate the image for a selected image, for instance a selected icon
 on the desktop.

*/
+ (QImage*) selectedImage: (QImage *)img col: (QColor *)col;

/** 
 High quality, expensive HSV contrast. You can do a faster one by just
 taking a intensity threshold (ie: 128) and incrementing RGB color
 channels above it and decrementing those below it, but this gives much
 better results.

*/
+ contrastHSV: (QImage *)img sharpen: (BOOL)sharpen;
+ contrastHSV: (QImage *)img ;

/** 
 Normalizes the pixel values to span the full range of color values.
 This is a contrast enhancement technique.

*/
+ normalize: (QImage *)img;

/** 
 Performs histogram equalization on the reference
 image.

*/
+ equalize: (QImage *)img;

/** 
 Thresholds the reference image. You can also threshold images by using
 ThresholdDither in the various QPixmap/QImage convert methods, but this
 lets you specify a threshold value.

*/
+ threshold: (QImage *)img value: (unsigned int)value;
+ threshold: (QImage *)img ;

/** 
 Produces a 'solarization' effect seen when exposing a photographic
 film to light during the development process.

*/
+ solarize: (QImage *)img factor: (double)factor;
+ solarize: (QImage *)img ;

/** 
 Embosses the source image. This involves highlighting the edges
 and applying various other enhancements in order to get a metal
 effect.

*/
+ (QImage*) emboss: (QImage *)src;

/** 
 Minimizes speckle noise in the source image using the 8 hull
 algorithm.

*/
+ (QImage*) despeckle: (QImage *)src;

/** 
 Produces a neat little "charcoal" effect.

*/
+ (QImage*) charcoal: (QImage *)src factor: (double)factor;
+ (QImage*) charcoal: (QImage *)src ;

/** 
 Rotates the image by the specified amount

*/
+ (QImage*) rotate: (QImage *)src r: (int)r;

/** 
 Scales an image using simple pixel sampling. This does not produce
 nearly as nice a result as -[QImage smoothScale], but has the
 advantage of being much faster - only a few milliseconds.

*/
+ (QImage*) sample: (QImage *)src w: (int)w h: (int)h;

/** 
 Adds noise to an image.

*/
+ (QImage*) addNoise: (QImage *)src type: (int)type;
+ (QImage*) addNoise: (QImage *)src ;

/** 
 Blurs an image by convolving pixel neighborhoods.

*/
+ (QImage*) blur: (QImage *)src factor: (double)factor;
+ (QImage*) blur: (QImage *)src ;

/** 
 Detects edges in an image using pixel neighborhoods and an edge
 detection mask.

*/
+ (QImage*) edge: (QImage *)src factor: (double)factor;
+ (QImage*) edge: (QImage *)src ;

/** 
 Implodes an image by a specified percent.

*/
+ (QImage*) implode: (QImage *)src factor: (double)factor background: (unsigned int)background;
+ (QImage*) implode: (QImage *)src ;

/** 
 Produces an oil painting effect.

*/
+ (QImage*) oilPaint: (QImage *)src radius: (int)radius;
+ (QImage*) oilPaint: (QImage *)src ;

/** 
 Sharpens the pixels in the image using pixel neighborhoods.

*/
+ (QImage*) sharpen: (QImage *)src factor: (double)factor;
+ (QImage*) sharpen: (QImage *)src ;

/** 
 Randomly displaces pixels.

*/
+ (QImage*) spread: (QImage *)src amount: (unsigned int)amount;
+ (QImage*) spread: (QImage *)src ;

/** 
 Shades the image using a distance light source.

*/
+ (QImage*) shade: (QImage *)src color_shading: (BOOL)color_shading azimuth: (double)azimuth elevation: (double)elevation;
+ (QImage*) shade: (QImage *)src ;

/** 
 Swirls the image by a specified amount

*/
+ (QImage*) swirl: (QImage *)src degrees: (double)degrees background: (unsigned int)background;
+ (QImage*) swirl: (QImage *)src ;

/** 
 Modifies the pixels along a sine wave.

*/
+ (QImage*) wave: (QImage *)src amplitude: (double)amplitude frequency: (double)frequency background: (unsigned int)background;
+ (QImage*) wave: (QImage *)src ;
+ (int) VerticalGradient;
+ (int) HorizontalGradient;
+ (int) DiagonalGradient;
+ (int) CrossDiagonalGradient;
+ (int) PyramidGradient;
+ (int) RectangleGradient;
+ (int) PipeCrossGradient;
+ (int) EllipticGradient;
+ (int) Red;
+ (int) Green;
+ (int) Blue;
+ (int) Gray;
+ (int) All;
+ (int) NorthLite;
+ (int) NWLite;
+ (int) WestLite;
+ (int) SWLite;
+ (int) SouthLite;
+ (int) SELite;
+ (int) EastLite;
+ (int) NELite;
+ (int) Intensity;
+ (int) Saturation;
+ (int) HueShift;
+ (int) Contrast;
+ (int) UniformNoise;
+ (int) GaussianNoise;
+ (int) MultiplicativeGaussianNoise;
+ (int) ImpulseNoise;
+ (int) LaplacianNoise;
+ (int) PoissonNoise;
+ (int) Rotate90;
+ (int) Rotate180;
+ (int) Rotate270;
@end

#endif
