/***************************************************************************
                            KRun.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 To open files with their associated applications in KDE, use KRun.

 It can execute any desktop entry, as well as any file, using
 the default application or another application "bound" to the file type.

 In that example, the mimetype of the file is not known by the application,
 so a KRun instance must be created. It will determine the mimetype by itself.
 If the mimetype is known, or if you even know the service (application) to
 use for this file, use one of the static methods.

 See {@link KRunSignals} for signals emitted by KRun.

 See {@link KRunEventHandling} for event handlers to override in subclasses of KRun.

 @short Opens files with their associated applications in KDE.
*/
public class KRun extends QObject  {
	protected KRun(Class dummy){super((Class) null);}

	private native void newKRun( KURL url, long mode, boolean isLocalFile, boolean showProgressInfo);

/** 
 Create a KRun object to run the preferred application for a file/URL.
 KRun will first determine the type of the file, and will then
 run the associated application.

*/
	public KRun( KURL url, long mode, boolean isLocalFile, boolean showProgressInfo) {
		super((Class) null);
		newKRun( url, mode, isLocalFile, showProgressInfo);
	}
	private native void newKRun( KURL url);
	public KRun( KURL url) {
		super((Class) null);
		newKRun( url);
	}

/** 
 Destructor. Don't call it yourself, since a KRun object auto-deletes
 itself.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Abort this KRun. This kills any jobs launched by it,
 and leads to deletion if auto-deletion is on.
 This is much safer than deleting the KRun (in case it's
 currently showing an error dialog box, for instance)
   
*/
	public native void abort();
	public native boolean hasError();
	public native boolean hasFinished();

/** 
 By default auto deletion is on.
   
*/
	public native boolean autoDelete();
	public native void setAutoDelete( boolean b);

/** 
 Open a list of URLs with a certain service.

*/
	public static native long run( KService _service, ArrayList _urls);

/** 
 Open a list of URLs with.

*/
	public static native long run( String _exec, ArrayList _urls, String _name, String _icon, String _obsolete1, String _obsolete2);
	public static native long run( String _exec, ArrayList _urls);

/** 
 Open the given URL.

 This function is used after the mime type
 is found out. It will search for all services which can handle
 the mime type and call {@link #run} afterwards.
   
*/
	public static native long runURL( KURL _url, String _mimetype);

/** 
 Run the given shell command and notifies kicker of the starting
 of the application. If the program to be called doesn't exist,
 an error box will be displayed.

 <code>_cmd</code> must be a shell command. You must not append "&"
 to it, since the function will do that for you.

 Use only when you know the full command line. Otherwise use the other
 static methods, or KRun's constructor.
   
*/
	public static native long runCommand( String cmd);

/** 
 Same as the other runCommand, but it also takes the name of the
 binary, to display an error message in case it couldn't find it.

*/
	public static native long runCommand( String cmd, String execName, String icon);

/** 
 Display the Open-With dialog for those URLs, and run the chosen application.

*/
	public static native boolean displayOpenWithDialog( ArrayList lst);

/** 
 Quotes a string for the shell
   
*/
	public static native void shellQuote( String _str);

/** 
 Processes a Exec= line as found in .desktop files.

*/
	public static native ArrayList processDesktopExec( KService _service, ArrayList _urls, boolean has_shell);
	protected native void init();
	protected native void scanFile();

/** 
 Called if the mimetype has been detected. The function checks
 whether the document and appends the gzip protocol to the
 URL. Otherwise {@link #runURL} is called to finish the job.
   
*/
	protected native void foundMimeType( String _type);
	protected native void killJob();
	protected native void slotTimeout();
	protected native void slotScanFinished( Job arg1);
	protected native void slotScanMimeType( Job arg1, String type);
	protected native void slotStatResult( Job arg1);
}
