/***************************************************************************
                            KEdit.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A simple text editor for the KDE project.

 See {@link KEditSignals} for signals emitted by KEdit.

 See {@link KEditEventHandling} for event handlers to override in subclasses of KEdit.

 @author Bernd Johannes Wuebben <wuebben@math.cornell.edu>, Waldo Bastian <bastian@kde.org>

 @short 
 A simple text editor for the KDE project.
*/
public class KEdit extends QMultiLineEdit  {
	protected KEdit(Class dummy){super((Class) null);}

	private native void newKEdit( QWidget _parent, String name);

/** 
 The usual constructor.

*/
	public KEdit( QWidget _parent, String name) {
		super((Class) null);
		newKEdit( _parent, name);
	}
	private native void newKEdit();
	public KEdit() {
		super((Class) null);
		newKEdit();
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Insert text from the text stream into the edit widget.

*/
	public native void insertText( QTextStream arg1);

/** 
 Save text from the edit widget to a text stream.

*/
	public native void saveText( QTextStream arg1);

/** 
  Let the user select a font and set the font of the textwidget to that
 selected font.

*/
	public native void selectFont();

/** 
 Present a search dialog to the user

*/
	public native void search();

/** 
 Repeat the last search specified on the search dialog.

  If the user hasn't searched for anything until now, this method
   will simply return without doing anything.

*/
	public native boolean repeatSearch();

/** 
 Present a Search and Replace Dialog to the user.

*/
	public native void replace();

/** 
 Present a "Goto Line" dialog to the user.
     
*/
	public native void doGotoLine();

/** 
 Clean up redundant whitespace from selected text.
     
*/
	public native void cleanWhiteSpace();

/** 
 Install a context menu for KEdit.

  The Popup Menu will be activated on a right mouse button press event.
     
*/
	public native void installRBPopup( QPopupMenu arg1);

/** 
 Retrieve the current line number.

 The current line is the line the cursor is on.

*/
	public native int currentLine();

/** 
 Retrieve the actual column number the cursor is on.

  This call differs
    from {@link QMultiLineEdit#getCursorPosition} in that it returns the actual cursor
    position and not the character position. Use {@link #currentLine} and {@link #currentColumn}
    if you want to display the current line or column in the status bar for
    example.
     
*/
	public native int currentColumn();

/** 
 Start spellchecking mode.
     
*/
	public native void spellcheck_start();

/** 
 Exit spellchecking mode.
     
*/
	public native void spellcheck_stop();

/** 
 Allow the user to toggle between insert mode and overwrite mode with
 the "Insert" key. See also {@link #toggle_overwrite_signal};

 The default is false: the user can not toggle.
     
*/
	public native void setOverwriteEnabled( boolean b);
	protected native void computePosition();
	protected native int doSearch( String s_pattern, boolean case_sensitive, boolean regex, boolean forward, int line, int col);
	protected native int doReplace( String s_pattern, boolean case_sensitive, boolean regex, boolean forward, int line, int col, boolean replace);

/** 
 Sets line and col to the position pos, considering word wrap.

*/
	protected native void posToRowCol( int pos, int line, int col);

/** 
 Reimplemented for internal reasons, the API is not affected.
     
*/
	protected native void create( int arg1, boolean initializeWindow, boolean destroyOldWindow);
	protected native void create();
	protected native void keyPressEvent( QKeyEvent arg1);
	protected native void dragMoveEvent( QDragMoveEvent e);
	protected native void dragEnterEvent( QDragEnterEvent e);
	protected native void dropEvent( QDropEvent e);
	public static final int NONE = 0;
	public static final int FORWARD = 1;
	public static final int BACKWARD = 2;
}
