/***************************************************************************
                            KDataToolInfo.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This is a convenience class for {@link KService}. You can use it if you have
 a KService describing a KDataTool. In this case the KDataToolInfo class
 is more convenient to work with.

 Especially useful is the method {@link #createTool} which creates the datatool
 described by the service.
 
 @short 
 This is a convenience class for @ref KService.
*/
public class  KDataToolInfo implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KDataToolInfo(Class dummy){}

	private native void newKDataToolInfo();

/** 
 Create an invalid KDataToolInfo.
     
*/
	public KDataToolInfo() {
		newKDataToolInfo();
	}
//	private native void newKDataToolInfo( KServicePtr service, KInstanceInterface instance);

/** 
 Create a valid KDataToolInfo.
     
*/
//	public KDataToolInfo( KServicePtr service, KInstanceInterface instance) {
//		newKDataToolInfo( service, instance);
//	}
	private native void newKDataToolInfo( KDataToolInfo info);

/** 
 Copy constructor.
     
*/
	public KDataToolInfo( KDataToolInfo info) {
		newKDataToolInfo( info);
	}

/** 

*/
	public native String dataType();

/** 

 The mimetypes are only used if the {@link #dataType} can be used to store
 different mimetypes. For example in a "String" you could save "text/plain"
 or "text/html" or "text/xml".
     
*/
	public native ArrayList mimeTypes();

/** 

*/
	public native boolean isReadOnly();

/** 

     
*/
	public native QPixmap icon();

/** 

     
*/
	public native QPixmap miniIcon();

/** 

*/
	public native String iconName();

/** 

 This list comes from the Comment field of the tool's desktop file
 (so that it can be translated).

 Each of the strings returned corresponds to a string in the list returned by
 {@link #commands.}
     
*/
	public native ArrayList userCommands();

/** 

 This list comes from the Commands field of the tool's desktop file.

 Each of the strings returned corresponds to a string in the list returned by
 {@link #userCommands.}
     
*/
	public native ArrayList commands();

/** 
 Creates the data tool described by this KDataToolInfo.

*/
	public native KDataTool createTool( QObject parent, String name);
	public native KDataTool createTool();
//	public native KService_Ptr service();
	public native KInstanceInterface instance();

/** 
 A DataToolInfo may be invalid if the {@link KService} passed to its constructor does
 not feature the service type "KDataTool".
     
*/
	public native boolean isValid();

/** 
 Queries the {@link KTrader} about installed {@link KDataTool} implementations.

*/
//	public static native QValueList<KDataToolInfo> query( String datatype, String mimetype, KInstanceInterface instance);
}
