/***************************************************************************
                            KAudioPlayer.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class provides one-shot-and-forget audio playing. You will never
 know if what you wanted to play really got played.

 It doesn't require linking any special libraries, as it operates over
 DCOP. In the current implementation, it only indirectly communicates
 with the aRts soundserver, using knotify as DCOP . MCOP bridge.

 Due to that fact, if you need "fast" response times, more control or
 feedback, use the MCOP interfaces rather than this.

 An example of using this class is:

 <pre>
   KAudioPlayer.play("/var/share/foo.wav");
 </pre>

 If you want to use signals & slots, you can do something like:

 <pre>
   KAudioPlayer player("/var/share/foo.wav");
   connect(&button, SIGNAL("clicked()"), &player, SLOT("play()"));
 </pre>

 
 See {@link KAudioPlayerSignals} for signals emitted by KAudioPlayer.

 See {@link KAudioPlayerEventHandling} for event handlers to override in subclasses of KAudioPlayer.

 @short 
 This class provides one-shot-and-forget audio playing.
*/
public class KAudioPlayer extends QObject  {
	protected KAudioPlayer(Class dummy){super((Class) null);}

	private native void newKAudioPlayer( String filename, QObject parent, String name);

/** 
 Constructor.

*/
	public KAudioPlayer( String filename, QObject parent, String name) {
		super((Class) null);
		newKAudioPlayer( filename, parent, name);
	}
	private native void newKAudioPlayer( String filename);
	public KAudioPlayer( String filename) {
		super((Class) null);
		newKAudioPlayer( filename);
	}

/** 
 Destructor.
	 
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Play function as slot.

 Plays the soundfile given to the constructor.
	 
*/
	public native void play();

/** 
 Static play function.

*/
	public static native void play( String filename);
}
