/***************************************************************************
                            HTMLFrameElement.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Create a frame. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#edef-FRAME">
 FRAME element definition </a> in HTML 4.0.

 
 @short 
 Create a frame.
*/
public class HTMLFrameElement extends HTMLElement  {
	protected HTMLFrameElement(Class dummy){super((Class) null);}

	private native void newHTMLFrameElement();
	public HTMLFrameElement() {
		super((Class) null);
		newHTMLFrameElement();
	}
	private native void newHTMLFrameElement( HTMLFrameElement other);
	public HTMLFrameElement( HTMLFrameElement other) {
		super((Class) null);
		newHTMLFrameElement( other);
	}
	private native void newHTMLFrameElement( DOMNode other);
	public HTMLFrameElement( DOMNode other) {
		super((Class) null);
		newHTMLFrameElement( other);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Request frame borders. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-frameborder">
 frameborder attribute definition </a> in HTML 4.0.

     
*/
	public native String frameBorder();

/** 
 see {@link frameBorder}
     
*/
	public native void setFrameBorder( String arg1);

/** 
 URI designating a long description of this image or frame. See
 the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-longdesc-FRAME">
 longdesc attribute definition </a> in HTML 4.0.

     
*/
	public native String longDesc();

/** 
 see {@link longDesc}
     
*/
	public native void setLongDesc( String arg1);

/** 
 Frame margin height, in pixels. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-marginheight">
 marginheight attribute definition </a> in HTML 4.0.

     
*/
	public native String marginHeight();

/** 
 see {@link marginHeight}
     
*/
	public native void setMarginHeight( String arg1);

/** 
 Frame margin width, in pixels. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-marginwidth">
 marginwidth attribute definition </a> in HTML 4.0.

     
*/
	public native String marginWidth();

/** 
 see {@link marginWidth}
     
*/
	public native void setMarginWidth( String arg1);

/** 
 The frame name (object of the <code> target </code> attribute).
 See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-name-FRAME">
 name attribute definition </a> in HTML 4.0.

     
*/
	public native String name();

/** 
 see {@link name}
     
*/
	public native void setName( String arg1);

/** 
 When true, forbid user from resizing frame. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-noresize">
 noresize attribute definition </a> in HTML 4.0.

     
*/
	public native boolean noResize();

/** 
 see {@link noResize}
     
*/
	public native void setNoResize( boolean arg1);

/** 
 Specify whether or not the frame should have scrollbars. See
 the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-scrolling">
 scrolling attribute definition </a> in HTML 4.0.

     
*/
	public native String scrolling();

/** 
 see {@link scrolling}
     
*/
	public native void setScrolling( String arg1);

/** 
 A URI designating the initial frame contents. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-src-FRAME">
 src attribute definition </a> in HTML 4.0.

     
*/
	public native String src();

/** 
 see {@link src}
     
*/
	public native void setSrc( String arg1);

/** 
 Introduced in DOM Level 2

 Returns the document this frame contains, if there is any and
 it is available, a Null document otherwise. The attribute is
 read-only.

*/
	public native DOMDocument contentDocument();
}
