/***************************************************************************
                            kde_SimpleJob.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_SIMPLEJOB
#define KDE_SIMPLEJOB

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 A simple job (one url and one command).
 This is the base class for all jobs that are scheduled.
 Other jobs are high-level jobs (CopyJob, DeleteJob, FileCopyJob...)
 that manage subjobs but aren't scheduled directly.
     
 @short 
 A simple job (one url and one command).
*/
kde_SimpleJob * kde_new_SimpleJob(kde_KURL* url, int command, qt_QByteArray* packedArgs, int showProgressInfo);
void kde_del_SimpleJob( kde_SimpleJob* p );
kde_KURL* kde_SimpleJob_url(kde_SimpleJob* instPointer);

/** 
 Abort job.
 This kills all subjobs and deletes the job.

*/
void kde_SimpleJob_kill(kde_SimpleJob* instPointer,int quietly);

/** 
 Abort job.
 Suspends slave to be reused by another job for the same request.
         
*/
void kde_SimpleJob_putOnHold(kde_SimpleJob* instPointer);

/** 

 Called by the scheduler when a slave gets to
 work on this job.

*/
void kde_SimpleJob_start(kde_SimpleJob* instPointer,kde_Slave* slave);

/** 

 Called to detach a slave from a job.

*/
void kde_SimpleJob_slaveDone(kde_SimpleJob* instPointer);

/** 

 Slave in use by this job.
         
*/
kde_Slave* kde_SimpleJob_slave(kde_SimpleJob* instPointer);

/** 

         
*/
int kde_SimpleJob_command(kde_SimpleJob* instPointer);

/** 

 Called on a slave's error.
 Made public for the scheduler.
         
*/
void kde_SimpleJob_slotError(kde_SimpleJob* instPointer,int arg1, qt_QString * arg2);

/** 
 Discard suspended slave.
         
*/
void kde_SimpleJob_removeOnHold( );

/** 
 Called when the slave marks the job
 as finished.
         
*/
void kde_SimpleJob_slotFinished(kde_SimpleJob* instPointer);

/** 

 Called on a slave's warning.
         
*/
void kde_SimpleJob_slotWarning(kde_SimpleJob* instPointer,qt_QString * arg1);

/** 
 Called on a slave's info message.
         
*/
void kde_SimpleJob_slotInfoMessage(kde_SimpleJob* instPointer,qt_QString * arg1);

/** 
 Called on a slave's connected signal.
         
*/
void kde_SimpleJob_slotConnected(kde_SimpleJob* instPointer);

/** 
 Forward signal from the slave
         
*/
//void kde_SimpleJob_slotTotalSize(kde_SimpleJob* instPointer,KIO::filesize_t data_size);

/** 
 Forward signal from the slave
         
*/
//void kde_SimpleJob_slotProcessedSize(kde_SimpleJob* instPointer,KIO::filesize_t data_size);

/** 
 Forward signal from the slave
         
*/
void kde_SimpleJob_slotSpeed(kde_SimpleJob* instPointer,unsigned long bytes_per_second);

/** 
 MetaData from the slave is received.
         
*/
void kde_SimpleJob_slotMetaData(kde_SimpleJob* instPointer,kde_MetaData* _metaData);

/** 

         
*/
void kde_SimpleJob_slotNeedProgressId(kde_SimpleJob* instPointer);

#endif
