/***************************************************************************
                            kde_KIconEffect.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KICONEFFECT
#define KDE_KICONEFFECT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Applies effects to icons.
 
 @short 
 Applies effects to icons.
*/
#define KICONEFFECT_NoEffect	0
#define KICONEFFECT_ToGray	1
#define KICONEFFECT_Colorize	2
#define KICONEFFECT_ToGamma	3
#define KICONEFFECT_DeSaturate	4
#define KICONEFFECT_LastEffect	5
kde_KIconEffect * kde_new_KIconEffect();
void kde_del_KIconEffect( kde_KIconEffect* p );

/** 
 Rereads configuration.
     
*/
void kde_KIconEffect_init(kde_KIconEffect* instPointer);

/**  

*/
int kde_KIconEffect_hasEffect(kde_KIconEffect* instPointer,int group, int state);

/** 
 Returns a fingerprint for the effect selected by 
 [@p group, @p state]. This is useful for caching.
     
*/
qt_QString * kde_KIconEffect_fingerprint(kde_KIconEffect* instPointer,int group, int state);

/** 
 Applies an effect to an image. The effect to apply depends on the
 @p group and @p state parameters, and is configured by the user.

*/
qt_QImage * kde_KIconEffect_apply(kde_KIconEffect* instPointer,qt_QImage * src, int group, int state);

/** 
 Applies an effect to an image.

*/
qt_QImage * kde_KIconEffect_apply1(kde_KIconEffect* instPointer,qt_QImage * src, int effect, float value, qt_QColor * rgb, int trans);

/** 
 Applies an effect to a pixmap.
     
*/
qt_QPixmap * kde_KIconEffect_apply2(kde_KIconEffect* instPointer,qt_QPixmap * src, int group, int state);

/** 
 Applies an effect to a pixmap.
     
*/
qt_QPixmap * kde_KIconEffect_apply3(kde_KIconEffect* instPointer,qt_QPixmap * src, int effect, float value, qt_QColor * rgb, int trans);

/** 
 Returns an image twice as large, consisting of 2x2 pixels.
     
*/
qt_QImage * kde_KIconEffect_doublePixels(kde_KIconEffect* instPointer,qt_QImage * src);

/** 
 Provides visual feedback to show activation of an icon on a widget.

 Not strictly an 'icon effect', but in practice that's what it looks
 like.
     
*/
void kde_KIconEffect_visualActivate( qt_QWidget * arg1, qt_QRect* arg2);
void kde_KIconEffect_toGray( qt_QImage * image, float value);
void kde_KIconEffect_colorize( qt_QImage * image, qt_QColor * col, float value);
void kde_KIconEffect_deSaturate( qt_QImage * image, float value);
void kde_KIconEffect_toGamma( qt_QImage * image, float value);
void kde_KIconEffect_semiTransparent( qt_QImage * image);
void kde_KIconEffect_semiTransparent1( qt_QPixmap * pixmap);
void kde_KIconEffect_overlay( qt_QImage * src, qt_QImage * overlay);

#endif
